/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.commandswitch.CommandSwitch;
import io.github.gaming32.bingo.data.BingoDifficulties;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.data.goal.GoalManager;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.game.BoardShape;
import io.github.gaming32.bingo.game.InvalidGoalException;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import io.github.gaming32.bingo.network.messages.s2c.RemoveBoardPayload;
import io.github.gaming32.bingo.util.Vec2i;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2177;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2243;
import net.minecraft.class_2245;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6673;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7079;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;

public class BingoCommand {
    private static final SimpleCommandExceptionType NO_GAME_RUNNING = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.no_game_running", new Object[0]));
    private static final DynamicCommandExceptionType INVALID_SHAPE = new DynamicCommandExceptionType(shape -> Bingo.translatableEscape("bingo.invalid_shape", shape));
    private static final Dynamic3CommandExceptionType INVALID_SIZE = new Dynamic3CommandExceptionType((size, min, max) -> Bingo.translatableEscape("bingo.invalid_size", size, min, max));
    private static final DynamicCommandExceptionType CANNOT_SHOW_BOARD = new DynamicCommandExceptionType(size -> Bingo.translatableEscape("bingo.cannot_show_board", size));
    private static final DynamicCommandExceptionType TEAM_ALREADY_EXISTS = new DynamicCommandExceptionType(team -> Bingo.translatableEscape("bingo.team_already_exists", ((class_268)team).method_1148()));
    private static final DynamicCommandExceptionType DUPLICATE_TEAMS = new DynamicCommandExceptionType(team -> Bingo.translatableEscape("bingo.duplicate_teams", ((class_268)team).method_1148()));
    private static final DynamicCommandExceptionType UNKNOWN_DIFFICULTY = new DynamicCommandExceptionType(difficultyId -> Bingo.translatableEscape("bingo.unknown_difficulty", difficultyId));
    private static final DynamicCommandExceptionType UNKNOWN_GOAL = new DynamicCommandExceptionType(goalId -> Bingo.translatableEscape("bingo.unknown_goal", goalId));
    private static final DynamicCommandExceptionType UNKNOWN_TAG = new DynamicCommandExceptionType(tagId -> Bingo.translatableEscape("bingo.unknown_tag", tagId));
    private static final DynamicCommandExceptionType UNKNOWN_GAMEMODE = new DynamicCommandExceptionType(gamemodeId -> Bingo.translatableEscape("bingo.unknown_gamemode", gamemodeId));
    private static final DynamicCommandExceptionType INVALID_GOAL = new DynamicCommandExceptionType(e -> Bingo.translatable("bingo.start.invalid_goal", new Object[0]).method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)((InvalidGoalException)e).getMessage())))));
    private static final DynamicCommandExceptionType FAILED_TO_START = new DynamicCommandExceptionType(e -> Bingo.translatable("bingo.start.failed", new Object[0]).method_27694(s -> s.method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)((Throwable)e).getMessage())))));
    private static final SimpleCommandExceptionType NO_TEAMS = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.no_teams", new Object[0]));
    private static final SimpleCommandExceptionType NOT_IN_TEAM = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.not_in_team", new Object[0]));
    private static final SimpleCommandExceptionType FORFEIT_ALREADY_FINISHED = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.forfeit.already_finished", new Object[0]));
    private static final DynamicCommandExceptionType TEAM_NOT_PLAYING = new DynamicCommandExceptionType(team -> Bingo.translatableEscape("bingo.team_not_playing", team));
    private static final SimpleCommandExceptionType ALREADY_NERFED = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.already_nerfed", new Object[0]));
    private static final SimpleCommandExceptionType NOT_NERFED = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.not_nerfed", new Object[0]));
    private static final SuggestionProvider<class_2168> ACTIVE_GOAL_SUGGESTOR = (context, builder) -> {
        BingoGame game = ((MinecraftServerExt)((class_2168)context.getSource()).method_9211()).bingo$getGame();
        if (game == null) {
            return builder.buildFuture();
        }
        return class_2172.method_9257(Arrays.stream(game.getBoard().getGoals()).map(ActiveGoal::id), (SuggestionsBuilder)builder);
    };
    private static final CommandSwitch<Boolean> REQUIRE_CLIENT = CommandSwitch.storeTrue("--require-client");
    private static final CommandSwitch<Boolean> CONTINUE_AFTER_WIN = CommandSwitch.storeTrue("--continue-after-win");
    private static final CommandSwitch<Boolean> INCLUDE_INACTIVE_TEAMS = CommandSwitch.storeTrue("--include-inactive-teams");
    private static final CommandSwitch<String> SHAPE = CommandSwitch.argument("--shape", StringArgumentType.word()).suggests((SuggestionProvider<class_2168>)((SuggestionProvider)(ctx, builder) -> class_2172.method_9264(Arrays.stream(BoardShape.values()).map(BoardShape::method_15434), (SuggestionsBuilder)builder))).build(BoardShape.SQUARE.method_15434());
    private static final CommandSwitch<Integer> SIZE = CommandSwitch.argument("--size", IntegerArgumentType.integer()).build(5);
    private static final CommandSwitch<Long> SEED = CommandSwitch.argument("--seed", LongArgumentType.longArg()).build((Long)((Object)((Supplier<Long>)class_6673::method_39001)));
    private static final CommandSwitch<Integer> AUTO_FORFEIT_TIME = CommandSwitch.argument("--auto-forfeit-time", class_2245.method_48287((int)0)).getter(IntegerArgumentType::getInteger).build(2400);
    private static final CommandSwitch<class_6880.class_6883<BingoDifficulty>> DIFFICULTY = CommandSwitch.resource("--difficulty", BingoRegistries.DIFFICULTY).unknownExceptionType(UNKNOWN_DIFFICULTY).build(BingoDifficulties.MEDIUM);
    private static final CommandSwitch<class_6880.class_6883<BingoGameMode>> GAMEMODE = CommandSwitch.resource("--gamemode", BingoRegistries.GAME_MODE).unknownExceptionType(UNKNOWN_GAMEMODE).build(BingoGameMode.STANDARD.key());
    private static final CommandSwitch<Set<GoalHolder>> REQUIRE_GOAL = CommandSwitch.specialArgument("--require-goal", class_7079.method_41224(BingoRegistries.GOAL)).getter((context, arg) -> {
        class_5321 key = class_7079.method_41220((CommandContext)context, (String)arg, BingoRegistries.GOAL, (DynamicCommandExceptionType)INVALID_GOAL);
        GoalHolder goal = GoalManager.getGoal(key.method_29177());
        if (goal == null) {
            throw UNKNOWN_GOAL.create((Object)key.method_29177());
        }
        return goal;
    }).buildRepeatable(LinkedHashSet::new);
    private static final CommandSwitch<class_6885<BingoTag>> EXCLUDE_TAG = CommandSwitch.resource("--exclude-tag", BingoRegistries.TAG).unknownExceptionType(UNKNOWN_TAG).buildRepeatable();

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext, class_2170.class_5364 selection) {
        LiteralCommandNode bingoCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bingo").then(class_2170.method_9247((String)"start").requires(source -> source.method_9259(2)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"stop").requires(source -> source.method_9259(2) && ((MinecraftServerExt)source.method_9211()).bingo$getGame() != null)).executes(ctx -> {
            BingoGame game = ((MinecraftServerExt)((class_2168)ctx.getSource()).method_9211()).bingo$getGame();
            if (game == null) {
                throw NO_GAME_RUNNING.create();
            }
            game.endGame(((class_2168)ctx.getSource()).method_9211().method_3760());
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(source -> source.method_9259(2))).executes(BingoCommand::resetGame))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"forfeit").requires(source -> ((MinecraftServerExt)source.method_9211()).bingo$getGame() != null)).executes(ctx -> BingoCommand.forfeit((class_2168)ctx.getSource()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"team", (ArgumentType)class_2243.method_9482()).requires(source -> source.method_9259(2) && ((MinecraftServerExt)source.method_9211()).bingo$getGame() != null)).executes(ctx -> BingoCommand.forfeit((class_2168)ctx.getSource(), class_2243.method_9480((CommandContext)ctx, (String)"team")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"board").requires(source -> ((MinecraftServerExt)source.method_9211()).bingo$getGame() != null)).executes(ctx -> {
            final BingoGame game = ((MinecraftServerExt)((class_2168)ctx.getSource()).method_9211()).bingo$getGame();
            if (game == null) {
                throw NO_GAME_RUNNING.create();
            }
            final int size = game.getBoard().getSize();
            final Vec2i visualSize = game.getBoard().getShape().getVisualSize(size);
            if (visualSize.x() > 9) {
                throw CANNOT_SHOW_BOARD.create((Object)size);
            }
            final class_3917 menuType = switch (visualSize.y()) {
                case 1 -> class_3917.field_18664;
                case 2 -> class_3917.field_18665;
                case 3 -> class_3917.field_17326;
                case 4 -> class_3917.field_18666;
                case 5 -> class_3917.field_18667;
                case 6 -> class_3917.field_17327;
                default -> throw CANNOT_SHOW_BOARD.create((Object)size);
            };
            final class_5455 registries = ((class_2168)ctx.getSource()).method_30497();
            ((class_2168)ctx.getSource()).method_9207().method_17355(new class_3908(){

                public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
                    class_1707 menu = new class_1707(this, menuType, syncId, inventory, (class_1263)new class_1277(9 * visualSize.y()), visualSize.y()){

                        public void method_7593(int slotId, int button, class_1713 clickType, class_1657 player) {
                            this.method_34252();
                        }
                    };
                    int minX = (9 - visualSize.x()) / 2;
                    for (int goalIndex = 0; goalIndex < game.getBoard().getGoals().length; ++goalIndex) {
                        Vec2i goalPos = game.getBoard().getShape().getCoords(size, goalIndex);
                        menu.method_7629().method_5447(minX + goalPos.y() * 9 + goalPos.x(), game.getBoard().getGoals()[goalIndex].getFallbackWithComponents(registries));
                    }
                    return menu;
                }

                @NotNull
                public class_2561 method_5476() {
                    return Bingo.translatable("bingo.board.title", new Object[0]);
                }
            });
            return 1;
        })).then(class_2170.method_9247((String)"copy").executes(ctx -> {
            BingoGame game = ((MinecraftServerExt)((class_2168)ctx.getSource()).method_9211()).bingo$getGame();
            if (game == null) {
                throw NO_GAME_RUNNING.create();
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2564.method_10885((class_2561)Bingo.translatable("bingo.board.copy", new Object[0])).method_27694(s -> s.method_10977(class_124.field_1060).method_10949((class_2568)new class_2568.class_10613((class_2561)Bingo.translatable("chat.copy.click", new Object[0]))).method_10958((class_2558)new class_2558.class_10606(game.getBoard().toString()))), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"difficulties").requires(source -> source.method_9259(2))).executes(ctx -> {
            BingoGame game = ((MinecraftServerExt)((class_2168)ctx.getSource()).method_9211()).bingo$getGame();
            if (game == null) {
                throw NO_GAME_RUNNING.create();
            }
            BingoBoard board = game.getBoard();
            Vec2i visualSize = board.getShape().getVisualSize(board.getSize());
            StringBuilder line = new StringBuilder(visualSize.x());
            for (int y = 0; y < visualSize.y(); ++y) {
                for (int x = 0; x < visualSize.x(); ++x) {
                    int goalIndex = board.getShape().getCellFromCoords(board.getSize(), x, y);
                    if (goalIndex == -1) {
                        line.append(' ');
                        continue;
                    }
                    line.append(((BingoDifficulty)board.getGoals()[goalIndex].difficulty().orElseThrow().comp_349()).number());
                }
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)line.toString()), false);
                line.setLength(0);
            }
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"goals").requires(source -> source.method_9259(2) && ((MinecraftServerExt)source.method_9211()).bingo$getGame() != null)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"award").then(class_2170.method_9244((String)"goal", (ArgumentType)class_2232.method_9441()).suggests(ACTIVE_GOAL_SUGGESTOR).executes(ctx -> BingoCommand.awardOrRevoke((CommandContext<class_2168>)ctx, (TriFunction<BingoGame, class_3222, ActiveGoal, Boolean>)((TriFunction)BingoGame::award), "bingo.award.success"))))).then(class_2170.method_9247((String)"revoke").then(class_2170.method_9244((String)"goal", (ArgumentType)class_2232.method_9441()).suggests(ACTIVE_GOAL_SUGGESTOR).executes(ctx -> BingoCommand.awardOrRevoke((CommandContext<class_2168>)ctx, (TriFunction<BingoGame, class_3222, ActiveGoal, Boolean>)((TriFunction)BingoGame::revoke), "bingo.revoke.success"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"teams").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"color", (ArgumentType)class_2177.method_9276()).suggests((context, builder) -> {
            class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
            return class_2172.method_9264(class_124.method_540((boolean)true, (boolean)false).stream().filter(n -> scoreboard.method_1153(n) == null), (SuggestionsBuilder)builder);
        }).executes(context -> {
            class_124 color = class_2177.method_9277((CommandContext)context, (String)"color");
            String name = color.method_537();
            class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
            class_268 existing = scoreboard.method_1153(name);
            if (existing != null) {
                throw TEAM_ALREADY_EXISTS.create((Object)existing);
            }
            class_268 team = scoreboard.method_1171(name);
            team.method_1141(color);
            team.method_1137((class_2561)Bingo.translatable("bingo.formatting." + name, new Object[0]));
            ((class_2168)context.getSource()).method_9226(() -> Bingo.translatable("bingo.created_team", team.method_1148()), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"randomize").executes(context -> BingoCommand.randomizeTeams((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9211().method_3760().method_14571().stream().filter(p -> !p.method_7325()).toList(), null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> BingoCommand.randomizeTeams((CommandContext<class_2168>)context, class_2186.method_9312((CommandContext)context, (String)"players"), null))).then(class_2170.method_9244((String)"groups", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> BingoCommand.randomizeTeams((CommandContext<class_2168>)context, class_2186.method_9312((CommandContext)context, (String)"players"), IntegerArgumentType.getInteger((CommandContext)context, (String)"groups")))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"nerf").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            if (!Bingo.CONFIG.getNerfedPlayers().add(player.method_5667())) {
                throw ALREADY_NERFED.create();
            }
            Bingo.CONFIG.save();
            ((class_2168)context.getSource()).method_9226(() -> Bingo.translatable("bingo.nerf.added", player.method_5476()), true);
            return 1;
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = class_2186.method_9315((CommandContext)context, (String)"player");
            if (!Bingo.CONFIG.getNerfedPlayers().remove(player.method_5667())) {
                throw NOT_NERFED.create();
            }
            Bingo.CONFIG.save();
            ((class_2168)context.getSource()).method_9226(() -> Bingo.translatable("bingo.nerf.removed", player.method_5476()), true);
            return 1;
        })))));
        CommandNode startCommand = bingoCommand.getChild("start");
        REQUIRE_CLIENT.addTo((CommandNode<class_2168>)startCommand);
        CONTINUE_AFTER_WIN.addTo((CommandNode<class_2168>)startCommand);
        INCLUDE_INACTIVE_TEAMS.addTo((CommandNode<class_2168>)startCommand);
        SHAPE.addTo((CommandNode<class_2168>)startCommand);
        SIZE.addTo((CommandNode<class_2168>)startCommand);
        SEED.addTo((CommandNode<class_2168>)startCommand);
        AUTO_FORFEIT_TIME.addTo((CommandNode<class_2168>)startCommand);
        DIFFICULTY.addTo((CommandNode<class_2168>)startCommand);
        GAMEMODE.addTo((CommandNode<class_2168>)startCommand);
        REQUIRE_GOAL.addTo((CommandNode<class_2168>)startCommand);
        EXCLUDE_TAG.addTo((CommandNode<class_2168>)startCommand);
        CommandNode currentCommand = startCommand;
        for (int i = 1; i <= 32; ++i) {
            int teamCount = i;
            ArgumentCommandNode subCommand = ((RequiredArgumentBuilder)class_2170.method_9244((String)("team" + i), (ArgumentType)class_2243.method_9482()).executes(context -> BingoCommand.startGame((CommandContext<class_2168>)context, teamCount))).build();
            currentCommand.addChild((CommandNode)subCommand);
            currentCommand = subCommand;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int startGame(CommandContext<class_2168> context, int teamCount) throws CommandSyntaxException {
        server = ((class_2168)context.getSource()).method_9211();
        playerList = server.method_3760();
        existingGame = ((MinecraftServerExt)server).bingo$getGame();
        if (existingGame != null) {
            existingGame.endGame(playerList);
        }
        registries = ((class_2168)context.getSource()).method_30497();
        difficulty = BingoCommand.DIFFICULTY.get(context);
        seed = BingoCommand.SEED.get(context);
        requiredGoals = BingoCommand.REQUIRE_GOAL.get(context);
        excludedTags = BingoCommand.EXCLUDE_TAG.get(context);
        shapeString = BingoCommand.SHAPE.get(context);
        shape = (BoardShape)BoardShape.CODEC.parse((DynamicOps)JavaOps.INSTANCE, (Object)shapeString).getOrThrow((Function<String, CommandSyntaxException>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$startGame$50(java.lang.String java.lang.String ), (Ljava/lang/String;)Lcom/mojang/brigadier/exceptions/CommandSyntaxException;)((String)shapeString));
        size = BingoCommand.SIZE.get(context);
        if (size < shape.getMinSize() || size > shape.getMaxSize()) {
            throw BingoCommand.INVALID_SIZE.create((Object)size, (Object)shape.getMinSize(), (Object)shape.getMaxSize());
        }
        gamemode = (BingoGameMode)BingoCommand.GAMEMODE.get(context).comp_349();
        requireClient = BingoCommand.REQUIRE_CLIENT.get(context);
        continueAfterWin = BingoCommand.CONTINUE_AFTER_WIN.get(context);
        includeInactiveTeams = BingoCommand.INCLUDE_INACTIVE_TEAMS.get(context);
        autoForfeitTicks = BingoCommand.AUTO_FORFEIT_TIME.get(context);
        teams = LinkedHashSet.newLinkedHashSet(teamCount);
        for (i = 1; i <= teamCount; ++i) {
            argName = "team" + i;
            team = class_2243.method_9480(context, (String)argName);
            if (includeInactiveTeams) ** GOTO lbl-1000
            if (playerList.method_14571().stream().map((Function<class_3222, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, method_5820(), (Lnet/minecraft/class_3222;)Ljava/lang/String;)()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)((Collection)team.method_1204()))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = teamActive = false;
            }
            if (!teamActive || teams.add(team)) continue;
            throw BingoCommand.DUPLICATE_TEAMS.create((Object)team);
        }
        if (teams.isEmpty()) {
            throw BingoCommand.NO_TEAMS.create();
        }
        configError = gamemode.checkAllowedConfig(new BingoGameMode.GameConfig(gamemode, size, teams));
        if (configError != null) {
            throw configError;
        }
        try {
            board = BingoBoard.generate(shape, size, ((BingoDifficulty)difficulty.comp_349()).number(), teams.size(), class_5819.method_43049((long)seed), (Predicate<GoalHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isGoalAllowed(io.github.gaming32.bingo.data.goal.GoalHolder ), (Lio/github/gaming32/bingo/data/goal/GoalHolder;)Z)((BingoGameMode)gamemode), requiredGoals, excludedTags, requireClient, (class_7225.class_7874)registries);
        }
        catch (InvalidGoalException e) {
            Bingo.LOGGER.error("Invalid goal encountered generating Bingo board", (Throwable)e);
            throw BingoCommand.INVALID_GOAL.create((Object)e);
        }
        catch (Exception e) {
            Bingo.LOGGER.error("Error generating Bingo board", (Throwable)e);
            throw BingoCommand.FAILED_TO_START.create((Object)e);
        }
        Bingo.LOGGER.info("Generated board (seed {}):\n{}", (Object)seed, (Object)board);
        game = new BingoGame(board, gamemode, requireClient, continueAfterWin, autoForfeitTicks, (class_268[])teams.toArray((IntFunction<class_268[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$startGame$51(int ), (I)[Lnet/minecraft/class_268;)()));
        for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
            if (!Bingo.CONFIG.getNerfedPlayers().contains(player.method_5667())) continue;
            game.nerfPlayer(player);
        }
        ((MinecraftServerExt)server).bingo$setGame(game);
        Bingo.updateCommandTree(playerList);
        new ArrayList<class_3222>(playerList.method_14571()).forEach((Consumer<class_3222>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addPlayer(net.minecraft.class_3222 ), (Lnet/minecraft/class_3222;)V)((BingoGame)game));
        playerList.method_43514((class_2561)Bingo.translatable("bingo.started", new Object[]{((BingoDifficulty)difficulty.comp_349()).description()}), false);
        return 1;
    }

    private static int resetGame(CommandContext<class_2168> context) {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        BingoGame game = ((MinecraftServerExt)server).bingo$getGame();
        if (game != null) {
            game.endGame(server.method_3760());
        }
        RemoveBoardPayload.INSTANCE.sendTo(server.method_3760().method_14571());
        ((class_2168)context.getSource()).method_9226(() -> Bingo.translatable("bingo.reset.success", new Object[0]), true);
        return 1;
    }

    private static int forfeit(class_2168 source) throws CommandSyntaxException {
        BingoGame game = ((MinecraftServerExt)source.method_9211()).bingo$getGame();
        if (game == null) {
            throw NO_GAME_RUNNING.create();
        }
        class_3222 player = source.method_9207();
        BingoBoard.Teams team = game.getTeam(player);
        if (!team.any()) {
            throw NOT_IN_TEAM.create();
        }
        if (game.forfeit(source.method_9211().method_3760(), team)) {
            source.method_9226(() -> Bingo.translatable("bingo.forfeit.success", new Object[0]), false);
            return 1;
        }
        throw FORFEIT_ALREADY_FINISHED.create();
    }

    private static int forfeit(class_2168 source, class_268 team) throws CommandSyntaxException {
        BingoGame game = ((MinecraftServerExt)source.method_9211()).bingo$getGame();
        if (game == null) {
            throw NO_GAME_RUNNING.create();
        }
        int teamIndex = ArrayUtils.indexOf((Object[])game.getTeams(), (Object)team);
        if (teamIndex == -1) {
            throw TEAM_NOT_PLAYING.create((Object)team.method_1148());
        }
        if (game.forfeit(source.method_9211().method_3760(), BingoBoard.Teams.fromOne(teamIndex))) {
            source.method_9226(() -> Bingo.translatable("bingo.forfeit.success.team", team.method_1148()), true);
            return 1;
        }
        throw FORFEIT_ALREADY_FINISHED.create();
    }

    private static int awardOrRevoke(CommandContext<class_2168> context, TriFunction<BingoGame, class_3222, ActiveGoal, Boolean> action, @Translatable String resultKey) throws CommandSyntaxException {
        BingoGame game = ((MinecraftServerExt)((class_2168)context.getSource()).method_9211()).bingo$getGame();
        if (game == null) {
            throw NO_GAME_RUNNING.create();
        }
        Collection players = class_2186.method_9312(context, (String)"players");
        class_2960 goalId = class_2232.method_9443(context, (String)"goal");
        int success = 0;
        for (ActiveGoal goal : game.getBoard().getGoals()) {
            if (!goal.id().equals((Object)goalId)) continue;
            for (class_3222 player : players) {
                if (!((Boolean)action.apply((Object)game, (Object)player, (Object)goal)).booleanValue()) continue;
                ++success;
            }
        }
        int fSuccess = success;
        ((class_2168)context.getSource()).method_9226(() -> Bingo.translatable(resultKey, players.size(), fSuccess), true);
        return success;
    }

    private static int randomizeTeams(CommandContext<class_2168> context, Collection<class_3222> players, Integer groupCount) throws CommandSyntaxException {
        class_2995 scoreboard = ((class_2168)context.getSource()).method_9211().method_3845();
        ArrayList teams = new ArrayList(scoreboard.method_1159());
        Collections.shuffle(teams);
        if (groupCount != null && groupCount < teams.size()) {
            teams.subList(groupCount, teams.size()).clear();
        }
        if (teams.isEmpty()) {
            throw NO_TEAMS.create();
        }
        ArrayList<class_3222> playerList = new ArrayList<class_3222>(players);
        Collections.shuffle(playerList);
        for (int i = 0; i < playerList.size(); ++i) {
            scoreboard.method_1172(((class_3222)playerList.get(i)).method_5820(), (class_268)teams.get(i % teams.size()));
        }
        ((class_2168)context.getSource()).method_9226(() -> Bingo.translatable("bingo.added_to_teams", players.size(), Math.min(players.size(), teams.size())), true);
        return players.size();
    }

    private static /* synthetic */ class_268[] lambda$startGame$51(int x$0) {
        return new class_268[x$0];
    }

    private static /* synthetic */ CommandSyntaxException lambda$startGame$50(String shapeString, String err) {
        return INVALID_SHAPE.create((Object)shapeString);
    }
}

