/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client;

import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.client.BingoMousePos;
import io.github.gaming32.bingo.client.BoardScreen;
import io.github.gaming32.bingo.client.ClientGame;
import io.github.gaming32.bingo.client.ClientIconTooltip;
import io.github.gaming32.bingo.client.ClientPayloadHandlerImpl;
import io.github.gaming32.bingo.client.IconTooltip;
import io.github.gaming32.bingo.client.PositionAndScale;
import io.github.gaming32.bingo.client.TooltipBuilder;
import io.github.gaming32.bingo.client.config.BingoClientConfig;
import io.github.gaming32.bingo.client.icons.DefaultIconRenderers;
import io.github.gaming32.bingo.client.icons.IconRenderer;
import io.github.gaming32.bingo.client.icons.IconRenderers;
import io.github.gaming32.bingo.client.icons.pip.BlockPictureInPictureRenderState;
import io.github.gaming32.bingo.client.icons.pip.BlockPictureInPictureRenderer;
import io.github.gaming32.bingo.client.recipeviewer.RecipeViewerPlugin;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.GoalProgress;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import io.github.gaming32.bingo.network.ClientPayloadHandler;
import io.github.gaming32.bingo.network.messages.both.ManualHighlightPayload;
import io.github.gaming32.bingo.platform.BingoPlatform;
import io.github.gaming32.bingo.platform.event.ClientEvents;
import io.github.gaming32.bingo.platform.registrar.KeyMappingBuilder;
import io.github.gaming32.bingo.util.ResourceLocations;
import io.github.gaming32.bingo.util.Vec2i;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_408;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_9848;

public class BingoClient {
    private static final class_2960 BOARD_TEXTURE = ResourceLocations.bingo("board");
    private static final class_2960 BOARD_CELL_TEXTURE = ResourceLocations.bingo("board_cell");
    private static final class_2960 SLOT_HIGHLIGHT_BACK_SPRITE = ResourceLocations.minecraft("container/slot_highlight_back");
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_SPRITE = ResourceLocations.minecraft("container/slot_highlight_front");
    public static final class_2561 BOARD_TITLE = class_2561.method_43471((String)"bingo.board.title");
    public static final class_2561 BOARD_TITLE_SHORT = class_2561.method_43471((String)"bingo.board.title.short");
    public static final int BOARD_OFFSET = 3;
    public static class_304 manualHighlightKeyMapping;
    public static BingoBoard.Teams clientTeam;
    public static BingoBoard.Teams receivedClientTeam;
    public static ClientGame clientGame;
    public static final BingoClientConfig CONFIG;
    private static RecipeViewerPlugin recipeViewerPlugin;

    public static void init() {
        CONFIG.load();
        CONFIG.save();
        BingoClient.registerEventHandlers();
        DefaultIconRenderers.setup();
        BingoPlatform.platform.registerKeyMappings(builder -> {
            class_304.class_11900 category = builder.registerCategory(ResourceLocations.bingo("category"));
            builder.name("bingo.key.board").category(category).keyCode(66).conflictContext(KeyMappingBuilder.ConflictContext.IN_GAME).register(minecraft -> {
                if (clientGame != null) {
                    minecraft.method_1507((class_437)new BoardScreen());
                }
            });
            manualHighlightKeyMapping = builder.name("bingo.key.manual_highlight").category(category).keyType(class_3675.class_307.field_1672).keyCode(0).conflictContext(KeyMappingBuilder.ConflictContext.UNIVERSAL).register(minecraft -> {}).mapping();
        });
        BingoPlatform.platform.registerClientTooltips(registrar -> registrar.register(IconTooltip.class, ClientIconTooltip::new));
        BingoPlatform.platform.registerPictureInPictureRenderers(registrar -> registrar.register(BlockPictureInPictureRenderState.class, BlockPictureInPictureRenderer::new));
        ClientPayloadHandler.init(new ClientPayloadHandlerImpl());
        Bingo.LOGGER.info("Bongo");
    }

    private static void registerEventHandlers() {
        ClientEvents.KEY_RELEASED_PRE.register((screen, event) -> {
            if (clientGame == null || !(screen instanceof class_408)) {
                return false;
            }
            return BingoClient.detectPress(event, BingoClient.getBoardPosition());
        });
        ClientEvents.MOUSE_RELEASED_PRE.register((screen, event) -> {
            if (clientGame == null || !(screen instanceof class_408)) {
                return false;
            }
            return BingoClient.detectClick(event.method_74245(), BingoClient.getBoardPosition());
        });
        ClientEvents.PLAYER_QUIT.register(player -> {
            clientTeam = receivedClientTeam = BingoBoard.Teams.NONE;
            clientGame = null;
        });
        ClientEvents.CLIENT_TICK_END.register(minecraft -> {
            if (minecraft.field_1724 == null || !minecraft.field_1724.method_7325()) {
                clientTeam = receivedClientTeam;
            } else if (minecraft.field_1724.method_7325() && !clientTeam.any()) {
                clientTeam = BingoBoard.Teams.TEAM1;
            }
        });
    }

    public static PositionAndScale getBoardPosition() {
        class_1041 window = class_310.method_1551().method_22683();
        float scale = CONFIG.getBoardScale();
        float x = CONFIG.getBoardCorner().getX(window.method_4486(), scale);
        float y = CONFIG.getBoardCorner().getY(window.method_4502(), scale);
        return new PositionAndScale(x, y, scale);
    }

    public static RecipeViewerPlugin getRecipeViewerPlugin() {
        if (recipeViewerPlugin == null) {
            recipeViewerPlugin = RecipeViewerPlugin.detect();
        }
        return recipeViewerPlugin;
    }

    public static void renderBoardOnHud(class_310 minecraft, class_332 graphics) {
        if (clientGame == null) {
            return;
        }
        if (minecraft.method_53526().method_53536() && !CONFIG.showBoardOnF3Screen()) {
            return;
        }
        if (minecraft.field_1755 instanceof BoardScreen) {
            return;
        }
        PositionAndScale pos = BingoClient.getBoardPosition();
        BingoClient.renderBingo(graphics, minecraft.field_1755 instanceof class_408, pos);
        if (CONFIG.isShowScoreCounter() && clientGame.renderMode() == BingoGameMode.RenderMode.ALL_TEAMS) {
            int scoreY;
            class TeamValue {
                final BingoBoard.Teams team;
                int score;

                TeamValue(BingoBoard.Teams team) {
                    this.team = team;
                }
            }
            TeamValue[] teams = new TeamValue[clientGame.teams().length];
            for (int i = 0; i < teams.length; ++i) {
                teams[i] = new TeamValue(BingoBoard.Teams.fromOne(i));
            }
            int totalScore = 0;
            for (BingoBoard.Teams state : clientGame.states()) {
                if (!state.any()) continue;
                ++totalScore;
                ++teams[state.getFirstIndex()].score;
            }
            Arrays.sort(teams, Comparator.comparing(v -> -v.score));
            class_327 font = minecraft.field_1772;
            int scoreX = (int)(pos.x() * pos.scale() + (float)BingoClient.getBoardWidth() * pos.scale() / 2.0f);
            if (BingoClient.CONFIG.getBoardCorner().isOnBottom) {
                float f = (pos.y() - 3.0f) * pos.scale();
                Objects.requireNonNull(font);
                scoreY = (int)(f - 9.0f);
            } else {
                scoreY = (int)(pos.y() * pos.scale() + (float)(BingoClient.getBoardHeight() + 3) * pos.scale());
            }
            int shift = BingoClient.CONFIG.getBoardCorner().isOnBottom ? -12 : 12;
            for (TeamValue teamValue : teams) {
                if (teamValue.score == 0) break;
                class_268 team = clientGame.teams()[teamValue.team.getFirstIndex()];
                class_5250 leftText = BingoClient.getDisplayName(team).method_27661();
                class_5250 rightText = class_2561.method_43470((String)(" - " + teamValue.score));
                if (team.method_1202() != class_124.field_1070) {
                    leftText.method_27692(team.method_1202());
                    rightText.method_27692(team.method_1202());
                }
                graphics.method_27535(font, (class_2561)leftText, scoreX - font.method_27525((class_5348)leftText), scoreY, -1);
                graphics.method_27535(font, (class_2561)rightText, scoreX, scoreY, -1);
                scoreY += shift;
            }
            class_5250 leftText = class_2561.method_43471((String)"bingo.unclaimed");
            class_5250 rightText = class_2561.method_43470((String)(" - " + (clientGame.states().length - totalScore)));
            graphics.method_27535(font, (class_2561)leftText, scoreX - font.method_27525((class_5348)leftText), scoreY, -1);
            graphics.method_27535(font, (class_2561)rightText, scoreX, scoreY, -1);
        }
    }

    public static int getBoardWidth() {
        return 14 + 18 * clientGame.shape().getVisualSize(clientGame.size()).x();
    }

    public static int getBoardHeight() {
        return 24 + 18 * clientGame.shape().getVisualSize(clientGame.size()).y();
    }

    public static void renderBingo(class_332 graphics, boolean mouseHover, PositionAndScale pos) {
        if (clientGame == null) {
            Bingo.LOGGER.warn("BingoClient.renderBingo() called when Bingo.clientGame == null!");
            return;
        }
        class_310 minecraft = class_310.method_1551();
        graphics.method_51448().pushMatrix();
        graphics.method_51448().scale(pos.scale(), pos.scale());
        graphics.method_51448().translate((float)((int)pos.x()), (float)((int)pos.y()));
        BingoMousePos mousePos = mouseHover ? BingoMousePos.getPos(minecraft, clientGame.shape(), clientGame.size(), pos) : null;
        Vec2i visualSize = clientGame.shape().getVisualSize(clientGame.size());
        int goalCount = clientGame.shape().getGoalCount(clientGame.size());
        graphics.method_52706(class_10799.field_56883, BOARD_TEXTURE, 0, 0, 7 + 18 * visualSize.x() + 7, 17 + 18 * visualSize.y() + 7);
        for (int goalIndex = 0; goalIndex < goalCount; ++goalIndex) {
            Vec2i slotPos = clientGame.shape().getCoords(clientGame.size(), goalIndex);
            int slotX = slotPos.x() * 18 + 7;
            int slotY = slotPos.y() * 18 + 17;
            graphics.method_52706(class_10799.field_56883, BOARD_CELL_TEXTURE, slotX, slotY, 18, 18);
        }
        BingoClient.renderBoardTitle(graphics, minecraft.field_1772);
        if (BingoMousePos.hasSlotPos(mousePos)) {
            graphics.method_51448().pushMatrix();
            Vec2i slotPos = mousePos.getSlotPos(clientGame);
            int slotX = slotPos.x() * 18 + 8;
            int slotY = slotPos.y() * 18 + 18;
            graphics.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_BACK_SPRITE, slotX - 4, slotY - 4, 24, 24);
            graphics.method_51448().popMatrix();
        }
        boolean spectator = minecraft.field_1724 != null && minecraft.field_1724.method_7325();
        for (int goalIndex = 0; goalIndex < goalCount; ++goalIndex) {
            Integer manualHighlight;
            Vec2i slotPos = clientGame.shape().getCoords(clientGame.size(), goalIndex);
            ActiveGoal goal = clientGame.goals()[goalIndex];
            BingoBoard.Teams state = clientGame.states()[goalIndex];
            boolean isGoalCompleted = state.and(clientTeam);
            int slotX = slotPos.x() * 18 + 8;
            int slotY = slotPos.y() * 18 + 18;
            Integer color = switch (clientGame.renderMode()) {
                default -> throw new MatchException(null, null);
                case BingoGameMode.RenderMode.FANCY -> {
                    if (isGoalCompleted) {
                        yield 0x55FF55;
                    }
                    yield goal.specialType().incompleteColor;
                }
                case BingoGameMode.RenderMode.ALL_TEAMS -> {
                    if (!state.any()) {
                        yield null;
                    }
                    BingoBoard.Teams team = isGoalCompleted ? clientTeam : state;
                    Integer maybeColor = clientGame.teams()[team.getFirstIndex()].method_1202().method_532();
                    yield maybeColor != null ? maybeColor : 0x55FF55;
                }
            };
            if (color != null) {
                graphics.method_25294(slotX, slotY, slotX + 16, slotY + 16, 0xA0000000 | color);
            }
            if ((manualHighlight = clientGame.manualHighlights()[goalIndex]) != null) {
                int highlightColor = class_9848.method_61330((int)255, (int)CONFIG.getManualHighlightColor(manualHighlight));
                graphics.method_51738(slotX, slotX + 15, slotY, highlightColor);
                graphics.method_51738(slotX, slotX + 15, slotY + 15, highlightColor);
                graphics.method_51742(slotX, slotY, slotY + 15, highlightColor);
                graphics.method_51742(slotX + 15, slotY, slotY + 15, highlightColor);
            }
            GoalIcon icon = goal.icon();
            IconRenderer<GoalIcon> renderer = IconRenderers.getRenderer(icon);
            renderer.render(icon, graphics, slotX, slotY);
            renderer.renderDecorations(icon, minecraft.field_1772, graphics, slotX, slotY);
            GoalProgress progress = clientGame.progress()[goalIndex];
            if (progress == null || isGoalCompleted || progress.progress() <= 0 || spectator) continue;
            int pWidth = Math.round((float)progress.progress() * 13.0f / (float)progress.maxProgress());
            int pColor = class_3532.method_15369((float)((float)progress.progress() / (float)progress.maxProgress() / 3.0f), (float)1.0f, (float)1.0f);
            int pX = slotX + 2;
            int pY = slotY + 13;
            graphics.method_25294(pX, pY, pX + 13, pY + 2, -16777216);
            graphics.method_25294(pX, pY, pX + pWidth, pY + 1, pColor | 0xFF000000);
        }
        if (BingoMousePos.hasSlotPos(mousePos)) {
            Vec2i slotPos = mousePos.getSlotPos(clientGame);
            int slotX = slotPos.x() * 18 + 8;
            int slotY = slotPos.y() * 18 + 18;
            graphics.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_FRONT_SPRITE, slotX - 4, slotY - 4, 24, 24);
        }
        if (!clientGame.nerfedTeams().and(clientTeam)) {
            for (int goalIndex = 0; goalIndex < goalCount; ++goalIndex) {
                if (!clientGame.shape().isNerfCell(clientGame.size(), goalIndex)) continue;
                Vec2i slotPos = clientGame.shape().getCoords(clientGame.size(), goalIndex);
                int slotX = slotPos.x() * 18 + 8;
                int slotY = slotPos.y() * 18 + 18;
                graphics.method_25294(slotX, slotY, slotX + 16, slotY + 16, Integer.MIN_VALUE);
            }
        }
        graphics.method_51448().popMatrix();
        if (BingoMousePos.hasSlotPos(mousePos)) {
            ActiveGoal goal = clientGame.goals()[mousePos.goalIndex()];
            GoalProgress progress = clientGame.progress()[mousePos.goalIndex()];
            TooltipBuilder tooltip = new TooltipBuilder();
            tooltip.add(goal.name());
            if (progress != null && (progress.maxProgress() > 1 || minecraft.field_1690.field_1827)) {
                tooltip.add((class_2561)class_2561.method_43469((String)"bingo.progress", (Object[])new Object[]{progress.progress(), progress.maxProgress()}));
            }
            if (minecraft.field_1690.field_1827) {
                tooltip.add((class_2561)class_2561.method_43470((String)goal.id().toString()).method_27692(class_124.field_1063));
            }
            goal.tooltip().ifPresent(component -> {
                int width = Math.max(300, minecraft.field_1772.method_27525((class_5348)goal.name()));
                tooltip.add(class_5481.field_26385);
                minecraft.field_1772.method_1728((class_5348)component, width).forEach(tooltip::add);
            });
            goal.tooltipIcon().map(IconTooltip::new).ifPresent(tooltip::add);
            tooltip.draw(minecraft.field_1772, graphics, (int)mousePos.mouseX(), (int)mousePos.mouseY());
        }
    }

    private static void renderBoardTitle(class_332 graphics, class_327 font) {
        int maxWidth = BingoClient.getBoardWidth() - 16;
        class_5481 title = font.method_27525((class_5348)BOARD_TITLE) > maxWidth ? BingoClient.getVisualOrderWithEllipses(BOARD_TITLE_SHORT, font, maxWidth) : BOARD_TITLE.method_30937();
        graphics.method_51430(font, title, 8, 6, -12566464, false);
    }

    public static class_5481 getVisualOrderWithEllipses(class_2561 text, class_327 font, int maxWidth) {
        int textWidth = font.method_27525((class_5348)text);
        if (textWidth <= maxWidth) {
            return text.method_30937();
        }
        class_5348 shortText = font.method_1714((class_5348)text, maxWidth - font.method_27525((class_5348)class_5244.field_39678));
        class_5348 combinedText = class_5348.method_29433((class_5348[])new class_5348[]{shortText, class_5244.field_39678});
        return class_2477.method_10517().method_30934(combinedText);
    }

    public static boolean detectClick(int button, PositionAndScale boardPos) {
        return BingoClient.detectClickOrPress(class_3675.class_307.field_1672.method_1447(button), boardPos);
    }

    public static boolean detectPress(class_11908 event, PositionAndScale boardPos) {
        return BingoClient.detectClickOrPress(class_3675.method_15985((class_11908)event), boardPos);
    }

    public static boolean detectClickOrPress(class_3675.class_306 key, PositionAndScale boardPos) {
        if (clientGame == null) {
            return false;
        }
        BingoMousePos mousePos = BingoMousePos.getPos(class_310.method_1551(), clientGame.shape(), clientGame.size(), boardPos);
        if (!mousePos.hasSlotPos()) {
            return false;
        }
        if (key.equals((Object)BingoClient.manualHighlightKeyMapping.field_1655)) {
            Integer nextHighlight;
            Integer manualHighlight;
            Integer n = manualHighlight = clientGame.manualHighlights()[mousePos.goalIndex()];
            int n2 = 0;
            BingoClient.clientGame.manualHighlights()[mousePos.goalIndex()] = nextHighlight = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{2}, (Object)n, n2)) {
                case -1 -> 0;
                case 0 -> null;
                default -> manualHighlight + 1;
            });
            new ManualHighlightPayload(mousePos.goalIndex(), nextHighlight == null ? 0 : nextHighlight + 1, clientGame.manualHighlightModCount().getValue()).sendToServer();
            clientGame.manualHighlightModCount().increment();
            class_4264.method_62888((class_1144)class_310.method_1551().method_1483());
        }
        ActiveGoal goal = clientGame.goals()[mousePos.goalIndex()];
        RecipeViewerPlugin plugin = BingoClient.getRecipeViewerPlugin();
        if (plugin.isViewRecipe(key)) {
            plugin.showRecipe(IconRenderers.getRenderer(goal.icon()).getIconItem(goal.icon()));
            return true;
        }
        if (plugin.isViewUsages(key)) {
            plugin.showUsages(IconRenderers.getRenderer(goal.icon()).getIconItem(goal.icon()));
            return true;
        }
        return false;
    }

    public static class_2561 getDisplayName(class_268 team) {
        class_634 connection = class_310.method_1551().method_1562();
        if (connection != null) {
            Iterator players = team.method_1204().stream().map(arg_0 -> ((class_634)connection).method_2874(arg_0)).filter(Objects::nonNull).iterator();
            if (players.hasNext()) {
                class_640 playerInfo = (class_640)players.next();
                if (!players.hasNext()) {
                    class_1657 player;
                    class_638 level = class_310.method_1551().field_1687;
                    if (level != null && (player = level.method_18470(playerInfo.method_2966().id())) != null) {
                        return player.method_5477();
                    }
                    return class_2561.method_43470((String)playerInfo.method_2966().name());
                }
            }
        }
        return team.method_1140();
    }

    static {
        clientTeam = BingoBoard.Teams.NONE;
        receivedClientTeam = BingoBoard.Teams.NONE;
        CONFIG = new BingoClientConfig(BingoPlatform.platform.getConfigDir().resolve("bingo-client.toml"));
    }
}

