/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client;

import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.client.BingoClient;
import io.github.gaming32.bingo.client.ClientGame;
import io.github.gaming32.bingo.game.BoardShape;
import io.github.gaming32.bingo.game.GoalProgress;
import io.github.gaming32.bingo.network.ClientPayloadHandler;
import io.github.gaming32.bingo.network.messages.both.ManualHighlightPayload;
import io.github.gaming32.bingo.network.messages.s2c.InitBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.ResyncStatesPayload;
import io.github.gaming32.bingo.network.messages.s2c.SyncTeamPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateProgressPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateStatePayload;
import java.util.Arrays;
import net.minecraft.class_1937;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_8710;
import org.apache.commons.lang3.mutable.MutableInt;

public class ClientPayloadHandlerImpl
implements ClientPayloadHandler {
    @Override
    public void handleInitBoard(InitBoardPayload payload, class_1937 level) {
        BoardShape shape = payload.shape();
        int size = payload.size();
        int goalCount = shape.getGoalCount(size);
        String[] teams = payload.teams();
        class_269 scoreboard = level.method_8428();
        class_268[] playerTeams = new class_268[teams.length];
        for (int i2 = 0; i2 < teams.length; ++i2) {
            class_268 team = scoreboard.method_1153(teams[i2]);
            if (team == null) {
                Bingo.LOGGER.error("Unknown team {}", (Object)teams[i2]);
                return;
            }
            playerTeams[i2] = team;
        }
        BingoClient.clientGame = new ClientGame(shape, size, payload.states(), payload.goals(), playerTeams, payload.nerfedTeams(), payload.renderMode(), new GoalProgress[goalCount], (Integer[])Arrays.stream(payload.manualHighlights()).mapToObj(i -> i == 0 ? null : Integer.valueOf(i - 1)).toArray(Integer[]::new), new MutableInt(payload.manualHighlightModCount()));
    }

    @Override
    public void handleRemoveBoard() {
        BingoClient.clientGame = null;
    }

    @Override
    public void handleResyncStates(ResyncStatesPayload payload) {
        if (!ClientPayloadHandlerImpl.checkGamePresent(payload)) {
            return;
        }
        System.arraycopy(payload.states(), 0, BingoClient.clientGame.states(), 0, BingoClient.clientGame.shape().getGoalCount(BingoClient.clientGame.size()));
    }

    @Override
    public void handleSyncTeam(SyncTeamPayload payload) {
        BingoClient.clientTeam = BingoClient.receivedClientTeam = payload.team();
    }

    @Override
    public void handleUpdateProgress(UpdateProgressPayload payload) {
        if (!ClientPayloadHandlerImpl.checkGamePresent(payload)) {
            return;
        }
        BingoClient.clientGame.progress()[payload.index()] = new GoalProgress(payload.progress(), payload.maxProgress());
    }

    @Override
    public void handleUpdateState(UpdateStatePayload payload) {
        if (!ClientPayloadHandlerImpl.checkGamePresent(payload)) {
            return;
        }
        int index = payload.index();
        if (index < 0 || index >= BingoClient.clientGame.shape().getGoalCount(BingoClient.clientGame.size())) {
            Bingo.LOGGER.warn("Invalid {} payload: invalid board index {}", UpdateStatePayload.TYPE, (Object)index);
            return;
        }
        BingoClient.clientGame.states()[index] = payload.newState();
    }

    @Override
    public void handleManualHighlight(ManualHighlightPayload payload) {
        if (!ClientPayloadHandlerImpl.checkGamePresent(payload)) {
            return;
        }
        if (payload.slot() < 0 || payload.slot() >= BingoClient.clientGame.shape().getGoalCount(BingoClient.clientGame.size())) {
            return;
        }
        if (payload.value() < 0 || payload.value() > 3) {
            return;
        }
        BingoClient.clientGame.manualHighlights()[payload.slot()] = payload.value() == 0 ? null : Integer.valueOf(payload.value() - 1);
        BingoClient.clientGame.manualHighlightModCount().setValue(payload.modCount());
    }

    private static boolean checkGamePresent(class_8710 payload) {
        if (BingoClient.clientGame == null) {
            Bingo.LOGGER.warn("BingoClient.clientGame == null while handling {}!", (Object)payload.method_56479());
            return false;
        }
        return true;
    }
}

