/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import io.github.gaming32.bingo.client.config.BoardCorner;
import java.nio.file.Path;
import java.util.Arrays;

public class BingoClientConfig {
    private static final int[] DEFAULT_MANUAL_HIGHLIGHT_COLORS = new int[]{0xFF5050, 44800, 0x5050FF};
    private final FileConfig config;
    private BoardCorner boardCorner = BoardCorner.UPPER_RIGHT;
    private boolean showBoardOnF3Screen = false;
    private float boardScale = 1.0f;
    private boolean showScoreCounter = true;
    private final int[] manualHighlightColors = new int[3];

    public BingoClientConfig(Path configPath) {
        this.config = FileConfig.of((Path)configPath).checked();
        Arrays.setAll(this.manualHighlightColors, i -> DEFAULT_MANUAL_HIGHLIGHT_COLORS[i]);
    }

    public void load() {
        this.config.load();
        this.boardCorner = (BoardCorner)this.config.getEnumOrElse("board.corner", (Enum)BoardCorner.UPPER_RIGHT);
        this.showBoardOnF3Screen = Boolean.parseBoolean(String.valueOf(this.config.get("board.showOnF3Screen")));
        this.boardScale = ((Double)this.config.getOrElse("board.scale", (Object)1.0)).floatValue();
        this.showScoreCounter = (Boolean)this.config.getOrElse("board.showScoreCounter", (Object)true);
        for (int value = 0; value < 3; ++value) {
            this.manualHighlightColors[value] = this.config.getIntOrElse("board.manualHighlightColor" + value, DEFAULT_MANUAL_HIGHLIGHT_COLORS[value]);
        }
    }

    public void save() {
        this.config.clear();
        this.config.set("board.corner", (Object)this.boardCorner.name());
        this.config.set("board.showOnF3Screen", (Object)this.showBoardOnF3Screen);
        this.config.set("board.scale", (Object)Float.valueOf(this.boardScale));
        this.config.set("board.showScoreCounter", (Object)this.showScoreCounter);
        for (int value = 0; value < 3; ++value) {
            this.config.set("board.manualHighlightColor" + value, (Object)this.manualHighlightColors[value]);
        }
        this.config.save();
    }

    public void reset() {
        this.boardCorner = BoardCorner.UPPER_RIGHT;
        this.showBoardOnF3Screen = false;
        this.boardScale = 1.0f;
        this.showScoreCounter = true;
        Arrays.setAll(this.manualHighlightColors, i -> DEFAULT_MANUAL_HIGHLIGHT_COLORS[i]);
    }

    public BoardCorner getBoardCorner() {
        return this.boardCorner;
    }

    public void setBoardCorner(BoardCorner boardCorner) {
        this.boardCorner = boardCorner;
    }

    public boolean showBoardOnF3Screen() {
        return this.showBoardOnF3Screen;
    }

    public void setShowBoardOnF3Screen(boolean showBoardOnF3Screen) {
        this.showBoardOnF3Screen = showBoardOnF3Screen;
    }

    public float getBoardScale() {
        return this.boardScale;
    }

    public void setBoardScale(float boardScale) {
        this.boardScale = boardScale;
    }

    public boolean isShowScoreCounter() {
        return this.showScoreCounter;
    }

    public void setShowScoreCounter(boolean showScoreCounter) {
        this.showScoreCounter = showScoreCounter;
    }

    public int getManualHighlightColor(int value) {
        return this.manualHighlightColors[value];
    }

    public void setManualHighlightColor(int value, int color) {
        this.manualHighlightColors[value] = color;
    }
}

