/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.recipeviewer.jei;

import io.github.gaming32.bingo.client.recipeviewer.RecipeViewerPlugin;
import io.github.gaming32.bingo.client.recipeviewer.jei.BingoJeiPlugin;
import java.util.List;
import java.util.function.Function;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusFactory;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IJeiKeyMapping;
import mezz.jei.api.runtime.IJeiKeyMappings;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.class_1799;
import net.minecraft.class_3675;

public class JEIPlugin
extends RecipeViewerPlugin {
    @Override
    public boolean isViewRecipe(class_3675.class_306 key) {
        return this.matchesKey(key, IJeiKeyMappings::getShowRecipe);
    }

    @Override
    public boolean isViewUsages(class_3675.class_306 key) {
        return this.matchesKey(key, IJeiKeyMappings::getShowUses);
    }

    private boolean matchesKey(class_3675.class_306 key, Function<IJeiKeyMappings, IJeiKeyMapping> getter) {
        IJeiRuntime runtime = BingoJeiPlugin.getInstance().runtime;
        if (runtime == null) {
            return false;
        }
        return getter.apply(runtime.getKeyMappings()).isActiveAndMatches(key);
    }

    @Override
    public void showRecipe(class_1799 stack) {
        this.show(stack, List.of(RecipeIngredientRole.OUTPUT));
    }

    @Override
    public void showUsages(class_1799 stack) {
        this.show(stack, List.of(RecipeIngredientRole.INPUT, RecipeIngredientRole.CRAFTING_STATION));
    }

    private void show(class_1799 stack, List<RecipeIngredientRole> roles) {
        IJeiRuntime runtime = BingoJeiPlugin.getInstance().runtime;
        if (runtime == null) {
            return;
        }
        IFocusFactory focusFactory = runtime.getJeiHelpers().getFocusFactory();
        runtime.getRecipesGui().show(roles.stream().map(role -> focusFactory.createFocus(role, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack)).toList());
    }
}

