/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoConditions;
import io.github.gaming32.bingo.ext.LivingEntityExt;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_169;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8129;
import org.jetbrains.annotations.NotNull;

public record HasOnlyBeenDamagedByCondition(Optional<class_1299<?>> entityType, Optional<class_8129<class_1299<?>>> entityTypeTag, Optional<class_1299<?>> directEntityType, Optional<class_8129<class_1299<?>>> directEntityTypeTag, Optional<class_5321<class_8110>> damageType, Optional<class_8129<class_8110>> damageTypeTag) implements class_5341
{
    public static final MapCodec<HasOnlyBeenDamagedByCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41177.method_39673().optionalFieldOf("entity_type").forGetter(HasOnlyBeenDamagedByCondition::entityType), (App)class_8129.method_53245((class_5321)class_7924.field_41266).optionalFieldOf("entity_type_tag").forGetter(HasOnlyBeenDamagedByCondition::entityTypeTag), (App)class_7923.field_41177.method_39673().optionalFieldOf("direct_entity_type").forGetter(HasOnlyBeenDamagedByCondition::directEntityType), (App)class_8129.method_53245((class_5321)class_7924.field_41266).optionalFieldOf("direct_entity_type_tag").forGetter(HasOnlyBeenDamagedByCondition::directEntityTypeTag), (App)class_5321.method_39154((class_5321)class_7924.field_42534).optionalFieldOf("damage_type").forGetter(HasOnlyBeenDamagedByCondition::damageType), (App)class_8129.method_53245((class_5321)class_7924.field_42534).optionalFieldOf("damage_type_tag").forGetter(HasOnlyBeenDamagedByCondition::damageTypeTag)).apply((Applicative)instance, HasOnlyBeenDamagedByCondition::new));

    @NotNull
    public class_5342 method_29325() {
        return BingoConditions.HAS_ONLY_BEEN_DAMAGED_BY.get();
    }

    public boolean test(class_47 lootContext) {
        LivingEntityExt living;
        class_1297 entity = (class_1297)lootContext.method_35508(class_181.field_1226);
        return entity instanceof LivingEntityExt && (living = (LivingEntityExt)entity).bingo$hasOnlyBeenDamagedBy(damageEntry -> {
            if (this.entityType.isPresent() && !damageEntry.entityType().equals(this.entityType)) {
                return false;
            }
            if (this.entityTypeTag.isPresent() && (damageEntry.entityType().isEmpty() || !this.entityTypeTag.get().method_48967(class_7923.field_41177.method_47983(damageEntry.entityType().get())))) {
                return false;
            }
            if (this.directEntityType.isPresent() && !damageEntry.directEntityType().equals(this.directEntityType)) {
                return false;
            }
            if (this.directEntityTypeTag.isPresent() && (damageEntry.directEntityType().isEmpty() || !this.directEntityTypeTag.get().method_48967(class_7923.field_41177.method_47983(damageEntry.directEntityType().get())))) {
                return false;
            }
            if (this.damageType.isPresent() && !damageEntry.damageType().method_40225(this.damageType.get())) {
                return false;
            }
            return !this.damageTypeTag.isPresent() || this.damageTypeTag.get().method_48967(damageEntry.damageType());
        });
    }

    @NotNull
    public Set<class_169<?>> method_293() {
        return Set.of(class_181.field_1226);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements class_5341.class_210 {
        private Optional<class_1299<?>> entityType = Optional.empty();
        private Optional<class_8129<class_1299<?>>> entityTypeTag = Optional.empty();
        private Optional<class_1299<?>> directEntityType = Optional.empty();
        private Optional<class_8129<class_1299<?>>> directEntityTypeTag = Optional.empty();
        private Optional<class_5321<class_8110>> damageType = Optional.empty();
        private Optional<class_8129<class_8110>> damageTypeTag = Optional.empty();

        private Builder() {
        }

        public Builder entityType(class_1299<?> entityType) {
            this.entityType = Optional.of(entityType);
            return this;
        }

        public Builder entityTypeTag(class_6862<class_1299<?>> entityTypeTag) {
            return this.entityTypeTag(class_8129.method_48965(entityTypeTag));
        }

        public Builder entityTypeTag(class_8129<class_1299<?>> entityTypeTag) {
            this.entityTypeTag = Optional.of(entityTypeTag);
            return this;
        }

        public Builder directEntityType(class_1299<?> directEntityType) {
            this.directEntityType = Optional.of(directEntityType);
            return this;
        }

        public Builder directEntityTypeTag(class_6862<class_1299<?>> directEntityTypeTag) {
            return this.directEntityTypeTag(class_8129.method_48965(directEntityTypeTag));
        }

        public Builder directEntityTypeTag(class_8129<class_1299<?>> directEntityTypeTag) {
            this.directEntityTypeTag = Optional.of(directEntityTypeTag);
            return this;
        }

        public Builder damageType(class_5321<class_8110> damageType) {
            this.damageType = Optional.of(damageType);
            return this;
        }

        public Builder damageTypeTag(class_6862<class_8110> damageTypeTag) {
            return this.damageTypeTag((class_8129<class_8110>)class_8129.method_48965(damageTypeTag));
        }

        public Builder damageTypeTag(class_8129<class_8110> damageTypeTag) {
            this.damageTypeTag = Optional.of(damageTypeTag);
            return this;
        }

        @NotNull
        public HasOnlyBeenDamagedByCondition build() {
            return new HasOnlyBeenDamagedByCondition(this.entityType, this.entityTypeTag, this.directEntityType, this.directEntityTypeTag, this.damageType, this.damageTypeTag);
        }
    }
}

