/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.SubBingoSub;
import io.github.gaming32.bingo.util.BingoUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_3518;

public record JsonSubber(JsonElement json) {
    public JsonSubber sub(String path, String key) {
        return this.sub(path, new SubBingoSub(key));
    }

    public JsonSubber sub(String path, BingoSub sub) {
        return this.sub(path, BingoUtil.toJsonElement(BingoSub.INNER_CODEC, sub));
    }

    public JsonSubber sub(String path, JsonElement newValue) {
        ArrayList<SubbingElement> current = new ArrayList<SubbingElement>(List.of(new SubbingElement(List.of(), this.json)));
        ArrayList<SubbingElement> next = new ArrayList<SubbingElement>();
        String[] parts = path.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            for (SubbingElement element : current) {
                element.resolveAll(part, next);
            }
            current.clear();
            current.addAll(next);
            next.clear();
        }
        String last = parts[parts.length - 1];
        for (SubbingElement element : current) {
            element.modifyAll(last, newValue);
        }
        return this;
    }

    private record SubbingElement(List<String> path, JsonElement value) {
        SubbingElement resolve(String offset) {
            JsonElement next;
            if (this.value.isJsonObject()) {
                next = this.value.getAsJsonObject().get(offset);
                if (next == null) {
                    throw new IllegalArgumentException("Could not find " + this.pathToString(offset) + " in " + String.valueOf(this.value));
                }
            } else if (this.value.isJsonArray()) {
                int index;
                try {
                    index = Integer.parseInt(offset);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid index \"" + offset + "\" into array at " + this.pathToString(null));
                }
                JsonArray array = this.value.getAsJsonArray();
                if (index < 0 || index >= array.size()) {
                    throw new IllegalArgumentException("Index " + index + " is out of bounds for array with length " + array.size() + " at " + this.pathToString(null));
                }
                next = array.get(index);
            } else {
                throw this.notAnArrayOrObject();
            }
            return new SubbingElement(class_156.method_57108(this.path, (Object)offset), next);
        }

        void resolveAll(String offset, List<SubbingElement> output) {
            if (!offset.equals("*")) {
                output.add(this.resolve(offset));
                return;
            }
            if (this.value.isJsonObject()) {
                for (Map.Entry entry : this.value.getAsJsonObject().entrySet()) {
                    output.add(new SubbingElement(class_156.method_57108(this.path, (Object)((String)entry.getKey())), (JsonElement)entry.getValue()));
                }
            } else if (this.value.isJsonArray()) {
                JsonArray array = this.value.getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    output.add(new SubbingElement(class_156.method_57108(this.path, (Object)Integer.toString(i)), array.get(i)));
                }
            } else {
                throw this.notAnArrayOrObject();
            }
        }

        void modify(String offset, JsonElement newValue) {
            boolean modify;
            boolean add = offset.startsWith("+");
            boolean optional = offset.startsWith("?");
            boolean bl = modify = !add && !optional;
            if (!modify) {
                offset = offset.substring(1);
            }
            if (this.value.isJsonObject()) {
                JsonObject obj = this.value.getAsJsonObject();
                if (obj.has(offset)) {
                    if (add) {
                        throw new IllegalArgumentException("Expected key \"" + offset + "\" to not exist in " + this.pathToString(null) + ", but was present");
                    }
                } else if (modify) {
                    throw new IllegalArgumentException("Could not find \"" + offset + "\" in " + this.pathToString(null));
                }
                obj.add(offset, newValue);
            } else if (this.value.isJsonArray()) {
                int index;
                JsonArray array = this.value.getAsJsonArray();
                if (add && offset.isEmpty()) {
                    array.add(newValue);
                    return;
                }
                try {
                    index = Integer.parseInt(offset);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid index \"" + offset + "\" into array at " + this.pathToString(null));
                }
                if (index < 0 || index >= array.size() || add && index == array.size()) {
                    throw new IllegalArgumentException("Index " + index + " is out of bounds for array with length " + array.size() + " at " + this.pathToString(null));
                }
                if (add) {
                    array.asList().add(index, newValue);
                } else {
                    array.set(index, newValue);
                }
            } else {
                throw this.notAnArrayOrObject();
            }
        }

        void modifyAll(String offset, JsonElement newValue) {
            if (!offset.equals("*")) {
                this.modify(offset, newValue.deepCopy());
                return;
            }
            if (this.value.isJsonObject()) {
                for (Map.Entry entry : this.value.getAsJsonObject().entrySet()) {
                    entry.setValue(newValue.deepCopy());
                }
            } else if (this.value.isJsonArray()) {
                JsonArray array = this.value.getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    array.set(i, newValue.deepCopy());
                }
            } else {
                throw this.notAnArrayOrObject();
            }
        }

        private IllegalArgumentException notAnArrayOrObject() {
            return new IllegalArgumentException("Element at " + this.pathToString(null) + " not an array or an object, but " + class_3518.method_15266((JsonElement)this.value));
        }

        String pathToString(String extra) {
            StringBuilder result = new StringBuilder();
            for (String part : this.path) {
                if (!result.isEmpty()) {
                    result.append('.');
                }
                result.append(part);
            }
            if (extra != null) {
                if (!result.isEmpty()) {
                    result.append('.');
                }
                result.append(extra);
            }
            return result.toString();
        }
    }
}

