/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.fabric.datagen.goal;

import io.github.gaming32.bingo.data.BingoDifficulties;
import io.github.gaming32.bingo.data.BingoTags;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.icons.CycleIcon;
import io.github.gaming32.bingo.data.icons.ItemIcon;
import io.github.gaming32.bingo.data.icons.ItemTagCycleIcon;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.tags.bingo.BingoItemTags;
import io.github.gaming32.bingo.fabric.datagen.goal.DifficultyGoalProvider;
import io.github.gaming32.bingo.subpredicates.ItemEntityPredicate;
import io.github.gaming32.bingo.triggers.AdjacentPaintingTrigger;
import io.github.gaming32.bingo.triggers.BounceOnBlockTrigger;
import io.github.gaming32.bingo.triggers.ItemPickedUpTrigger;
import io.github.gaming32.bingo.triggers.TotalCountInventoryChangeTrigger;
import io.github.gaming32.bingo.triggers.TryUseItemTrigger;
import io.github.gaming32.bingo.util.BingoUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1935;
import net.minecraft.class_196;
import net.minecraft.class_2048;
import net.minecraft.class_2069;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_212;
import net.minecraft.class_2135;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3962;
import net.minecraft.class_4550;
import net.minecraft.class_4559;
import net.minecraft.class_4711;
import net.minecraft.class_5258;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7376;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class VeryEasyGoalProvider
extends DifficultyGoalProvider {
    public VeryEasyGoalProvider(BiConsumer<class_2960, BingoGoal> goalAdder, class_7225.class_7874 registries) {
        super(BingoDifficulties.VERY_EASY, goalAdder, registries);
    }

    @Override
    public void addGoals() {
        class_7225.class_7226 items = this.registries.method_46762(class_7924.field_41197);
        class_7225.class_7226 blocks = this.registries.method_46762(class_7924.field_41254);
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("cobblestone"), (class_7225<class_1792>)items, (class_1935)class_1802.field_20412, 32, 64).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("dirt"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8831, 32, 64).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("redstone"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8725).tags(BingoTags.OVERWORLD).infrequency(2));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("lava_bucket"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8187).reactant("use_buckets").infrequency(4));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("milk_bucket"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8103).reactant("use_buckets").tags(BingoTags.OVERWORLD).infrequency(4));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("water_bucket"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8705).reactant("use_buckets").tags(BingoTags.OVERWORLD).infrequency(4));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("fish_bucket"), (class_7225<class_1792>)items, new ItemTagCycleIcon(BingoItemTags.FISH_BUCKETS), class_2073.class_2074.method_8973().method_8975((class_7871)items, BingoItemTags.FISH_BUCKETS)).name("fish_bucket").tooltip((class_2561)class_2561.method_43469((String)"bingo.goal.fish_bucket.tooltip", (Object[])new Object[]{class_2561.method_43471((String)"advancements.husbandry.tactical_fishing.title")})).antisynergy("fish_bucket").reactant("use_buckets").tags(BingoTags.OCEAN, BingoTags.OVERWORLD).infrequency(4));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("andesite"), (class_7225<class_1792>)items, (class_1935)class_1802.field_20407, 16, 32).infrequency(3).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("granite"), (class_7225<class_1792>)items, (class_1935)class_1802.field_20394, 16, 32).infrequency(3).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("diorite"), (class_7225<class_1792>)items, (class_1935)class_1802.field_20401, 16, 32).infrequency(3).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("iron_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8773).infrequency(2));
        this.addGoal(BingoGoal.builder(this.id("poppies_dandelions")).sub("poppies_count", BingoSub.random(5, 25)).sub("dandelions_count", BingoSub.random(5, 25)).criterion("flowers", TotalCountInventoryChangeTrigger.builder().items(class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8880}).method_35233(class_2096.class_2100.method_9053((int)0)).method_8976(), class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8491}).method_35233(class_2096.class_2100.method_9053((int)0)).method_8976()).build(), subber -> subber.sub("conditions.items.0.count.min", "poppies_count").sub("conditions.items.1.count.min", "dandelions_count")).progress("flowers").tags(BingoTags.ITEM, BingoTags.OVERWORLD).name((class_2561)class_2561.method_43469((String)"bingo.and", (Object[])new Object[]{class_2561.method_43469((String)"bingo.count", (Object[])new Object[]{0, class_1802.field_8880.method_63680()}), class_2561.method_43469((String)"bingo.count", (Object[])new Object[]{0, class_1802.field_8491.method_63680()})}), subber -> subber.sub("with.0.with.0", "poppies_count").sub("with.1.with.0", "dandelions_count")).icon(new CycleIcon(ItemIcon.ofItem((class_1935)class_1802.field_8880), ItemIcon.ofItem((class_1935)class_1802.field_8491)), subber -> subber.sub("icons.0.item.count", "poppies_count").sub("icons.1.item.count", "dandelions_count")));
        this.addGoal(VeryEasyGoalProvider.obtainLevelsGoal(this.id("levels"), 5, 7));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("note_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8643, 5, 7).infrequency(2).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("leaves"), (class_1935)class_1802.field_17503, class_2073.class_2074.method_8973().method_8975((class_7871)items, class_3489.field_15558), 32, 64).tags(BingoTags.OVERWORLD).name((class_2561)class_2561.method_43469((String)"bingo.goal.leaves", (Object[])new Object[]{0}), subber -> subber.sub("with.0", "count")).icon(new ItemTagCycleIcon((class_6862<class_1792>)class_3489.field_15558), subber -> subber.sub("+count", "count")));
        this.addGoal(this.blockCubeGoal(this.id("leaf_cube"), VeryEasyGoalProvider.makeItemWithGlint((class_1935)class_2246.field_10503), (class_6862<class_2248>)class_3481.field_15503, (class_2561)class_2561.method_43471((String)"bingo.goal.cube.leaf")));
        this.addGoal(VeryEasyGoalProvider.obtainSomeItemsFromTag(this.id("wool_colors"), (class_6862<class_1792>)class_3489.field_15544, "bingo.goal.wool_colors", 2, 4).antisynergy("wool_color").infrequency(4).tags(BingoTags.COLOR, BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("snowball"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8543, 8, 16).tags(BingoTags.RARE_BIOME, BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainSomeItemsFromTag(this.id("different_slabs"), (class_6862<class_1792>)class_3489.field_15535, "bingo.goal.different_slabs", 2, 4).antisynergy("slabs").infrequency(2));
        this.addGoal(VeryEasyGoalProvider.obtainSomeItemsFromTag(this.id("different_stairs"), (class_6862<class_1792>)class_3489.field_15526, "bingo.goal.different_stairs", 2, 4).antisynergy("stairs").infrequency(2));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("diamond"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8477));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("rotten_flesh"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8511, 5, 15).infrequency(2));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("stone"), (class_7225<class_1792>)items, (class_1935)class_1802.field_20391, 10, 32).tooltip("stone").infrequency(2).reactant("use_furnace").tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("bread"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8229, 2, 5).infrequency(2).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("hay_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_17528).infrequency(2).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("flower_pot"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8074).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("feather"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8153, 2, 10).infrequency(2));
        this.addGoal(BingoGoal.builder(this.id("sleep_in_bed")).criterion("sleep", class_2135.class_2137.method_43138()).tags(BingoTags.ACTION, BingoTags.OVERWORLD).name("sleep_in_bed").icon(class_1802.field_8789).reactant("sleep"));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("charcoal"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8665).reactant("use_furnace").tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("coal"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8713));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("fishing_rod"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8378));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("apple"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8279).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("stick"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8600, 32, 64).infrequency(2));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("kelp"), (class_7225<class_1792>)items, (class_1935)class_1802.field_17532, 32, 64).tags(BingoTags.OCEAN, BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("cod"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8429, 2, 5).infrequency(2).tags(BingoTags.OCEAN, BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("salmon"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8209, 2, 5).infrequency(2).tags(BingoTags.OCEAN, BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainSomeEdibleItems(this.id("edible_items"), 2, 3));
        this.addGoal(BingoGoal.builder(this.id("breed_mob_pair")).criterion("breed", class_196.class_198.method_860()).name("breed_mob_pair").tooltip("breed_mobs").antisynergy("breed_animals").infrequency(2).tags(BingoTags.ACTION, BingoTags.STAT).icon(class_1802.field_8317));
        this.addGoal(VeryEasyGoalProvider.crouchDistanceGoal(this.id("crouch_distance"), 50, 100));
        List<class_2487> slots = IntStream.range(0, 4).mapToObj(slot -> BingoUtil.compound(Map.of("Slot", class_2481.method_23233((byte)((byte)slot))))).toList();
        this.addGoal(BingoGoal.builder(this.id("fill_all_campfire_slots")).criterion("place", class_4711.class_4712.method_27981((class_2090.class_2091)class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_27962((class_7871)blocks, new class_2248[]{class_2246.field_17350}).method_35042(BingoUtil.compound(Map.of("Items", BingoUtil.list(slots))))), (class_2073.class_2074)class_2073.class_2074.method_8973())).name((class_2561)class_2561.method_43469((String)"bingo.goal.fill_all_campfire_slots", (Object[])new Object[]{class_2246.field_17350.method_9518()})).icon(VeryEasyGoalProvider.makeItemWithGlint((class_1935)class_1802.field_17346)).tags(BingoTags.ACTION));
        this.addGoal(BingoGoal.builder(this.id("dye_sign")).criterion("dye", class_4711.class_4712.method_27981((class_2090.class_2091)class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_29233((class_7871)blocks, class_3481.field_41282)), (class_2073.class_2074)class_2073.class_2074.method_8973().method_8975((class_7871)items, ConventionalItemTags.DYES))).name("dye_sign").tags(BingoTags.ACTION).icon(class_1802.field_8788));
        this.addGoal(BingoGoal.builder(this.id("extinguish_campfire")).criterion("extinguish", class_4711.class_4712.method_27981((class_2090.class_2091)class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_27962((class_7871)blocks, new class_2248[]{class_2246.field_17350})), (class_2073.class_2074)class_2073.class_2074.method_8973().method_8975((class_7871)items, class_3489.field_42615))).name("extinguish_campfire").tags(BingoTags.ACTION).icon(class_1802.field_17346));
        this.addGoal(BingoGoal.builder(this.id("never_pickup_crafting_tables")).criterion("pickup", ItemPickedUpTrigger.TriggerInstance.pickedUp(class_2048.class_2049.method_8916().method_43094((class_7376)ItemEntityPredicate.item(class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8465}).method_8976())).method_8920())).tags(BingoTags.NEVER).name("never_pickup_crafting_tables").tooltip("never_pickup_crafting_tables").icon(class_1802.field_8465));
        this.addGoal(VeryEasyGoalProvider.obtainSomeItemsFromTag(this.id("gold_in_name"), BingoItemTags.GOLD_IN_NAME, "bingo.goal.gold_in_name", 2, 4).tooltip("gold_in_name").antisynergy("gold_items"));
        this.addGoal(VeryEasyGoalProvider.obtainSomeItemsFromTag(this.id("copper_in_name"), BingoItemTags.COPPER_IN_NAME, "bingo.goal.copper_in_name", 2, 4).tooltip("copper_in_name").antisynergy("copper_items"));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("sand"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8858, 10, 32).infrequency(2).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("sandstone"), (class_7225<class_1792>)items, (class_1935)class_1802.field_20384, 5, 10).infrequency(2).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("cut_sandstone"), (class_7225<class_1792>)items, (class_1935)class_1802.field_20385, 5, 10).setAntisynergy("sandstone").infrequency(2).tags(BingoTags.OVERWORLD));
        this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("paper"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8407, 2, 5).infrequency(2).tags(BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("never_fish")).criterion("use", TryUseItemTrigger.builder().item(class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8378}).method_8976()).build()).tags(BingoTags.NEVER, BingoTags.OVERWORLD).name("never_fish").tooltip("never_fish").icon(class_1802.field_8378).catalyst("fishing"));
        this.addGoal(BingoGoal.builder(this.id("break_hoe")).criterion("break", class_2069.class_2071.method_35229(Optional.of(class_2073.class_2074.method_8973().method_8975((class_7871)items, class_3489.field_42613).method_8976()), (class_2096.class_2100)class_2096.class_2100.method_35289((int)0))).tags(BingoTags.ACTION, BingoTags.STAT).name("break_hoe").icon(class_1802.field_8431));
        this.addGoal(BingoGoal.builder(this.id("bounce_on_bed")).criterion("bounce", BounceOnBlockTrigger.TriggerInstance.bounceOnBlock(class_4550.class_4710.method_23880().method_29233((class_7871)blocks, class_3481.field_16443))).tags(BingoTags.ACTION, BingoTags.OVERWORLD).name("bounce_on_bed").icon(class_1802.field_8258));
        this.addGoal(BingoGoal.builder(this.id("hang_painting")).criterion("hang", AdjacentPaintingTrigger.builder().count(class_2096.class_2100.method_9053((int)1)).build()).name("hang_painting").icon(class_1802.field_8892).antisynergy("painting").tags(BingoTags.ACTION, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("fill_composter")).criterion("fill", class_174.field_24478.method_53699((class_184)new class_4711.class_4712(Optional.empty(), Optional.of(class_5258.method_27973((class_5341[])new class_5341[]{class_212.method_900((class_2248)class_2246.field_17563).method_22584(class_4559.class_4560.method_22523().method_22524((class_2769)class_3962.field_17565, 7)).build()}))))).name("fill_composter").tooltip("fill_composter").tags(BingoTags.ACTION).icon(class_2246.field_17563.method_9564().method_11657((class_2769)class_3962.field_17565, (Comparable)Integer.valueOf(8))));
        for (String woodType : List.of("oak", "spruce", "birch", "dark_oak", "acacia", "cherry")) {
            this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id(woodType + "_planks"), (class_7225<class_1792>)items, VeryEasyGoalProvider.itemResource(woodType + "_planks"), 32, 64).tags(BingoTags.OVERWORLD).infrequency(25));
            this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id(woodType + "_log"), (class_7225<class_1792>)items, VeryEasyGoalProvider.itemResource(woodType + "_log"), 5, 15).tags(BingoTags.OVERWORLD).infrequency(25));
            this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id(woodType + "_wood"), (class_7225<class_1792>)items, VeryEasyGoalProvider.itemResource(woodType + "_wood"), 5, 10).infrequency(25).tags(BingoTags.OVERWORLD));
            this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("stripped_" + woodType + "_wood"), (class_7225<class_1792>)items, VeryEasyGoalProvider.itemResource("stripped_" + woodType + "_wood"), 5, 10).reactant("axe_use").infrequency(25).tags(BingoTags.OVERWORLD));
            this.addGoal(VeryEasyGoalProvider.obtainItemGoal(this.id("stripped_" + woodType + "_log"), (class_7225<class_1792>)items, VeryEasyGoalProvider.itemResource("stripped_" + woodType + "_log"), 5, 15).reactant("axe_use").infrequency(25).tags(BingoTags.OVERWORLD));
        }
    }
}

