/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.fabric.datagen.goal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import io.github.gaming32.bingo.conditions.HasOnlyBeenDamagedByCondition;
import io.github.gaming32.bingo.data.BingoDifficulties;
import io.github.gaming32.bingo.data.BingoTags;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.goal.GoalBuilder;
import io.github.gaming32.bingo.data.icons.CycleIcon;
import io.github.gaming32.bingo.data.icons.EntityIcon;
import io.github.gaming32.bingo.data.icons.InstrumentCycleIcon;
import io.github.gaming32.bingo.data.icons.ItemIcon;
import io.github.gaming32.bingo.data.icons.ItemTagCycleIcon;
import io.github.gaming32.bingo.data.progresstrackers.AchievedRequirementsProgressTracker;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.tags.bingo.BingoBlockTags;
import io.github.gaming32.bingo.data.tags.bingo.BingoItemTags;
import io.github.gaming32.bingo.fabric.datagen.goal.DifficultyGoalProvider;
import io.github.gaming32.bingo.triggers.BeaconEffectTrigger;
import io.github.gaming32.bingo.triggers.CompleteMapTrigger;
import io.github.gaming32.bingo.triggers.DifferentPotionsTrigger;
import io.github.gaming32.bingo.triggers.EntityDieNearPlayerTrigger;
import io.github.gaming32.bingo.triggers.ExperienceChangeTrigger;
import io.github.gaming32.bingo.triggers.ItemPickedUpTrigger;
import io.github.gaming32.bingo.triggers.PartyParrotsTrigger;
import io.github.gaming32.bingo.triggers.PowerConduitTrigger;
import io.github.gaming32.bingo.triggers.ZombifyPigTrigger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_10710;
import net.minecraft.class_10914;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_174;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1842;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2019;
import net.minecraft.class_2025;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2080;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2135;
import net.minecraft.class_215;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7058;
import net.minecraft.class_7225;
import net.minecraft.class_7444;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8782;
import net.minecraft.class_9329;
import net.minecraft.class_9334;

public class VeryHardGoalProvider
extends DifficultyGoalProvider {
    public VeryHardGoalProvider(BiConsumer<class_2960, BingoGoal> goalAdder, class_7225.class_7874 registries) {
        super(BingoDifficulties.VERY_HARD, goalAdder, registries);
    }

    @Override
    public void addGoals() {
        class_7225.class_7226 structures = this.registries.method_46762(class_7924.field_41246);
        class_7225.class_7226 items = this.registries.method_46762(class_7924.field_41197);
        class_7225.class_7226 entityTypes = this.registries.method_46762(class_7924.field_41266);
        class_7225.class_7226 potions = this.registries.method_46762(class_7924.field_41215);
        this.addGoal(VeryHardGoalProvider.obtainSomeItemsFromTag(this.id("ores"), (class_6862<class_1792>)ConventionalItemTags.ORES, "bingo.goal.ores", 5, 7).tooltip("ores").tags(BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("different_potions")).sub("count", BingoSub.random(12, 15)).criterion("potions", DifferentPotionsTrigger.TriggerInstance.differentPotions(1), subber -> subber.sub("conditions.min_count", "count")).progress("potions").tags(BingoTags.ITEM, BingoTags.NETHER, BingoTags.COMBAT, BingoTags.OVERWORLD).reactant("pacifist").name((class_2561)class_2561.method_43469((String)"bingo.goal.different_potions", (Object[])new Object[]{0}), subber -> subber.sub("with.0", "count")).tooltip("different_potions").icon(VeryHardGoalProvider.createPotionsIcon((class_7225<class_1842>)potions, class_1802.field_8574), subber -> subber.sub("icons.*.item.count", "count")));
        this.addGoal(this.obtainAllItemsFromTag((class_6862<class_1792>)class_3489.field_48296, "chestplates").tags(BingoTags.NETHER).tooltip("all_somethings.armor"));
        this.addGoal(VeryHardGoalProvider.obtainItemGoal(this.id("any_head"), (class_7225<class_1792>)items, new class_1799((class_1935)class_1802.field_8470), class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8398, class_1802.field_8575, class_1802.field_8470, class_1802.field_8681, class_1802.field_8712, class_1802.field_41304})).tags(BingoTags.COMBAT, BingoTags.OVERWORLD).name("any_head").tooltip("any_head"));
        this.addGoal(BingoGoal.builder(this.id("all_dyes")).criterion("obtain", class_2066.class_2068.method_8959((class_1935[])((class_1935[])Arrays.stream(class_1767.values()).map(class_1769::method_7803).toArray(class_1935[]::new)))).tags(BingoTags.COLOR, BingoTags.OVERWORLD).name("all_dyes").tooltip((class_2561)class_2561.method_43469((String)"bingo.sixteen_bang", (Object[])Arrays.stream(class_1767.values()).map(color -> class_2561.method_43471((String)("color.minecraft." + color.method_7792()))).toArray(Object[]::new))).icon(new CycleIcon((List)Arrays.stream(class_1767.values()).map(class_1769::method_7803).map(i -> new class_1799((class_1935)i, 16)).map(ItemIcon::new).collect(ImmutableList.toImmutableList()))).antisynergy("every_color").reactant("use_furnace"));
        this.addGoal(BingoGoal.builder(this.id("levels")).criterion("obtain", ExperienceChangeTrigger.builder().levels(class_2096.class_2100.method_9053((int)50)).build()).tags(BingoTags.STAT).name((class_2561)class_2561.method_43469((String)"bingo.goal.levels", (Object[])new Object[]{50})).icon(new class_1799((class_1935)class_1802.field_8287, 50)).infrequency(2).antisynergy("levels"));
        this.addGoal(VeryHardGoalProvider.obtainItemGoal(this.id("tipped_arrow"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8087, 16, 32).tags(BingoTags.NETHER, BingoTags.OVERWORLD).icon(VeryHardGoalProvider.createPotionsIcon((class_7225<class_1842>)potions, class_1802.field_8087), subber -> subber.sub("icons.*.item.count", "count")));
        this.addGoal(VeryHardGoalProvider.mineralPillarGoal(this.id("all_mineral_blocks"), BingoBlockTags.ALL_MINERAL_BLOCKS).name("all_mineral_blocks").tooltip("all_mineral_blocks").tags(BingoTags.OVERWORLD, BingoTags.NETHER).icon(new ItemTagCycleIcon(BingoItemTags.ALL_MINERAL_BLOCKS)));
        this.addGoal(BingoGoal.builder(this.id("sleep_in_mansion")).criterion("sleep", class_174.field_1212.method_53699((class_184)new class_2135.class_2137(Optional.of(class_2048.method_51704((class_2048)class_2048.class_2049.method_8916().method_8918(class_2090.class_2091.method_53183((class_6880)structures.method_46747(class_7058.field_37171))).method_8920()))))).tags(BingoTags.ACTION, BingoTags.RARE_BIOME, BingoTags.OVERWORLD).name("sleep_in_mansion").icon(class_1802.field_8464));
        this.addGoal(VeryHardGoalProvider.obtainItemGoal(this.id("mycelium"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8610, 10, 32).tags(BingoTags.RARE_BIOME, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("coral_blocks")).criterion("obtain", class_2066.class_2068.method_8959((class_1935[])new class_1935[]{class_1802.field_8402, class_1802.field_8474, class_1802.field_8883, class_1802.field_8278, class_1802.field_8104})).tags(BingoTags.ITEM, BingoTags.RARE_BIOME, BingoTags.OCEAN, BingoTags.OVERWORLD).name("coral_blocks").icon(new CycleIcon(ItemIcon.ofItem((class_1935)class_1802.field_8402), ItemIcon.ofItem((class_1935)class_1802.field_8474), ItemIcon.ofItem((class_1935)class_1802.field_8883), ItemIcon.ofItem((class_1935)class_1802.field_8278), ItemIcon.ofItem((class_1935)class_1802.field_8104))));
        this.addGoal(VeryHardGoalProvider.obtainItemGoal(this.id("blue_ice"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8178, 32, 64).tags(BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("full_power_conduit")).criterion("power", PowerConduitTrigger.TriggerInstance.powerConduit(class_2096.class_2100.method_9058((int)6))).tags(BingoTags.BUILD, BingoTags.OCEAN, BingoTags.OVERWORLD).name("full_power_conduit").icon(class_1802.field_8140));
        this.addGoal(BingoGoal.builder(this.id("all_diamond_craftables")).criterion("obtain", class_2066.class_2068.method_8959((class_1935[])new class_1935[]{class_1802.field_8603, class_1802.field_8556, class_1802.field_8285, class_1802.field_8058, class_1802.field_8805, class_1802.field_8527, class_1802.field_8348, class_1802.field_8377, class_1802.field_8250, class_1802.field_8802, class_1802.field_8657, class_1802.field_8450, class_1802.field_8565})).name("all_diamond_craftables").tooltip("all_diamond_craftables").icon(new CycleIcon(ItemIcon.ofItem((class_1935)class_1802.field_8603), ItemIcon.ofItem((class_1935)class_1802.field_8556), ItemIcon.ofItem((class_1935)class_1802.field_8285), ItemIcon.ofItem((class_1935)class_1802.field_8058), ItemIcon.ofItem((class_1935)class_1802.field_8805), ItemIcon.ofItem((class_1935)class_1802.field_8527), ItemIcon.ofItem((class_1935)class_1802.field_8348), ItemIcon.ofItem((class_1935)class_1802.field_8377), ItemIcon.ofItem((class_1935)class_1802.field_8250), ItemIcon.ofItem((class_1935)class_1802.field_8802), ItemIcon.ofItem((class_1935)class_1802.field_8657), ItemIcon.ofItem((class_1935)class_1802.field_8450), ItemIcon.ofItem((class_1935)class_1802.field_8565))).antisynergy("diamond_items"));
        this.addGoal(BingoGoal.builder(this.id("shulker_in_overworld")).criterion("kill", class_2080.class_2083.method_8997((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6109).method_8918(class_2090.class_2091.method_53182((class_5321)class_1937.field_25179)))).tags(BingoTags.ACTION, BingoTags.COMBAT, BingoTags.END, BingoTags.OVERWORLD).name("shulker_in_overworld").icon(class_1802.field_8815).reactant("pacifist"));
        this.addGoal(VeryHardGoalProvider.obtainItemGoal(this.id("diamond_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8603, 5, 10).infrequency(2));
        this.addGoal(BingoGoal.builder(this.id("complete_full_size_end_map")).criterion("complete", CompleteMapTrigger.TriggerInstance.completeMap(class_2096.class_2100.method_9053((int)4), class_2090.class_2091.method_53182((class_5321)class_1937.field_25181).method_9023())).tags(BingoTags.ACTION, BingoTags.OVERWORLD, BingoTags.END).name("complete_full_size_end_map").icon(class_1802.field_8204).antisynergy("complete_map"));
        this.addGoal(VeryHardGoalProvider.obtainItemGoal(this.id("wither_rose"), (class_7225<class_1792>)items, (class_1935)class_1802.field_17515, 32, 64).reactant("pacifist").tags(BingoTags.NETHER, BingoTags.COMBAT));
        this.addGoal(BingoGoal.builder(this.id("panda_slime_ball")).criterion("pickup", ItemPickedUpTrigger.TriggerInstance.pickedUpFrom(class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8777}).method_8976(), class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6146).method_8920())).tags(BingoTags.ITEM, BingoTags.OVERWORLD, BingoTags.RARE_BIOME).name("panda_slime_ball").icon(class_1802.field_8777));
        this.addGoal(VeryHardGoalProvider.obtainItemGoal(this.id("netherite_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_22018, 2, 2).tags(BingoTags.NETHER));
        this.addGoal(BingoGoal.builder(this.id("full_netherite_armor_and_tools")).criterion("obtain", class_2066.class_2068.method_8959((class_1935[])new class_1935[]{class_1802.field_22030, class_1802.field_22029, class_1802.field_22028, class_1802.field_22027, class_1802.field_22022, class_1802.field_22023, class_1802.field_22024, class_1802.field_22025, class_1802.field_22026})).tags(BingoTags.ITEM, BingoTags.NETHER).name("full_netherite_armor_and_tools").icon(new CycleIcon(ItemIcon.ofItem((class_1935)class_1802.field_22030), ItemIcon.ofItem((class_1935)class_1802.field_22029), ItemIcon.ofItem((class_1935)class_1802.field_22028), ItemIcon.ofItem((class_1935)class_1802.field_22027), ItemIcon.ofItem((class_1935)class_1802.field_22022), ItemIcon.ofItem((class_1935)class_1802.field_22023), ItemIcon.ofItem((class_1935)class_1802.field_22024), ItemIcon.ofItem((class_1935)class_1802.field_22025), ItemIcon.ofItem((class_1935)class_1802.field_22026))));
        this.addGoal(BingoGoal.builder(this.id("zombify_pig")).criterion("channeling", ZombifyPigTrigger.zombifyPig().direct(true).build()).criterion("nearby", ZombifyPigTrigger.zombifyPig().pig(class_2048.class_2049.method_8916().method_8924(class_2025.method_37223((class_2096.class_2099)class_2096.class_2099.method_35286((double)16.0))).method_8920()).direct(false).build()).requirements(class_8782.class_8797.field_1257).name("zombify_pig").tags(BingoTags.ACTION, BingoTags.OVERWORLD).icon(class_1802.field_8261));
        this.addGoal(VeryHardGoalProvider.obtainItemGoal(this.id("trident"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8547).tags(BingoTags.OCEAN, BingoTags.COMBAT, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("party_parrots")).criterion("party", PartyParrotsTrigger.TriggerInstance.partyParrots()).name("party_parrots").tags(BingoTags.ACTION, BingoTags.OVERWORLD, BingoTags.RARE_BIOME).icon(class_1802.field_8075));
        this.addGoal(VeryHardGoalProvider.bedRowGoal(this.id("bed_row"), 16, 16).reactant("use_furnace").antisynergy("every_color").infrequency(2).tags(BingoTags.ACTION).tooltip((class_2561)class_2561.method_43469((String)"bingo.sixteen_bang", (Object[])Arrays.stream(class_1767.values()).map(color -> class_2561.method_43471((String)("color.minecraft." + color.method_7792()))).toArray(Object[]::new))));
        this.addGoal(BingoGoal.builder(this.id("kill_enderman_with_endermites")).criterion("kill", EntityDieNearPlayerTrigger.builder().entity(class_5258.method_27973((class_5341[])new class_5341[]{class_215.method_917((class_47.class_50)class_47.class_50.field_935, (class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6091)).build(), HasOnlyBeenDamagedByCondition.builder().entityType(class_1299.field_6128).build()})).killingBlow(class_2019.class_2020.method_8844().method_35117(class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6128).method_8920()).method_8843()).build()).name("kill_enderman_with_endermites").tooltip("kill_enderman_with_endermites").icon(EntityIcon.ofSpawnEgg(class_1299.field_6128)).tags(BingoTags.ACTION, BingoTags.COMBAT, BingoTags.END));
        this.addGoal(BingoGoal.builder(this.id("beacon_regen")).criterion("effect", BeaconEffectTrigger.TriggerInstance.effectApplied((class_6880<class_1291>)class_1294.field_5924)).tags(BingoTags.ITEM, BingoTags.NETHER, BingoTags.OVERWORLD, BingoTags.COMBAT).name("beacon_regen").icon(class_2246.field_10327).reactant("pacifist"));
        this.addGoal(VeryHardGoalProvider.obtainSomeItemsFromTag(this.id("armor_trims"), BingoItemTags.TRIM_TEMPLATES, "bingo.goal.armor_trims", 5, 5).antisynergy("armor_trims"));
        this.addGoal(this.obtainAllGoatHorns());
        this.addGoal(this.obtainAllItemsFromTag(BingoItemTags.CLIMBABLE, "climbables").tags(BingoTags.NETHER, BingoTags.RARE_BIOME, BingoTags.OVERWORLD));
    }

    private GoalBuilder obtainAllGoatHorns() {
        class_7225.class_7226 items = this.registries.method_46762(class_7924.field_41197);
        ImmutableSortedSet sortedInstruments = (ImmutableSortedSet)this.registries.method_46762(class_7924.field_41275).method_42017().collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.comparing(e -> e.method_40237().method_29177())));
        GoalBuilder builder = BingoGoal.builder(this.id("all_goat_horns"));
        for (class_6880.class_6883 instrument : sortedInstruments) {
            class_2960 location = instrument.method_40237().method_29177();
            builder.criterion("obtain_" + location.method_12836() + "_" + location.method_12832(), class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_39057}).method_57299(class_10914.class_10915.method_68683().method_68684(class_9329.method_57862().method_57872(class_9334.field_49612, (Object)new class_10710((class_6880)instrument)).method_57871()).method_68686()).method_8976()}));
        }
        return builder.tags(BingoTags.ITEM, BingoTags.OVERWORLD).name("all_goat_horns").tooltip((class_2561)class_2564.method_36332((Collection)sortedInstruments, (class_2561)class_2564.field_33538, holder -> ((class_7444)holder.comp_349()).comp_2929())).progress(AchievedRequirementsProgressTracker.INSTANCE).icon(new InstrumentCycleIcon((class_6880<class_1792>)class_1802.field_39057.method_40131())).antisynergy("goat_horn");
    }
}

