/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.fabric.datagen.tag;

import io.github.gaming32.bingo.data.tags.bingo.BingoBlockTags;
import io.github.gaming32.bingo.data.tags.bingo.BingoItemTags;
import io.github.gaming32.bingo.fabric.datagen.BingoDataGenUtil;
import io.github.gaming32.bingo.mixin.fabric.CompositeEntryBaseAccessor;
import io.github.gaming32.bingo.mixin.fabric.LootItemAccessor;
import io.github.gaming32.bingo.mixin.fabric.LootPoolAccessor;
import io.github.gaming32.bingo.mixin.fabric.LootTableAccessor;
import io.github.gaming32.bingo.mixin.fabric.MobBucketItemAccessor;
import io.github.gaming32.bingo.mixin.fabric.NestedLootTableAccessor;
import io.github.gaming32.bingo.mixin.fabric.TagEntryAccessor;
import io.github.gaming32.bingo.util.ResourceLocations;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_11389;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1422;
import net.minecraft.class_1747;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_69;
import net.minecraft.class_7225;
import net.minecraft.class_73;
import net.minecraft.class_77;
import net.minecraft.class_7803;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_83;
import net.minecraft.class_8810;
import net.minecraft.class_91;
import net.minecraft.class_9334;

public class BingoItemTagProvider
extends FabricTagProvider.ItemTagProvider {
    private static final Set<class_1792> FORCED_MEAT = Set.of(class_1802.field_8429, class_1802.field_8373, class_1802.field_8209, class_1802.field_8509, class_1802.field_8323, class_1802.field_8846, class_1802.field_8680, class_1802.field_8308);

    public BingoItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture, FabricTagProvider.BlockTagProvider blockTagProvider) {
        super(output, registriesFuture, blockTagProvider);
    }

    protected void method_10514(class_7225.class_7874 registries) {
        class_7225.class_7226 items = registries.method_46762(class_7924.field_41197);
        BingoDataGenUtil.loadVanillaTag(class_3481.field_22414, registries).method_40239().map(x -> ((class_2248)x.comp_349()).method_8389()).filter(x -> x != class_1802.field_8162).forEachOrdered(arg_0 -> ((class_11389)this.valueLookupBuilder(BingoItemTags.CLIMBABLE)).method_71554(arg_0));
        BingoItemTagProvider.addItemsFromLootTable((class_11389<class_1792, class_1792>)this.valueLookupBuilder(BingoItemTags.FISHING_JUNK), (class_5321<class_52>)class_39.field_266, registries, (class_1792 item) -> item != class_1802.field_8378);
        BingoItemTagProvider.addItemsFromLootTable((class_11389<class_1792, class_1792>)this.valueLookupBuilder(BingoItemTags.FISHING_TREASURE), (class_5321<class_52>)class_39.field_854, registries, (class_1792 item) -> item != class_1802.field_8378 && item != class_1802.field_8529);
        this.valueLookupBuilder(BingoItemTags.FISHING_TREASURE).method_71554((Object)class_1802.field_8598);
        this.valueLookupBuilder(BingoItemTags.LIVING_CORAL_BLOCKS).method_71558((Object[])new class_1792[]{class_1802.field_8402, class_1802.field_8474, class_1802.field_8883, class_1802.field_8278, class_1802.field_8104});
        this.valueLookupBuilder(BingoItemTags.DEAD_CORAL_BLOCKS).method_71558((Object[])new class_1792[]{class_1802.field_8237, class_1802.field_8089, class_1802.field_8160, class_1802.field_8698, class_1802.field_8856});
        class_11389 fishBucketsBuilder = this.valueLookupBuilder(BingoItemTags.FISH_BUCKETS);
        class_11389 trimTemplatesBuilder = this.valueLookupBuilder(BingoItemTags.TRIM_TEMPLATES);
        class_7803.method_51694().map(class_7803.class_8905::comp_2012).forEach(arg_0 -> ((class_11389)trimTemplatesBuilder).method_71554(arg_0));
        class_6885.class_6886 vanillaMeat = BingoDataGenUtil.loadVanillaTag(class_3489.field_49932, registries);
        class_6885.class_6886 vanillaVillagerPlantableSeeds = BingoDataGenUtil.loadVanillaTag(class_3489.field_44591, registries);
        class_6885.class_6886 vanillaSaplings = BingoDataGenUtil.loadVanillaTag(class_3489.field_15528, registries);
        class_11389 goldInNameBuilder = this.valueLookupBuilder(BingoItemTags.GOLD_IN_NAME);
        class_11389 copperInNameBuilder = this.valueLookupBuilder(BingoItemTags.COPPER_IN_NAME);
        class_11389 diamondInNameBuilder = this.valueLookupBuilder(BingoItemTags.DIAMOND_IN_NAME);
        class_11389 meatBuilder = this.valueLookupBuilder(BingoItemTags.MEAT);
        class_11389 notMeatBuilder = this.valueLookupBuilder(BingoItemTags.NOT_MEAT);
        class_11389 torchesBuilder = this.valueLookupBuilder(BingoItemTags.TORCHES);
        class_11389 bannerPatternsBuilder = this.valueLookupBuilder(BingoItemTags.BANNER_PATTERNS);
        class_11389 bonemealableBuilder = this.valueLookupBuilder(BingoItemTags.BONEMEALABLE).forceAddTag(class_3489.field_44591).forceAddTag(class_3489.field_15528);
        Pattern goldPattern = Pattern.compile("\\bGold(?:en)?\\b");
        Pattern copperPattern = Pattern.compile("\\bCopper\\b");
        Pattern diamondPattern = Pattern.compile("\\bDiamond\\b");
        items.method_42017().forEach(item -> {
            String itemName = ((class_1792)item.comp_349()).method_63680().getString();
            if (goldPattern.matcher(itemName).find()) {
                goldInNameBuilder.method_71554((Object)((class_1792)item.comp_349()));
            }
            if (copperPattern.matcher(itemName).find()) {
                copperInNameBuilder.method_71554((Object)((class_1792)item.comp_349()));
            }
            if (diamondPattern.matcher(itemName).find()) {
                diamondInNameBuilder.method_71554((Object)((class_1792)item.comp_349()));
            }
            if (((class_1792)item.comp_349()).method_57347().method_57832(class_9334.field_50075)) {
                if (vanillaMeat.method_40241((class_6880)item) || FORCED_MEAT.contains(item.comp_349())) {
                    meatBuilder.method_71554((Object)((class_1792)item.comp_349()));
                } else {
                    notMeatBuilder.method_71554((Object)((class_1792)item.comp_349()));
                }
            }
            if (((class_1792)item.comp_349()).method_57347().method_58694(class_9334.field_56398) != null) {
                bannerPatternsBuilder.method_71554((Object)((class_1792)item.comp_349()));
            }
            class_1792 class_17922 = (class_1792)item.comp_349();
            Objects.requireNonNull(class_17922);
            class_1792 selector0$temp = class_17922;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1785.class, class_1747.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    class_1785 mobBucketItem = (class_1785)selector0$temp;
                    class_1299<? extends class_1308> entityType = ((MobBucketItemAccessor)mobBucketItem).getType();
                    Class<? extends class_1308> entityTypeClass = BingoDataGenUtil.getEntityTypeClass(entityType);
                    if (entityTypeClass == null || entityType == class_1299.field_37420 || !class_1422.class.isAssignableFrom(entityTypeClass)) break;
                    fishBucketsBuilder.method_71554((Object)((class_1792)item.comp_349()));
                    break;
                }
                case 1: {
                    class_2248 block;
                    class_1747 blockItem = (class_1747)selector0$temp;
                    class_2248 class_22482 = block = blockItem.method_7711();
                    Objects.requireNonNull(class_22482);
                    class_2248 selector2$temp = class_22482;
                    int index$3 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_8810.class, class_2256.class}, (Object)selector2$temp, index$3)) {
                        case 0: {
                            class_8810 ignored = (class_8810)selector2$temp;
                            torchesBuilder.method_71554((Object)((class_1792)item.comp_349()));
                            break;
                        }
                        case 1: {
                            class_2256 ignored = (class_2256)selector2$temp;
                            if (vanillaVillagerPlantableSeeds.method_40241((class_6880)item) || vanillaSaplings.method_40241((class_6880)item)) break;
                            bonemealableBuilder.method_71554((Object)((class_1792)item.comp_349()));
                            break;
                        }
                    }
                    break;
                }
            }
        });
        this.copy(BingoBlockTags.BASIC_MINERAL_BLOCKS, BingoItemTags.BASIC_MINERAL_BLOCKS);
        this.copy(BingoBlockTags.ALL_MINERAL_BLOCKS, BingoItemTags.ALL_MINERAL_BLOCKS);
    }

    private static class_5321<class_1792> item(String path) {
        return class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)ResourceLocations.minecraft(path));
    }

    private static void addItemsFromLootTable(class_11389<class_1792, class_1792> tagAppender, class_5321<class_52> lootTable, class_7225.class_7874 registries, Predicate<class_1792> filter) {
        BingoItemTagProvider.addItemsFromLootTable(tagAppender, BingoDataGenUtil.loadVanillaLootTable(lootTable, registries), registries, filter);
    }

    private static void addItemsFromLootTable(class_11389<class_1792, class_1792> tagAppender, class_52 lootTable, class_7225.class_7874 registries, Predicate<class_1792> filter) {
        for (class_55 pool : ((LootTableAccessor)lootTable).getPools()) {
            for (class_79 entry : ((LootPoolAccessor)pool).getEntries()) {
                BingoItemTagProvider.addItemsFromLootEntry(tagAppender, entry, registries, filter);
            }
        }
    }

    private static void addItemsFromLootEntry(class_11389<class_1792, class_1792> tagAppender, class_79 lootEntry, class_7225.class_7874 registries, Predicate<class_1792> filter) {
        class_79 class_792 = lootEntry;
        Objects.requireNonNull(class_792);
        class_79 class_793 = class_792;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_69.class, class_77.class, class_91.class, class_83.class, class_73.class}, (Object)class_793, n)) {
            case 0: {
                class_69 composite = (class_69)class_793;
                for (class_79 child : ((CompositeEntryBaseAccessor)composite).getChildren()) {
                    BingoItemTagProvider.addItemsFromLootEntry(tagAppender, child, registries, filter);
                }
                break;
            }
            case 1: {
                class_77 lootItem = (class_77)class_793;
                class_1792 item = (class_1792)((LootItemAccessor)lootItem).getItem().comp_349();
                if (!filter.test(item)) break;
                tagAppender.method_71554((Object)item);
                break;
            }
            case 2: {
                class_91 tagEntry = (class_91)class_793;
                tagAppender.forceAddTag(((TagEntryAccessor)tagEntry).getTag());
                break;
            }
            case 3: {
                class_83 nestedTable = (class_83)class_793;
                class_52 nestedTableObj = (class_52)((NestedLootTableAccessor)nestedTable).getContents().map(lootTableKey -> BingoDataGenUtil.loadVanillaLootTable((class_5321<class_52>)lootTableKey, registries), Function.identity());
                BingoItemTagProvider.addItemsFromLootTable(tagAppender, nestedTableObj, registries, filter);
                break;
            }
            case 4: {
                class_73 ignored = (class_73)class_793;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown loot entry type : " + lootEntry.getClass().getName());
            }
        }
    }
}

