/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.progresstrackers.EmptyProgressTracker;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTracker;
import io.github.gaming32.bingo.util.BingoCodecs;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7871;
import net.minecraft.class_8782;
import net.minecraft.class_8824;
import net.minecraft.class_8942;
import net.minecraft.class_8944;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public record ActiveGoal(class_2960 id, class_2561 name, Optional<class_2561> tooltip, Optional<class_2960> tooltipIcon, GoalIcon icon, Map<String, class_175<?>> criteria, int requiredCount, Optional<class_6880<BingoDifficulty>> difficulty, class_8782 requirements, BingoTag.SpecialType specialType, ProgressTracker progress) {
    public static final Codec<ActiveGoal> PERSISTENCE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(ActiveGoal::id), (App)class_8824.field_46597.fieldOf("name").forGetter(ActiveGoal::name), (App)class_8824.field_46597.optionalFieldOf("tooltip").forGetter(ActiveGoal::tooltip), (App)class_2960.field_25139.optionalFieldOf("tooltip_icon").forGetter(ActiveGoal::tooltipIcon), (App)GoalIcon.CODEC.fieldOf("icon").forGetter(ActiveGoal::icon), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_175.field_47188).fieldOf("criteria").forGetter(ActiveGoal::criteria), (App)Codec.INT.fieldOf("required_count").forGetter(ActiveGoal::requiredCount), (App)BingoCodecs.notOptional(class_6899.method_40400(BingoRegistries.DIFFICULTY)).fieldOf("difficulty").forGetter(ActiveGoal::difficulty), (App)class_8782.field_47184.fieldOf("requirements").forGetter(ActiveGoal::requirements), (App)BingoTag.SpecialType.CODEC.optionalFieldOf("special_type", (Object)BingoTag.SpecialType.NONE).forGetter(ActiveGoal::specialType), (App)ProgressTracker.CODEC.optionalFieldOf("progress", (Object)EmptyProgressTracker.INSTANCE).forGetter(ActiveGoal::progress)).apply((Applicative)instance, ActiveGoal::new));
    public static final class_9139<class_9129, ActiveGoal> STREAM_CODEC = class_9139.method_58025((class_9139)class_2960.field_48267, ActiveGoal::id, (class_9139)class_8824.field_49666, ActiveGoal::name, (class_9139)class_8824.field_49667, ActiveGoal::tooltip, (class_9139)class_2960.field_48267.method_56433(class_9135::method_56382), ActiveGoal::tooltipIcon, GoalIcon.STREAM_CODEC, ActiveGoal::icon, BingoTag.SpecialType.STREAM_CODEC, ActiveGoal::specialType, ActiveGoal::forClient);

    public static ActiveGoal forClient(class_2960 id, class_2561 name, Optional<class_2561> tooltip, Optional<class_2960> tooltipIcon, GoalIcon icon, BingoTag.SpecialType specialType) {
        return new ActiveGoal(id, name, tooltip, tooltipIcon, icon, Map.of(), 1, Optional.empty(), class_8782.field_46084, specialType, EmptyProgressTracker.INSTANCE);
    }

    public class_1799 getFallbackWithComponents(class_5455 access) {
        class_1799 result = this.icon.getFallback(access);
        result.method_57379(class_9334.field_50239, (Object)this.name);
        result.method_57379(class_9334.field_50073, (Object)class_1814.field_8906);
        if (result.method_7947() > result.method_7914()) {
            result.method_57379(class_9334.field_50071, (Object)Math.min(result.method_7947(), 99));
        }
        this.tooltip.ifPresent(component -> result.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(component))));
        result.method_57379(class_9334.field_49636, (Object)new class_9285(List.of()));
        return result;
    }

    public void validateAndLog(class_7871.class_7872 lootData) {
        class_8942.class_8943 collector = new class_8942.class_8943();
        this.validate((class_8942)collector, lootData);
        if (!collector.method_71349()) {
            Bingo.LOGGER.warn("Found validation problems in goal {}:\n{}", (Object)this.id, (Object)collector.method_59906());
        }
    }

    private void validate(class_8942 reporter, class_7871.class_7872 lootData) {
        this.criteria.forEach((key, criterion) -> {
            class_8944 validator = new class_8944(reporter.method_54946((class_8942.class_11336)new class_8942.class_11333(key)), lootData);
            criterion.comp_1924().method_54938(validator);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ActiveGoal)) return false;
        ActiveGoal g = (ActiveGoal)obj;
        if (!this.id.equals((Object)g.id)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}

