/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.ext.ServerPlayerExt;
import io.github.gaming32.bingo.game.ActiveGoal;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.GoalProgress;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import io.github.gaming32.bingo.mixin.common.PlayerAdvancementsAccessor;
import io.github.gaming32.bingo.network.VanillaNetworking;
import io.github.gaming32.bingo.network.messages.s2c.InitBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.RemoveBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.ResyncStatesPayload;
import io.github.gaming32.bingo.network.messages.s2c.SyncTeamPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateProgressPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateStatePayload;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.util.BingoCodecs;
import io.github.gaming32.bingo.util.BingoUtil;
import io.github.gaming32.bingo.util.StatCodecs;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_175;
import net.minecraft.class_178;
import net.minecraft.class_179;
import net.minecraft.class_184;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2596;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_2779;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3445;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import net.minecraft.class_5699;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BingoGame {
    public static final class_2561 REQUIRED_CLIENT_KICK = class_2561.method_43470((String)"This bingo game requires the Bingo mod to be installed on the client. Please install it before joining.");
    public static final int DEFAULT_AUTO_FORFEIT_TICKS = 2400;
    private final BingoBoard board;
    private final BingoGameMode gameMode;
    private final boolean requireClient;
    private final boolean continueAfterWin;
    private final int autoForfeitTicks;
    private final class_268[] teams;
    private final Map<UUID, Map<ActiveGoal, class_167>> advancementProgress = new HashMap<UUID, Map<ActiveGoal, class_167>>();
    private final Map<UUID, Map<ActiveGoal, GoalProgress>> goalProgress = new HashMap<UUID, Map<ActiveGoal, GoalProgress>>();
    private final Map<UUID, Object2IntOpenHashMap<ActiveGoal>> goalAchievedCount = new HashMap<UUID, Object2IntOpenHashMap<ActiveGoal>>();
    private final Map<UUID, List<ActiveGoal>> queuedGoals = new HashMap<UUID, List<ActiveGoal>>();
    private final Map<UUID, Object2IntMap<class_3445<?>>> baseStats = new HashMap();
    private final OptionalLong[] lastActiveTimes;
    private BingoBoard.Teams remainingTeams;
    private BingoBoard.Teams winningTeams = BingoBoard.Teams.NONE;
    private BingoBoard.Teams finishedTeams = BingoBoard.Teams.NONE;
    private BingoBoard.Teams nerfedTeams = BingoBoard.Teams.NONE;

    public BingoGame(BingoBoard board, BingoGameMode gameMode, boolean requireClient, boolean continueAfterWin, int autoForfeitTicks, class_268 ... teams) {
        this.board = board;
        this.gameMode = gameMode;
        this.requireClient = requireClient;
        this.continueAfterWin = continueAfterWin;
        this.autoForfeitTicks = autoForfeitTicks;
        this.teams = teams;
        this.lastActiveTimes = new OptionalLong[teams.length];
        Arrays.fill(this.lastActiveTimes, OptionalLong.empty());
        this.remainingTeams = BingoBoard.Teams.fromAll(teams.length);
    }

    public BingoBoard getBoard() {
        return this.board;
    }

    public BingoGameMode getGameMode() {
        return this.gameMode;
    }

    public boolean isRequireClient() {
        return this.requireClient;
    }

    public boolean shouldContinueAfterWin() {
        return this.continueAfterWin;
    }

    public void addPlayer(class_3222 player) {
        Map<ActiveGoal, GoalProgress> goalProgress;
        if (this.requireClient && player.field_6012 > 60 && !Bingo.isInstalledOnClient(player)) {
            player.field_13987.method_52396(REQUIRED_CLIENT_KICK);
            return;
        }
        RemoveBoardPayload.INSTANCE.sendTo(player);
        if (((ServerPlayerExt)player).bingo$clearAdvancementsNeedClearing()) {
            player.field_13987.method_14364((class_2596)new class_2779(false, List.of(), Set.of(VanillaNetworking.ROOT_ADVANCEMENT.comp_1919()), Map.of(), false));
        }
        this.registerListeners(player);
        BingoBoard.Teams team = this.getTeam(player);
        new SyncTeamPayload(team).sendTo(player);
        InitBoardPayload.create(this, team, this.obfuscateTeam(team, (class_1657)player)).sendTo(player);
        if (!((PlayerAdvancementsAccessor)player.method_14236()).getIsFirstPacket()) {
            this.syncAdvancementsTo(player);
        }
        if ((goalProgress = this.goalProgress.get(player.method_5667())) != null) {
            goalProgress.forEach((goal, progress) -> {
                int goalIndex = this.getBoardIndex(player, (ActiveGoal)goal);
                if (goalIndex != -1) {
                    new UpdateProgressPayload(goalIndex, progress.progress(), progress.maxProgress()).sendTo(player);
                }
            });
        }
    }

    public void syncAdvancementsTo(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_2779(false, VanillaNetworking.generateAdvancements(player.method_56673(), this.board.getShape(), this.board.getSize(), this.board.getGoals()), Set.of(), VanillaNetworking.generateProgressMap(this.board.getStates(), this.getTeam(player)), false));
        ((ServerPlayerExt)player).bingo$markAdvancementsNeedClearing();
    }

    public void removePlayer(class_3222 player) {
        this.unregisterListeners(player, true);
    }

    public BingoBoard.Teams[] obfuscateTeam(BingoBoard.Teams playerTeam, class_1657 player) {
        BingoBoard.Teams[] states = this.board.getStates();
        if (player != null && player.method_7325()) {
            return states;
        }
        if (this.gameMode.getRenderMode() == BingoGameMode.RenderMode.ALL_TEAMS) {
            return states;
        }
        if (!playerTeam.any()) {
            Object[] ret = new BingoBoard.Teams[states.length];
            Arrays.fill(ret, BingoBoard.Teams.NONE);
            return ret;
        }
        BingoBoard.Teams[] result = new BingoBoard.Teams[states.length];
        for (int i = 0; i < states.length; ++i) {
            result[i] = BingoGame.obfuscateTeam(playerTeam, states[i]);
        }
        return result;
    }

    public static BingoBoard.Teams obfuscateTeam(BingoBoard.Teams playerTeam, BingoBoard.Teams state) {
        return state.and(playerTeam) ? playerTeam : BingoBoard.Teams.NONE;
    }

    public Object2IntMap<class_3445<?>> getBaseStats(class_1657 player) {
        return this.baseStats.getOrDefault(player.method_5667(), Object2IntMaps.emptyMap());
    }

    public Object2IntMap<class_3445<?>> getOrCreateBaseStats(class_1657 player) {
        return this.baseStats.computeIfAbsent(player.method_5667(), k -> new Object2IntOpenHashMap());
    }

    public void endGame(class_3324 playerList) {
        class_5250 message;
        this.clearListeners(playerList);
        if (!this.winningTeams.any()) {
            this.winningTeams = this.getWinner(true);
        }
        if (!this.winningTeams.any()) {
            this.winningTeams = this.remainingTeams;
        }
        if (this.winningTeams.any()) {
            if (!this.winningTeams.one()) {
                message = Bingo.translatable("bingo.ended.tie", new Object[0]);
            } else {
                class_268 playerTeam = this.getTeam(this.winningTeams);
                message = (class_2561)BingoUtil.mapEither(BingoUtil.getDisplayName(playerTeam, playerList), name -> {
                    if (playerTeam.method_1202() != class_124.field_1070) {
                        return name.method_27661().method_27692(playerTeam.method_1202());
                    }
                    return name;
                }).map(playerName -> Bingo.translatable("bingo.ended.single", playerName), teamName -> Bingo.translatable("bingo.ended", teamName));
            }
            for (class_3222 player : playerList.method_14571()) {
                player.method_17356(class_3417.field_15195, class_3419.field_15250, 1.0f, 1.0f);
            }
        } else {
            message = Bingo.translatable("bingo.ended.draw", new Object[0]);
        }
        playerList.method_43514((class_2561)message, false);
        ((MinecraftServerExt)playerList.method_14561()).bingo$setGame(null);
        new ResyncStatesPayload(this.board.getStates()).sendTo(playerList.method_14571());
        Bingo.updateCommandTree(playerList);
    }

    public void tick(MinecraftServer server) {
        if (this.requireClient) {
            for (class_3222 player : new ArrayList(server.method_3760().method_14571())) {
                if (player.field_6012 != 60 || Bingo.isInstalledOnClient(player)) continue;
                player.field_13987.method_52396(REQUIRED_CLIENT_KICK);
            }
        }
        if (this.autoForfeitTicks > 0 && server.method_3780() % 20 == 0) {
            long gameTime = server.method_30002().method_8510();
            for (int i = 0; i < this.teams.length; ++i) {
                BingoBoard.Teams team = BingoBoard.Teams.fromOne(i);
                if (!this.remainingTeams.and(team)) continue;
                boolean isTeamActive = this.teams[i].method_1204().stream().anyMatch(playerName -> server.method_3760().method_14566(playerName) != null);
                if (isTeamActive) {
                    this.lastActiveTimes[i] = OptionalLong.of(gameTime);
                    continue;
                }
                OptionalLong lastActiveTime = this.lastActiveTimes[i];
                if (!lastActiveTime.isPresent() || gameTime - lastActiveTime.getAsLong() < (long)this.autoForfeitTicks) continue;
                this.forfeit(server.method_3760(), team);
            }
        }
    }

    public boolean forfeit(class_3324 playerList, BingoBoard.Teams team) {
        if (!this.remainingTeams.and(team)) {
            return false;
        }
        this.remainingTeams = this.remainingTeams.andNot(team);
        class_268 playerTeam = this.getTeam(team);
        class_2561 message = (class_2561)BingoUtil.mapEither(BingoUtil.getDisplayName(playerTeam, playerList), name -> {
            if (playerTeam.method_1202() != class_124.field_1070) {
                return name.method_27661().method_27692(playerTeam.method_1202());
            }
            return name;
        }).map(playerName -> Bingo.translatable("bingo.forfeited.single", playerName), teamName -> Bingo.translatable("bingo.forfeited", teamName));
        playerList.method_43514(message, false);
        for (class_3222 player : playerList.method_14571()) {
            player.method_17356((class_3414)class_3417.field_23117.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
        }
        if (this.remainingTeams.count() <= 1) {
            this.endGame(playerList);
        }
        return true;
    }

    private void registerListeners(class_3222 player) {
        for (ActiveGoal goal : this.board.getGoals()) {
            this.registerListeners(player, goal);
        }
    }

    private void clearListeners(class_3324 playerList) {
        for (Map.Entry<UUID, Map<ActiveGoal, class_167>> playerEntry : this.advancementProgress.entrySet()) {
            class_3222 player = playerList.method_14602(playerEntry.getKey());
            if (player == null) continue;
            for (ActiveGoal goal : playerEntry.getValue().keySet()) {
                this.unregisterListeners(player, goal, true);
            }
        }
    }

    private <T extends class_184> class_179.class_180<T> createListener(class_175<T> criterion, String criterionId, ActiveGoal goal) {
        return new class_179.class_180(criterion.comp_1924(), new class_8779(BingoBoard.generateVanillaId(this.board.getIndex(goal)), null), criterionId);
    }

    private <T extends class_184> void addListener(class_175<T> criterion, String criterionId, class_3222 player, ActiveGoal goal) {
        criterion.comp_1923().method_792(player.method_14236(), this.createListener(criterion, criterionId, goal));
        class_179 class_1793 = criterion.comp_1923();
        if (class_1793 instanceof ProgressibleTrigger) {
            ProgressibleTrigger progressibleTrigger = (ProgressibleTrigger)class_1793;
            progressibleTrigger.addProgressListener(player.method_14236(), new BingoGameProgressListener<class_184>(this, goal, player, criterionId, criterion.comp_1924()));
        }
    }

    private <T extends class_184> void removeListener(class_175<T> criterion, String criterionId, class_3222 player, ActiveGoal goal) {
        criterion.comp_1923().method_793(player.method_14236(), this.createListener(criterion, criterionId, goal));
        class_179 class_1793 = criterion.comp_1923();
        if (class_1793 instanceof ProgressibleTrigger) {
            ProgressibleTrigger progressibleTrigger = (ProgressibleTrigger)class_1793;
            progressibleTrigger.removeProgressListener(player.method_14236(), new BingoGameProgressListener<class_184>(this, goal, player, criterionId, criterion.comp_1924()));
        }
    }

    private void registerListeners(class_3222 player, ActiveGoal goal) {
        class_167 progress = this.getOrStartProgress(player, goal);
        if (!progress.method_740()) {
            for (Map.Entry<String, class_175<?>> entry : goal.criteria().entrySet()) {
                class_178 criterionProgress = progress.method_737(entry.getKey());
                if (criterionProgress == null || criterionProgress.method_784()) continue;
                this.addListener(entry.getValue(), entry.getKey(), player, goal);
            }
        }
    }

    private void unregisterListeners(class_3222 player, boolean force) {
        for (ActiveGoal goal : this.board.getGoals()) {
            this.unregisterListeners(player, goal, force);
        }
    }

    private void unregisterListeners(class_3222 player, ActiveGoal goal, boolean force) {
        class_167 progress = this.getOrStartProgress(player, goal);
        for (Map.Entry<String, class_175<?>> entry : goal.criteria().entrySet()) {
            class_178 criterionProgress = progress.method_737(entry.getKey());
            if (criterionProgress == null || !force && !criterionProgress.method_784() && !progress.method_740()) continue;
            this.removeListener(entry.getValue(), entry.getKey(), player, goal);
        }
    }

    public class_167 getOrStartProgress(class_3222 player, ActiveGoal goal) {
        Map map = this.advancementProgress.computeIfAbsent(player.method_5667(), k -> HashMap.newHashMap(this.board.getGoals().length));
        class_167 progress = (class_167)map.get(goal);
        if (progress == null) {
            progress = new class_167();
            progress.method_727(goal.requirements());
            map.put(goal, progress);
        }
        return progress;
    }

    @Nullable
    public GoalProgress getGoalProgress(class_3222 player, ActiveGoal goal) {
        Map<ActiveGoal, GoalProgress> progress = this.goalProgress.get(player.method_5667());
        return progress == null ? null : progress.get(goal);
    }

    public void updateProgress(class_3222 player, ActiveGoal goal, int progress, int maxProgress) {
        int goalIndex = this.getBoardIndex(player, goal);
        if (goalIndex == -1) {
            return;
        }
        Map goalProgress = this.goalProgress.computeIfAbsent(player.method_5667(), k -> HashMap.newHashMap(this.board.getGoals().length));
        GoalProgress existingProgress = (GoalProgress)goalProgress.get(goal);
        if (existingProgress != null && existingProgress.progress() == progress && existingProgress.maxProgress() == maxProgress) {
            return;
        }
        new UpdateProgressPayload(goalIndex, progress, maxProgress).sendTo(player);
        goalProgress.put(goal, new GoalProgress(progress, maxProgress));
    }

    public boolean award(class_3222 player, ActiveGoal goal, String criterion) {
        return this.award(player, goal, criterion, 1);
    }

    public boolean award(class_3222 player, ActiveGoal goal, String criterion, int count) {
        if (goal.specialType() == BingoTag.SpecialType.FINISH) {
            BingoBoard.Teams team = this.getTeam(player);
            BingoBoard.Teams[] board = this.board.getStates();
            int index = this.getBoardIndex(player, goal);
            if (index == -1) {
                return false;
            }
            BingoBoard.Teams oldTeams = board[index];
            board[index] = board[index].or(team);
            boolean winner = this.getWinner(false).and(team);
            board[index] = oldTeams;
            if (!winner) {
                return false;
            }
        }
        boolean awarded = false;
        class_167 progress = this.getOrStartProgress(player, goal);
        boolean wasDone = progress.method_740();
        if (progress.method_743(criterion)) {
            this.unregisterListeners(player, goal, false);
            awarded = true;
        }
        if (!wasDone && progress.method_740()) {
            int completedCount = this.goalAchievedCount.computeIfAbsent(player.method_5667(), k -> new Object2IntOpenHashMap()).addTo((Object)goal, count) + count;
            if (completedCount > goal.requiredCount()) {
                completedCount = goal.requiredCount();
            }
            goal.progress().onGoalCompleted(this, player, goal, completedCount);
            if (completedCount == goal.requiredCount()) {
                this.updateTeamBoard(player, goal, false);
            } else {
                for (String completedCriterion : progress.method_734()) {
                    progress.method_729(completedCriterion);
                }
                this.unregisterListeners(player, goal, true);
                this.registerListeners(player, goal);
            }
        }
        goal.progress().criterionChanged(this, player, goal, criterion, true);
        return awarded;
    }

    public boolean award(class_3222 player, ActiveGoal goal) {
        class_167 progress = this.getOrStartProgress(player, goal);
        if (progress.method_740()) {
            return false;
        }
        boolean success = false;
        for (String criterion : progress.method_731()) {
            success |= this.award(player, goal, criterion, goal.requiredCount());
        }
        return success;
    }

    public boolean revoke(class_3222 player, ActiveGoal goal, String criterion) {
        boolean revoked = false;
        class_167 progress = this.getOrStartProgress(player, goal);
        boolean wasDone = progress.method_740();
        if (progress.method_729(criterion)) {
            this.registerListeners(player, goal);
            revoked = true;
        }
        if (wasDone && !progress.method_740()) {
            this.updateTeamBoard(player, goal, true);
        }
        goal.progress().criterionChanged(this, player, goal, criterion, false);
        return revoked;
    }

    public boolean revoke(class_3222 player, ActiveGoal goal) {
        class_167 progress = this.getOrStartProgress(player, goal);
        if (!progress.method_742()) {
            return false;
        }
        boolean success = false;
        for (String criterion : progress.method_734()) {
            success |= this.revoke(player, goal, criterion);
        }
        Object2IntOpenHashMap<ActiveGoal> achievedCount = this.goalAchievedCount.get(player.method_5667());
        if (achievedCount != null) {
            achievedCount.removeInt((Object)goal);
        }
        return success;
    }

    public void flushQueuedGoals(class_3222 player) {
        List<ActiveGoal> goals = this.queuedGoals.remove(player.method_5667());
        if (goals == null) {
            return;
        }
        for (ActiveGoal goal : goals) {
            this.updateTeamBoard(player, goal, false);
        }
    }

    private void updateTeamBoard(class_3222 player, ActiveGoal goal, boolean revoke) {
        boolean isNever;
        BingoBoard.Teams team = this.getTeam(player);
        if (!team.any()) {
            if (!revoke) {
                this.queuedGoals.computeIfAbsent(player.method_5667(), k -> new ArrayList()).add(goal);
            }
            return;
        }
        if (!this.remainingTeams.and(team) && !this.finishedTeams.and(team)) {
            return;
        }
        if (!this.gameMode.canFinishedTeamsGetMoreGoals() && this.finishedTeams.and(team)) {
            return;
        }
        BingoBoard.Teams[] board = this.board.getStates();
        int index = this.getBoardIndex(player, goal);
        if (index == -1) {
            return;
        }
        boolean bl = isNever = goal.specialType() == BingoTag.SpecialType.NEVER;
        if (revoke || this.gameMode.canGetGoal(this.board, index, team, isNever)) {
            boolean isLoss = isNever ^ revoke;
            board[index] = isLoss ? board[index].andNot(team) : board[index].or(team);
            MinecraftServer server = player.method_51469().method_8503();
            this.notifyTeam(player, team, goal, server.method_3760(), index, isLoss);
            if (!isLoss) {
                this.checkForWin(server.method_3760());
            }
        }
    }

    private int getBoardIndex(class_3222 player, ActiveGoal goal) {
        int index = ArrayUtils.indexOf((Object[])this.board.getGoals(), (Object)goal);
        if (index == -1) {
            Bingo.LOGGER.warn("Player {} got a goal ({}) from a previous game! This should not happen.", (Object)player.method_5820(), (Object)goal.id());
        }
        return index;
    }

    private void notifyTeam(class_3222 obtainer, BingoBoard.Teams team, ActiveGoal goal, class_3324 playerList, int boardIndex, boolean isLoss) {
        block6: {
            UpdateStatePayload statePayload;
            block5: {
                boolean announceGoal = this.gameMode.announceGoal(this, team, boardIndex);
                class_268 playerTeam = this.getTeam(team);
                class_5250 goalName = goal.name().method_27661().method_27692(isLoss ? class_124.field_1065 : class_124.field_1060);
                class_5250 message = playerTeam.method_1204().size() == 1 ? Bingo.translatable(isLoss ? "bingo.goal_lost.single" : "bingo.goal_obtained.single", goalName) : Bingo.translatable(isLoss ? "bingo.goal_lost" : "bingo.goal_obtained", obtainer.method_5476(), goalName);
                BingoBoard.Teams boardState = this.board.getStates()[boardIndex];
                boolean showOtherTeam = this.gameMode.getRenderMode() == BingoGameMode.RenderMode.ALL_TEAMS;
                statePayload = new UpdateStatePayload(boardIndex, boardState);
                UpdateStatePayload obfuscatedStatePayload = new UpdateStatePayload(boardIndex, BingoGame.obfuscateTeam(team, boardState));
                class_2779 vanillaPacket = new class_2779(false, List.of(), Set.of(), Map.of(BingoBoard.generateVanillaId(boardIndex), VanillaNetworking.generateProgress(boardState.and(team))), false);
                for (String member : playerTeam.method_1204()) {
                    class_3222 player = playerList.method_14566(member);
                    if (player == null) continue;
                    if (!showOtherTeam && !player.method_7325()) {
                        obfuscatedStatePayload.sendTo(player);
                    }
                    player.field_13987.method_14364((class_2596)vanillaPacket);
                    if (!announceGoal) continue;
                    player.method_17356(isLoss ? (class_3414)class_3417.field_23117.comp_349() : (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15250, isLoss ? 1.0f : 0.5f, 1.0f);
                    player.method_64398((class_2561)message);
                }
                if (!showOtherTeam) break block5;
                statePayload.sendTo(playerList.method_14571());
                if (!this.gameMode.isLockout()) break block6;
                class_2561 teamComponent = (class_2561)BingoUtil.getDisplayName(playerTeam, playerList).map(Function.identity(), Function.identity());
                if (playerTeam.method_1202() != class_124.field_1070) {
                    teamComponent = teamComponent.method_27661().method_27692(playerTeam.method_1202());
                }
                class_5250 lockoutMessage = Bingo.translatable("bingo.goal_lost.lockout", teamComponent, goal.name().method_27661().method_27692(class_124.field_1065));
                for (class_3222 player : playerList.method_14571()) {
                    if (player.method_5645((class_270)playerTeam) || !announceGoal) continue;
                    player.method_17356((class_3414)class_3417.field_23117.comp_349(), class_3419.field_15250, 0.5f, 1.0f);
                    player.method_64398((class_2561)lockoutMessage);
                }
                break block6;
            }
            for (class_3222 player : playerList.method_14571()) {
                if (!player.method_7325()) continue;
                statePayload.sendTo(player);
            }
        }
    }

    @NotNull
    public BingoBoard.Teams getTeam(class_3222 player) {
        for (int i = 0; i < this.teams.length; ++i) {
            if (!player.method_5645((class_270)this.teams[i])) continue;
            return BingoBoard.Teams.fromOne(i);
        }
        return BingoBoard.Teams.NONE;
    }

    public class_268 getTeam(BingoBoard.Teams team) {
        if (!team.one()) {
            throw new IllegalArgumentException("BingoGame.getTeam() called with multiple teams!");
        }
        int index = team.getFirstIndex();
        if (index >= this.teams.length) {
            throw new IllegalArgumentException("BingoGame.getTeam() called with a team it doesn't have");
        }
        return this.teams[index];
    }

    public class_268[] getTeams() {
        return this.teams;
    }

    public BingoBoard.Teams getNerfedTeams() {
        return this.nerfedTeams;
    }

    public void nerfPlayer(class_3222 player) {
        BingoBoard.Teams team = this.getTeam(player);
        this.nerfedTeams = this.nerfedTeams.or(team);
    }

    public void checkForWin(class_3324 playerList) {
        BingoBoard.Teams finishers = this.getWinner(false);
        BingoBoard.Teams newFinishers = finishers.andNot(this.finishedTeams);
        if (!newFinishers.any()) {
            return;
        }
        int place = this.finishedTeams.count() + 1;
        this.finishedTeams = this.finishedTeams.or(finishers);
        if (place == 1) {
            this.winningTeams = newFinishers;
        }
        this.remainingTeams = this.remainingTeams.andNot(newFinishers);
        if (this.continueAfterWin) {
            this.notifyFinishedTeam(playerList, newFinishers, place);
        }
        if (!this.continueAfterWin || this.remainingTeams.count() < 2) {
            this.endGame(playerList);
        }
    }

    private void notifyFinishedTeam(class_3324 playerList, BingoBoard.Teams newFinishers, int place) {
        class_2561 message;
        if (newFinishers.one()) {
            class_268 playerTeam = this.getTeam(newFinishers);
            message = (class_2561)BingoUtil.mapEither(BingoUtil.getDisplayName(playerTeam, playerList), name -> {
                if (playerTeam.method_1202() != class_124.field_1070) {
                    return name.method_27661().method_27692(playerTeam.method_1202());
                }
                return name;
            }).map(playerName -> Bingo.translatable("bingo.finished.single", playerName, BingoUtil.ordinal(place)), teamName -> Bingo.translatable("bingo.finished", teamName, BingoUtil.ordinal(place)));
        } else {
            class_5250 teamList = class_2564.method_10885((class_2561)class_2564.method_10884(newFinishers.stream().mapToObj(teamIndex -> {
                class_268 team = this.getTeam(BingoBoard.Teams.fromOne(teamIndex));
                class_2561 name = (class_2561)Either.unwrap(BingoUtil.getDisplayName(team, playerList));
                if (team.method_1202() != class_124.field_1070) {
                    return name.method_27661().method_27692(team.method_1202());
                }
                return name;
            }).toList(), Function.identity()));
            message = Bingo.translatable("bingo.finished.tie", teamList, BingoUtil.ordinal(place));
        }
        if (this.remainingTeams.count() > 1) {
            for (class_3222 player : playerList.method_14571()) {
                player.method_17356(class_3417.field_15195, class_3419.field_15250, 1.0f, 1.0f);
            }
        }
        playerList.method_43514(message, false);
    }

    public BingoBoard.Teams getWinner(boolean tryHarder) {
        return this.gameMode.getWinners(this.board, this.teams.length, this.nerfedTeams, tryHarder);
    }

    public PersistenceData createPersistenceData() {
        return PersistenceData.create(this);
    }

    private record BingoGameProgressListener<T extends class_184>(BingoGame game, ActiveGoal goal, class_3222 player, String criterionId, T triggerInstance) implements ProgressibleTrigger.ProgressListener<T>
    {
        @Override
        public void update(T triggerInstance, int progress, int maxProgress) {
            if (triggerInstance == this.triggerInstance) {
                this.goal.progress().goalProgressChanged(this.game, this.player, this.goal, this.criterionId, progress, maxProgress);
            }
        }
    }

    public record PersistenceData(BingoBoard board, BingoGameMode gameMode, boolean requireClient, boolean continueAfterWin, int autoForfeitTicks, List<String> teamNames, Map<UUID, Int2ObjectMap<class_167>> advancementProgress, Map<UUID, Int2ObjectMap<GoalProgress>> goalProgress, Map<UUID, Int2IntMap> goalAchievedCount, Map<UUID, IntList> queuedGoals, Map<UUID, Object2IntMap<class_3445<?>>> baseStats, Optional<BingoBoard.Teams> playingTeams, BingoBoard.Teams winningTeams, BingoBoard.Teams finishedTeams, BingoBoard.Teams nerfedTeams) {
        private static final Codec<Map<UUID, Int2ObjectMap<class_167>>> ADVANCEMENT_PROGRESS_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, BingoCodecs.int2ObjectMap(class_167.field_46080));
        private static final Codec<Map<UUID, Int2ObjectMap<GoalProgress>>> GOAL_PROGRESS_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, BingoCodecs.int2ObjectMap(GoalProgress.PERSISTENCE_CODEC));
        private static final Codec<Map<UUID, Int2IntMap>> GOAL_ACHIEVED_COUNT_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, BingoCodecs.INT_2_INT_MAP);
        private static final Codec<Map<UUID, IntList>> QUEUED_GOALS_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, BingoCodecs.INT_LIST);
        private static final Codec<Map<UUID, Object2IntMap<class_3445<?>>>> BASE_STATS_CODEC = Codec.unboundedMap((Codec)class_4844.field_41525, BingoCodecs.object2IntMap(StatCodecs.STRING_CODEC));
        public static final Codec<PersistenceData> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)BingoBoard.PERSISTENCE_CODEC.fieldOf("board").forGetter(PersistenceData::board), (App)BingoGameMode.PERSISTENCE_CODEC.fieldOf("game_mode").forGetter(PersistenceData::gameMode), (App)Codec.BOOL.fieldOf("require_client").forGetter(PersistenceData::requireClient), (App)Codec.BOOL.optionalFieldOf("continue_after_win", (Object)false).forGetter(PersistenceData::continueAfterWin), (App)class_5699.field_33441.optionalFieldOf("auto_forfeit_ticks", (Object)2400).forGetter(PersistenceData::autoForfeitTicks), (App)Codec.STRING.listOf().fieldOf("team_names").forGetter(PersistenceData::teamNames), (App)ADVANCEMENT_PROGRESS_CODEC.fieldOf("advancement_progress").forGetter(PersistenceData::advancementProgress), (App)GOAL_PROGRESS_CODEC.fieldOf("goal_progress").forGetter(PersistenceData::goalProgress), (App)GOAL_ACHIEVED_COUNT_CODEC.fieldOf("goal_achieved_count").forGetter(PersistenceData::goalAchievedCount), (App)QUEUED_GOALS_CODEC.fieldOf("queued_goals").forGetter(PersistenceData::queuedGoals), (App)BASE_STATS_CODEC.fieldOf("base_stats").forGetter(PersistenceData::baseStats), (App)BingoBoard.Teams.CODEC.optionalFieldOf("playing_teams").forGetter(PersistenceData::playingTeams), (App)BingoBoard.Teams.CODEC.optionalFieldOf("winning_teams", (Object)BingoBoard.Teams.NONE).forGetter(PersistenceData::winningTeams), (App)BingoBoard.Teams.CODEC.optionalFieldOf("finished_teams", (Object)BingoBoard.Teams.NONE).forGetter(PersistenceData::finishedTeams), (App)BingoBoard.Teams.CODEC.optionalFieldOf("nerfed_teams", (Object)BingoBoard.Teams.NONE).forGetter(PersistenceData::nerfedTeams)).apply((Applicative)instance, PersistenceData::new));

        public BingoGame createGame(class_269 scoreboard) throws IllegalStateException {
            Object subTarget;
            class_268[] teams = new class_268[this.teamNames.size()];
            for (int i = 0; i < teams.length; ++i) {
                teams[i] = scoreboard.method_1153(this.teamNames.get(i));
                if (teams[i] != null) continue;
                throw new IllegalStateException("Team '" + this.teamNames.get(i) + "' no longer exists");
            }
            BingoGame game = new BingoGame(this.board, this.gameMode, this.requireClient, this.continueAfterWin, this.autoForfeitTicks, teams);
            for (Map.Entry<UUID, Int2ObjectMap<class_167>> entry : this.advancementProgress.entrySet()) {
                subTarget = HashMap.newHashMap(entry.getValue().size());
                for (Int2ObjectMap.Entry subEntry : entry.getValue().int2ObjectEntrySet()) {
                    ActiveGoal goal = this.getGoal(subEntry.getIntKey());
                    class_167 progress = (class_167)subEntry.getValue();
                    progress.method_727(goal.requirements());
                    subTarget.put(goal, progress);
                }
                game.advancementProgress.put(entry.getKey(), (Map<ActiveGoal, class_167>)subTarget);
            }
            for (Map.Entry<UUID, Object> entry : this.goalProgress.entrySet()) {
                subTarget = HashMap.newHashMap(((Int2ObjectMap)entry.getValue()).size());
                for (Int2ObjectMap.Entry subEntry : ((Int2ObjectMap)entry.getValue()).int2ObjectEntrySet()) {
                    subTarget.put(this.getGoal(subEntry.getIntKey()), (GoalProgress)subEntry.getValue());
                }
                game.goalProgress.put(entry.getKey(), (Map<ActiveGoal, GoalProgress>)subTarget);
            }
            for (Map.Entry<UUID, Object> entry : this.goalAchievedCount.entrySet()) {
                subTarget = new Object2IntOpenHashMap(((Int2IntMap)entry.getValue()).size());
                for (Int2ObjectMap.Entry subEntry : ((Int2IntMap)entry.getValue()).int2IntEntrySet()) {
                    subTarget.put((Object)this.getGoal(subEntry.getIntKey()), subEntry.getIntValue());
                }
                game.goalAchievedCount.put(entry.getKey(), (Object2IntOpenHashMap<ActiveGoal>)subTarget);
            }
            for (Map.Entry<UUID, Object> entry : this.queuedGoals.entrySet()) {
                subTarget = new ArrayList(((IntList)entry.getValue()).size());
                ObjectIterator objectIterator = ((IntList)entry.getValue()).iterator();
                while (objectIterator.hasNext()) {
                    int goal = (Integer)objectIterator.next();
                    subTarget.add(this.getGoal(goal));
                }
                game.queuedGoals.put(entry.getKey(), (List<ActiveGoal>)subTarget);
            }
            game.baseStats.putAll(this.baseStats);
            game.remainingTeams = this.playingTeams.orElseGet(() -> BingoBoard.Teams.fromAll(teams.length));
            game.winningTeams = this.winningTeams;
            game.finishedTeams = this.finishedTeams;
            return game;
        }

        private ActiveGoal getGoal(int goal) {
            return this.board.getGoals()[goal];
        }

        private static PersistenceData create(BingoGame game) {
            HashMap<UUID, Int2IntMap> goalAchievedCount = HashMap.newHashMap(game.goalAchievedCount.size());
            for (Map.Entry<UUID, Object2IntOpenHashMap<ActiveGoal>> entry : game.goalAchievedCount.entrySet()) {
                Int2IntOpenHashMap subTarget = new Int2IntOpenHashMap(entry.getValue().size());
                for (Object2IntMap.Entry subEntry : entry.getValue().object2IntEntrySet()) {
                    subTarget.put(PersistenceData.getGoal(game, (ActiveGoal)subEntry.getKey()), subEntry.getIntValue());
                }
                goalAchievedCount.put(entry.getKey(), (Int2IntMap)subTarget);
            }
            HashMap<UUID, IntList> queuedGoals = HashMap.newHashMap(game.queuedGoals.size());
            for (Map.Entry<UUID, List<ActiveGoal>> entry : game.queuedGoals.entrySet()) {
                IntArrayList subTarget = new IntArrayList(entry.getValue().size());
                for (ActiveGoal value : entry.getValue()) {
                    subTarget.add(PersistenceData.getGoal(game, value));
                }
                queuedGoals.put(entry.getKey(), (IntList)subTarget);
            }
            return new PersistenceData(game.board, game.gameMode, game.requireClient, game.continueAfterWin, game.autoForfeitTicks, Arrays.stream(game.teams).map(class_268::method_1197).toList(), PersistenceData.createMap(game, game.advancementProgress), PersistenceData.createMap(game, game.goalProgress), goalAchievedCount, queuedGoals, game.baseStats, Optional.of(game.remainingTeams), game.winningTeams, game.finishedTeams, game.nerfedTeams);
        }

        private static <V> Map<UUID, Int2ObjectMap<V>> createMap(BingoGame game, Map<UUID, Map<ActiveGoal, V>> source) {
            HashMap<UUID, Int2ObjectMap<Int2ObjectOpenHashMap>> target = HashMap.newHashMap(source.size());
            for (Map.Entry<UUID, Map<ActiveGoal, V>> entry : source.entrySet()) {
                Int2ObjectOpenHashMap subTarget = new Int2ObjectOpenHashMap(entry.getValue().size());
                for (Map.Entry<ActiveGoal, V> subEntry : entry.getValue().entrySet()) {
                    subTarget.put(PersistenceData.getGoal(game, subEntry.getKey()), subEntry.getValue());
                }
                target.put(entry.getKey(), (Int2ObjectMap<Int2ObjectOpenHashMap>)subTarget);
            }
            return target;
        }

        private static int getGoal(BingoGame game, ActiveGoal goal) {
            return game.board.getIndex(goal);
        }
    }
}

