/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game.mode;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import net.minecraft.class_124;
import net.minecraft.class_268;
import org.jetbrains.annotations.NotNull;

public class LockoutGameMode
implements BingoGameMode {
    private static final SimpleCommandExceptionType TOO_FEW_TEAMS = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.lockout.too_few_teams", new Object[0]));
    private static final SimpleCommandExceptionType TEAM_MISSING_COLOR = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.team_missing_color", new Object[0]));
    private static final SimpleCommandExceptionType DUPLICATE_TEAM_COLOR = new SimpleCommandExceptionType((Message)Bingo.translatable("bingo.duplicate_team_color", new Object[0]));

    @Override
    public CommandSyntaxException checkAllowedConfig(BingoGameMode.GameConfig config) {
        if (config.teams().size() < 2) {
            return TOO_FEW_TEAMS.create();
        }
        EnumSet<class_124> uniqueColors = EnumSet.noneOf(class_124.class);
        for (class_268 team : config.teams()) {
            if (team.method_1202().method_532() == null) {
                return TEAM_MISSING_COLOR.create();
            }
            uniqueColors.add(team.method_1202());
        }
        if (uniqueColors.size() < config.teams().size()) {
            return DUPLICATE_TEAM_COLOR.create();
        }
        return null;
    }

    @Override
    @NotNull
    public BingoBoard.Teams getWinners(BingoBoard board, int teamCount, BingoBoard.Teams nerfedTeams, boolean tryHarder) {
        class TeamValue {
            final BingoBoard.Teams team;
            int goalsHeld;

            TeamValue(LockoutGameMode this$0, BingoBoard.Teams team) {
                this.team = team;
            }
        }
        TeamValue[] teams = new TeamValue[teamCount];
        for (int i = 0; i < teamCount; ++i) {
            teams[i] = new TeamValue(this, BingoBoard.Teams.fromOne(i));
        }
        int totalHeld = 0;
        for (BingoBoard.Teams state : board.getStates()) {
            if (!state.any()) continue;
            ++totalHeld;
            ++teams[state.getFirstIndex()].goalsHeld;
        }
        Arrays.sort(teams, Comparator.comparing(v -> -v.goalsHeld));
        int totalGoals = board.getShape().getGoalCount(board.getSize());
        if (totalGoals - totalHeld < teams[0].goalsHeld - teams[1].goalsHeld) {
            return teams[0].team;
        }
        if (totalHeld == totalGoals || tryHarder) {
            if (totalHeld == 0) {
                return BingoBoard.Teams.NONE;
            }
            BingoBoard.Teams tied = BingoBoard.Teams.NONE;
            int held = teams[0].goalsHeld;
            for (TeamValue team : teams) {
                if (team.goalsHeld != held) break;
                tied = tied.or(team.team);
            }
            return tied;
        }
        return BingoBoard.Teams.NONE;
    }

    @Override
    public boolean canGetGoal(BingoBoard board, int index, BingoBoard.Teams team, boolean isNever) {
        return !board.getStates()[index].any();
    }

    @Override
    public boolean isGoalAllowed(GoalHolder goal) {
        return goal.goal().getTags().method_40239().allMatch(g -> ((BingoTag)g.comp_349()).specialType() == BingoTag.SpecialType.NONE);
    }

    @Override
    public boolean announceGoal(BingoGame game, BingoBoard.Teams team, int goalIndex) {
        return true;
    }

    @Override
    public BingoGameMode.RenderMode getRenderMode() {
        return BingoGameMode.RenderMode.ALL_TEAMS;
    }

    @Override
    public boolean isLockout() {
        return true;
    }

    @Override
    public boolean canFinishedTeamsGetMoreGoals() {
        return false;
    }
}

