/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game.mode;

import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import org.jetbrains.annotations.NotNull;

public class StandardGameMode
implements BingoGameMode {
    @Override
    @NotNull
    public BingoBoard.Teams getWinners(BingoBoard board, int teamCount, BingoBoard.Teams nerfedTeams, boolean tryHarder) {
        BingoBoard.Teams result = BingoBoard.Teams.NONE;
        for (int i = 0; i < teamCount; ++i) {
            BingoBoard.Teams team = BingoBoard.Teams.fromOne(i);
            if (!this.didWin(board, team, nerfedTeams.and(team))) continue;
            result = result.or(team);
        }
        return result;
    }

    private boolean didWin(BingoBoard board, BingoBoard.Teams team, boolean isNerfed) {
        for (int[] line : board.getShape().getLines(board.getSize())) {
            boolean hasLine = true;
            for (int goalIndex : line) {
                if (BingoGameMode.hasGoal(board, goalIndex, team, isNerfed)) continue;
                hasLine = false;
                break;
            }
            if (!hasLine) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canGetGoal(BingoBoard board, int index, BingoBoard.Teams team, boolean isNever) {
        return !board.getStates()[index].and(team) ^ isNever;
    }
}

