/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game.persistence;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import io.github.gaming32.bingo.game.persistence.fixes.FlattenGoalFix;
import io.github.gaming32.bingo.game.persistence.fixes.NamespaceGameModeFix;
import io.github.gaming32.bingo.game.persistence.fixes.TagRenameFix;
import io.github.gaming32.bingo.game.persistence.schemas.BingoV1;
import io.github.gaming32.bingo.game.persistence.schemas.BingoV2;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;

public class PersistenceDataFixers {
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static final DataFixerBuilder.Result DATA_FIXER = PersistenceDataFixers.createFixerUpper();

    public static DataFixer getDataFixer() {
        return DATA_FIXER.fixer();
    }

    private static DataFixerBuilder.Result createFixerUpper() {
        DataFixerBuilder builder = new DataFixerBuilder(4);
        PersistenceDataFixers.addFixers(builder);
        return builder.build();
    }

    public static CompletableFuture<?> optimize(Set<DSL.TypeReference> types) {
        if (types.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor(Thread.ofPlatform().name("Bingo Datafixer Bootstrap").daemon().priority(1).factory());
        return DATA_FIXER.optimize(types, (Executor)executor);
    }

    private static void addFixers(DataFixerBuilder builder) {
        builder.addSchema(1, BingoV1::new);
        Schema v2 = builder.addSchema(2, BingoV2::new);
        builder.addFixer((DataFix)new FlattenGoalFix(v2));
        Schema v3 = builder.addSchema(3, SAME);
        builder.addFixer((DataFix)new NamespaceGameModeFix(v3));
        Schema v4 = builder.addSchema(4, SAME);
        builder.addFixer((DataFix)TagRenameFix.items(v4, Map.of("bingo:concrete", "c:concretes", "bingo:glazed_terracotta", "c:glazed_terracottas", "bingo:slabs", "minecraft:slabs", "bingo:stairs", "minecraft:stairs")));
    }
}

