/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.mixin.common;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.ext.ServerPlayerExt;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.mixin.common.MixinEntity;
import io.github.gaming32.bingo.network.messages.s2c.ResyncStatesPayload;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class MixinServerPlayer
extends MixinEntity
implements ServerPlayerExt {
    @Shadow
    @Final
    public class_3225 field_13974;
    @Shadow
    @Final
    private MinecraftServer field_13995;
    @Unique
    private boolean bingo$advancementsNeedClearing;

    @Inject(method={"doTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/game/ClientboundSetExperiencePacket;<init>(FII)V")})
    private void experienceChanged(CallbackInfo ci) {
        BingoTriggers.EXPERIENCE_CHANGED.get().trigger((class_3222)this);
    }

    @Inject(method={"onItemPickup"}, at={@At(value="TAIL")})
    private void itemPickedUpTrigger(class_1542 itemEntity, CallbackInfo ci) {
        BingoTriggers.ITEM_PICKED_UP.get().trigger((class_3222)this, itemEntity);
    }

    @Inject(method={"awardKillScore"}, at={@At(value="HEAD")})
    private void killSelfTrigger(class_1297 killed, class_1282 source, CallbackInfo ci) {
        if (killed == this) {
            BingoTriggers.KILL_SELF.get().trigger((class_3222)killed, source);
        }
    }

    @Inject(method={"die"}, at={@At(value="RETURN")})
    private void deathTrigger(class_1282 damageSource, CallbackInfo ci) {
        BingoTriggers.DEATH.get().trigger((class_3222)this, damageSource);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="FIELD", target="Lnet/minecraft/stats/Stats;CROUCH_ONE_CM:Lnet/minecraft/resources/ResourceLocation;")})
    private void sneakingTrigger(double distanceX, double distanceY, double distanceZ, CallbackInfo ci) {
        MixinServerPlayer mixinServerPlayer = this;
        if (mixinServerPlayer instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)mixinServerPlayer;
            if (this.bingo$startSneakingPos == null) {
                Bingo.LOGGER.warn("bingo$startSneakingPos was null but player was sneaking");
            } else {
                BingoTriggers.CROUCH.get().method_9080(serverPlayer, this.bingo$startSneakingPos);
            }
        }
    }

    @WrapMethod(method={"setGameMode"})
    private boolean onSetGameMode(class_1934 newMode, Operation<Boolean> original) {
        class_1934 oldMode = this.field_13974.method_14257();
        if (!((Boolean)original.call(new Object[]{newMode})).booleanValue()) {
            return false;
        }
        BingoGame game = ((MinecraftServerExt)this.field_13995).bingo$getGame();
        if (game != null && (newMode == class_1934.field_9219 || oldMode == class_1934.field_9219)) {
            class_3222 player = (class_3222)this;
            BingoBoard.Teams team = game.getTeam(player);
            new ResyncStatesPayload(game.obfuscateTeam(team, (class_1657)player)).sendTo(player);
        }
        return true;
    }

    @Override
    public void bingo$markAdvancementsNeedClearing() {
        this.bingo$advancementsNeedClearing = true;
    }

    @Override
    public boolean bingo$clearAdvancementsNeedClearing() {
        boolean result = this.bingo$advancementsNeedClearing;
        this.bingo$advancementsNeedClearing = false;
        return result;
    }

    @Override
    public void bingo$copyAdvancementsNeedClearingTo(class_3222 toPlayer) {
        ((MixinServerPlayer)((ServerPlayerExt)toPlayer)).bingo$advancementsNeedClearing = this.bingo$advancementsNeedClearing;
    }
}

