/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.mixin.common;

import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.network.VanillaNetworking;
import io.github.gaming32.bingo.network.messages.s2c.ResyncStatesPayload;
import io.github.gaming32.bingo.network.messages.s2c.SyncTeamPayload;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_268;
import net.minecraft.class_2779;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2995.class})
public class MixinServerScoreboard {
    @Shadow
    @Final
    private MinecraftServer field_13428;

    @Inject(method={"addPlayerToTeam"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V", shift=At.Shift.AFTER)})
    private void syncTeamAdd(String playerName, class_268 team, CallbackInfoReturnable<Boolean> cir) {
        this.bingo$syncTeam(playerName);
    }

    @Inject(method={"removePlayerFromTeam"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;broadcastAll(Lnet/minecraft/network/protocol/Packet;)V", shift=At.Shift.AFTER)})
    private void syncTeamRemove(String username, class_268 playerTeam, CallbackInfo ci) {
        this.bingo$syncTeam(username);
    }

    @Unique
    private void bingo$syncTeam(String playerName) {
        BingoGame game = ((MinecraftServerExt)this.field_13428).bingo$getGame();
        if (game == null) {
            return;
        }
        class_3222 player = this.field_13428.method_3760().method_14566(playerName);
        if (player != null) {
            BingoBoard.Teams team = game.getTeam(player);
            new SyncTeamPayload(team).sendTo(player);
            if (team.any()) {
                game.flushQueuedGoals(player);
            }
            new ResyncStatesPayload(game.obfuscateTeam(team, (class_1657)player)).sendTo(player);
            player.field_13987.method_14364((class_2596)new class_2779(false, List.of(), Set.of(), VanillaNetworking.generateProgressMap(game.getBoard().getStates(), team), false));
        }
    }
}

