/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.subpredicates.PaintingPredicate;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.BingoUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2096;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_6880;
import net.minecraft.class_7376;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class AdjacentPaintingTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1534 painting) {
        this.method_22510(player, instance -> instance.matches(player, painting));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> placedPainting;
        private final Optional<class_5258> adjacentPaintings;
        private final class_2096.class_2100 count;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("placed_painting").forGetter(TriggerInstance::placedPainting), (App)class_2048.field_47250.optionalFieldOf("adjacent_paintings").forGetter(TriggerInstance::adjacentPaintings), (App)class_2096.class_2100.field_45763.optionalFieldOf("count", (Object)class_2096.class_2100.field_9708).forGetter(TriggerInstance::count)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> placedPainting, Optional<class_5258> adjacentPaintings, class_2096.class_2100 count) {
            this.player = player;
            this.placedPainting = placedPainting;
            this.adjacentPaintings = adjacentPaintings;
            this.count = count;
        }

        public boolean matches(class_3222 player, class_1534 painting) {
            if (this.placedPainting.isPresent() && !this.placedPainting.get().method_27806(class_2048.method_27802((class_3222)player, (class_1297)painting))) {
                return false;
            }
            ObjectOpenCustomHashSet seenVariants = new ObjectOpenCustomHashSet(BingoUtil.holderStrategy());
            int count = this.countAdjacentPaintings(player, painting, (ObjectSet<class_6880<class_1535>>)seenVariants);
            return this.count.method_9054(count);
        }

        private int countAdjacentPaintings(class_3222 player, class_1534 painting, ObjectSet<class_6880<class_1535>> seenVariants) {
            if (!seenVariants.add((Object)painting.method_43404())) {
                return 0;
            }
            int count = 1;
            for (class_1534 otherPainting : painting.method_73183().method_18467(class_1534.class, painting.method_5829().method_1014(0.25))) {
                if (otherPainting == painting || !this.adjacentPaintings.isEmpty() && !this.adjacentPaintings.get().method_27806(class_2048.method_27802((class_3222)player, (class_1297)otherPainting))) continue;
                count += this.countAdjacentPaintings(player, otherPainting, seenVariants);
            }
            return count;
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.placedPainting, ".placed_painting");
            criterionValidator.method_54966(this.adjacentPaintings, ".adjacent_paintings");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;placedPainting;adjacentPaintings;count", "player", "placedPainting", "adjacentPaintings", "count"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;placedPainting;adjacentPaintings;count", "player", "placedPainting", "adjacentPaintings", "count"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;placedPainting;adjacentPaintings;count", "player", "placedPainting", "adjacentPaintings", "count"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> placedPainting() {
            return this.placedPainting;
        }

        public Optional<class_5258> adjacentPaintings() {
            return this.adjacentPaintings;
        }

        public class_2096.class_2100 count() {
            return this.count;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> placedPainting = Optional.empty();
        private Optional<class_5258> adjacentPaintings = Optional.empty();
        private class_2096.class_2100 count = class_2096.class_2100.field_9708;

        private Builder() {
        }

        public Builder player(class_2048 player) {
            return this.player(class_2048.method_51704((class_2048)player));
        }

        public Builder player(class_5258 player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder placedPainting(class_5258 placedPainting) {
            this.placedPainting = Optional.of(placedPainting);
            return this;
        }

        public Builder placedPainting(class_2048 placedPainting) {
            return this.placedPainting(class_2048.method_51704((class_2048)placedPainting));
        }

        public Builder placedPainting(PaintingPredicate placedPainting) {
            return this.placedPainting(class_2048.class_2049.method_8916().method_43094((class_7376)placedPainting).method_8920());
        }

        public Builder adjacentPaintings(class_5258 adjacentPaintings) {
            this.adjacentPaintings = Optional.of(adjacentPaintings);
            return this;
        }

        public Builder adjacentPaintings(class_2048 adjacentPaintings) {
            return this.adjacentPaintings(class_2048.method_51704((class_2048)adjacentPaintings));
        }

        public Builder adjacentPaintings(PaintingPredicate adjacentPaintings) {
            return this.adjacentPaintings(class_2048.class_2049.method_8916().method_43094((class_7376)adjacentPaintings).method_8920());
        }

        public Builder count(class_2096.class_2100 count) {
            this.count = count;
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.ADJACENT_PAINTING.get().method_53699((class_184)new TriggerInstance(this.player, this.placedPainting, this.adjacentPaintings, this.count));
        }
    }
}

