/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class DoorOpenedByTargetTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1676 projectile, class_2338 targetBlock, int targetBlockPower, class_2338 poweredBlock) {
        class_47 projectileContext = class_2048.method_27802((class_3222)player, (class_1297)projectile);
        this.method_22510(player, instance -> instance.matches(projectileContext, targetBlock, targetBlockPower, poweredBlock));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> projectile;
        private final Optional<class_2090> targetBlock;
        private final class_2096.class_2100 targetBlockPower;
        private final Optional<class_2090> door;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("projectile").forGetter(TriggerInstance::projectile), (App)class_2090.field_45760.optionalFieldOf("target_block").forGetter(TriggerInstance::targetBlock), (App)class_2096.class_2100.field_45763.optionalFieldOf("target_block_power", (Object)class_2096.class_2100.field_9708).forGetter(TriggerInstance::targetBlockPower), (App)class_2090.field_45760.optionalFieldOf("door").forGetter(TriggerInstance::door)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> projectile, Optional<class_2090> targetBlock, class_2096.class_2100 targetBlockPower, Optional<class_2090> door) {
            this.player = player;
            this.projectile = projectile;
            this.targetBlock = targetBlock;
            this.targetBlockPower = targetBlockPower;
            this.door = door;
        }

        public boolean matches(class_47 projectile, class_2338 targetBlock, int targetBlockPower, class_2338 door) {
            if (this.projectile.isPresent() && !this.projectile.get().method_27806(projectile)) {
                return false;
            }
            if (this.targetBlock.isPresent() && !this.targetBlock.get().method_9018(projectile.method_299(), (double)targetBlock.method_10263(), (double)targetBlock.method_10264(), (double)targetBlock.method_10260())) {
                return false;
            }
            if (!this.targetBlockPower.method_9054(targetBlockPower)) {
                return false;
            }
            return !this.door.isPresent() || this.door.get().method_9018(projectile.method_299(), (double)door.method_10263(), (double)door.method_10264(), (double)door.method_10260());
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.projectile, ".projectile");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;projectile;targetBlock;targetBlockPower;door", "player", "projectile", "targetBlock", "targetBlockPower", "door"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;projectile;targetBlock;targetBlockPower;door", "player", "projectile", "targetBlock", "targetBlockPower", "door"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;projectile;targetBlock;targetBlockPower;door", "player", "projectile", "targetBlock", "targetBlockPower", "door"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> projectile() {
            return this.projectile;
        }

        public Optional<class_2090> targetBlock() {
            return this.targetBlock;
        }

        public class_2096.class_2100 targetBlockPower() {
            return this.targetBlockPower;
        }

        public Optional<class_2090> door() {
            return this.door;
        }
    }

    public static class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> projectile = Optional.empty();
        private Optional<class_2090> targetBlock = Optional.empty();
        private class_2096.class_2100 targetBlockPower = class_2096.class_2100.field_9708;
        private Optional<class_2090> door = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder projectile(class_5258 projectile) {
            this.projectile = Optional.of(projectile);
            return this;
        }

        public Builder projectile(class_2048.class_2049 projectile) {
            return this.projectile(class_2048.method_53134((class_2048.class_2049)projectile));
        }

        public Builder targetBlock(class_2090 targetBlock) {
            this.targetBlock = Optional.of(targetBlock);
            return this;
        }

        public Builder targetBlockPower(class_2096.class_2100 targetBlockPower) {
            this.targetBlockPower = targetBlockPower;
            return this;
        }

        public Builder door(class_2090 door) {
            this.door = Optional.of(door);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.DOOR_OPENED_BY_TARGET.get().method_53699((class_184)new TriggerInstance(this.player, this.projectile, this.targetBlock, this.targetBlockPower, this.door));
        }
    }
}

