/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2019;
import net.minecraft.class_2025;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class EntityDieNearPlayerTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void trigger(class_1309 entity, class_1282 source, float damageDealt, float damageTaken, boolean blocked) {
        List players = entity.method_73183().method_18467(class_1657.class, entity.method_5829().method_1014(32.0));
        for (class_1657 player : players) {
            if (!(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            this.method_22510(serverPlayer, triggerInstance -> triggerInstance.matches(serverPlayer, entity, source, damageDealt, damageTaken, blocked));
        }
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> entity;
        private final Optional<class_2019> killingBlow;
        private final Optional<class_2025> distance;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("entity").forGetter(TriggerInstance::entity), (App)class_2019.field_47238.optionalFieldOf("killing_blow").forGetter(TriggerInstance::killingBlow), (App)class_2025.field_45728.optionalFieldOf("distance").forGetter(TriggerInstance::distance)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> entity, Optional<class_2019> killingBlow, Optional<class_2025> distance) {
            this.player = player;
            this.entity = entity;
            this.killingBlow = killingBlow;
            this.distance = distance;
        }

        public boolean matches(class_3222 player, class_1309 entity, class_1282 source, float damageDealt, float damageTaken, boolean blocked) {
            if (this.entity.isPresent() && !this.entity.get().method_27806(class_2048.method_27802((class_3222)player, (class_1297)entity))) {
                return false;
            }
            if (this.killingBlow.isPresent() && !this.killingBlow.get().method_8838(player, source, damageDealt, damageTaken, blocked)) {
                return false;
            }
            return !this.distance.isPresent() || this.distance.get().method_8859(player.method_23317(), player.method_23318(), player.method_23321(), entity.method_23317(), entity.method_23318(), entity.method_23321());
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.entity, ".entity");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;entity;killingBlow;distance", "player", "entity", "killingBlow", "distance"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;entity;killingBlow;distance", "player", "entity", "killingBlow", "distance"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;entity;killingBlow;distance", "player", "entity", "killingBlow", "distance"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> entity() {
            return this.entity;
        }

        public Optional<class_2019> killingBlow() {
            return this.killingBlow;
        }

        public Optional<class_2025> distance() {
            return this.distance;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> entity = Optional.empty();
        private Optional<class_2019> killingBlow = Optional.empty();
        private Optional<class_2025> distance = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder entity(class_5258 entity) {
            this.entity = Optional.ofNullable(entity);
            return this;
        }

        public Builder entity(class_2048 entity) {
            return this.entity(class_2048.method_51704((class_2048)entity));
        }

        public Builder killingBlow(class_2019 killingBlow) {
            this.killingBlow = Optional.ofNullable(killingBlow);
            return this;
        }

        public Builder distance(class_2025 distance) {
            this.distance = Optional.ofNullable(distance);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.ENTITY_DIE_NEAR_PLAYER.get().method_53699((class_184)new TriggerInstance(this.player, this.entity, this.killingBlow, this.distance));
        }
    }
}

