/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.BingoCodecs;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1304;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import org.jetbrains.annotations.NotNull;

public class EquipItemTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1799 oldItem, class_1799 newItem, class_1304 slot) {
        this.method_22510(player, instance -> instance.matches(oldItem, newItem, slot));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_2073> oldItem;
        private final Optional<class_2073> newItem;
        private final Set<class_1304> slots;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2073.field_45754.optionalFieldOf("old_item").forGetter(TriggerInstance::oldItem), (App)class_2073.field_45754.optionalFieldOf("new_item").forGetter(TriggerInstance::newItem), (App)BingoCodecs.enumSetOf(class_1304.field_45739).optionalFieldOf("slots", (Object)ImmutableSet.copyOf(EnumSet.allOf(class_1304.class))).forGetter(TriggerInstance::slots)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_2073> oldItem, Optional<class_2073> newItem, Set<class_1304> slots) {
            this.player = player;
            this.oldItem = oldItem;
            this.newItem = newItem;
            this.slots = slots;
        }

        public boolean matches(class_1799 oldItem, class_1799 newItem, class_1304 slot) {
            if (this.oldItem.isPresent() && !this.oldItem.get().method_8970(oldItem)) {
                return false;
            }
            if (this.newItem.isPresent() && !this.newItem.get().method_8970(newItem)) {
                return false;
            }
            return this.slots.contains(slot);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;oldItem;newItem;slots", "player", "oldItem", "newItem", "slots"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;oldItem;newItem;slots", "player", "oldItem", "newItem", "slots"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;oldItem;newItem;slots", "player", "oldItem", "newItem", "slots"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_2073> oldItem() {
            return this.oldItem;
        }

        public Optional<class_2073> newItem() {
            return this.newItem;
        }

        public Set<class_1304> slots() {
            return this.slots;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_2073> oldItem = Optional.empty();
        private Optional<class_2073> newItem = Optional.empty();
        private final Set<class_1304> slots = EnumSet.allOf(class_1304.class);

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder oldItem(class_2073 item) {
            this.oldItem = Optional.ofNullable(item);
            return this;
        }

        public Builder newItem(class_2073 item) {
            this.newItem = Optional.ofNullable(item);
            return this;
        }

        public Builder slots(class_1304 ... slots) {
            this.slots.clear();
            Collections.addAll(this.slots, slots);
            return this;
        }

        public Builder slots(class_1304.class_1305 type) {
            this.slots.clear();
            Arrays.stream(class_1304.values()).filter(s -> s.method_5925() == type).forEach(this.slots::add);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.EQUIP_ITEM.get().method_53699((class_184)new TriggerInstance(this.player, this.oldItem, this.newItem, this.slots));
        }
    }
}

