/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.CustomEnumCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_1927;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_8944;
import net.minecraft.class_9892;
import org.jetbrains.annotations.NotNull;

public class ExplosionTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_3218 level, class_1927 explosion) {
        Optional<class_47> source = Optional.ofNullable(explosion.method_46406()).map(s -> class_2048.method_27802((class_3222)player, (class_1297)s));
        class_243 location = explosion.method_55109();
        this.method_22510(player, instance -> instance.matches(source, level, location, explosion));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> source;
        private final Optional<class_2090> location;
        private final class_2096.class_2099 radius;
        private final Optional<class_2022> damageSource;
        private final Optional<class_1927.class_4179> blockInteraction;
        public static final CustomEnumCodec<class_1927.class_4179> EXPLOSION_TYPE_PREDICATE = CustomEnumCodec.of(class_1927.class_4179.class);
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("source").forGetter(TriggerInstance::source), (App)class_2090.field_45760.optionalFieldOf("location").forGetter(TriggerInstance::location), (App)class_2096.class_2099.field_45762.optionalFieldOf("radius", (Object)class_2096.class_2099.field_9705).forGetter(TriggerInstance::radius), (App)class_2022.field_45727.optionalFieldOf("damage_source").forGetter(TriggerInstance::damageSource), (App)EXPLOSION_TYPE_PREDICATE.codec().optionalFieldOf("block_interaction").forGetter(TriggerInstance::blockInteraction)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> source, Optional<class_2090> location, class_2096.class_2099 radius, Optional<class_2022> damageSource, Optional<class_1927.class_4179> blockInteraction) {
            this.player = player;
            this.source = source;
            this.location = location;
            this.radius = radius;
            this.damageSource = damageSource;
            this.blockInteraction = blockInteraction;
        }

        public boolean matches(Optional<class_47> source, class_3218 level, class_243 location, class_1927 explosion) {
            if (this.source.isPresent() && (source.isEmpty() || !this.source.get().method_27806(source.get()))) {
                return false;
            }
            if (this.location.isPresent() && !this.location.get().method_9018(level, location.field_1352, location.field_1351, location.field_1350)) {
                return false;
            }
            if (this.damageSource.isPresent() && !this.damageSource.get().method_8845(level, location, ((class_9892)explosion).method_65132())) {
                return false;
            }
            return !this.blockInteraction.isPresent() || this.blockInteraction.get() == explosion.method_55111();
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.source, ".source");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;source;location;radius;damageSource;blockInteraction", "player", "source", "location", "radius", "damageSource", "blockInteraction"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;source;location;radius;damageSource;blockInteraction", "player", "source", "location", "radius", "damageSource", "blockInteraction"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;source;location;radius;damageSource;blockInteraction", "player", "source", "location", "radius", "damageSource", "blockInteraction"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> source() {
            return this.source;
        }

        public Optional<class_2090> location() {
            return this.location;
        }

        public class_2096.class_2099 radius() {
            return this.radius;
        }

        public Optional<class_2022> damageSource() {
            return this.damageSource;
        }

        public Optional<class_1927.class_4179> blockInteraction() {
            return this.blockInteraction;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> source = Optional.empty();
        private Optional<class_2090> location = Optional.empty();
        private class_2096.class_2099 radius = class_2096.class_2099.field_9705;
        private Optional<class_2022> damageSource = Optional.empty();
        private Optional<class_1927.class_4179> blockInteraction = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder player(class_2048.class_2049 player) {
            return this.player(class_2048.method_53134((class_2048.class_2049)player));
        }

        public Builder source(class_5258 source) {
            this.source = Optional.of(source);
            return this;
        }

        public Builder source(class_2048.class_2049 source) {
            return this.source(class_2048.method_53134((class_2048.class_2049)source));
        }

        public Builder location(class_2090 location) {
            this.location = Optional.of(location);
            return this;
        }

        public Builder radius(class_2096.class_2099 radius) {
            this.radius = radius;
            return this;
        }

        public Builder damageSource(class_2022 damageSource) {
            this.damageSource = Optional.of(damageSource);
            return this;
        }

        public Builder blockInteraction(class_1927.class_4179 blockInteraction) {
            this.blockInteraction = Optional.of(blockInteraction);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.EXPLOSION.get().method_53699((class_184)new TriggerInstance(this.player, this.source, this.location, this.radius, this.damageSource, this.blockInteraction));
        }
    }
}

