/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_175;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;

public class FillBundleTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1661 inventory) {
        this.method_22510(player, instance -> instance.matches(inventory));
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.FILL_BUNDLE.get().trigger(player, inventory));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final int amount;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)Codec.INT.optionalFieldOf("amount", (Object)64).forGetter(TriggerInstance::amount)).apply((Applicative)instance, TriggerInstance::new));
        private static final Fraction FULL_STACK = Fraction.getFraction((int)64, (int)1);

        public TriggerInstance(Optional<class_5258> player, int amount) {
            this.player = player;
            this.amount = amount;
        }

        public boolean matches(class_1661 inventory) {
            for (class_1799 item : inventory) {
                class_9276 bundleContents;
                if (!item.method_31573(class_3489.field_54294) || (bundleContents = (class_9276)item.method_58694(class_9334.field_49650)) == null || bundleContents.method_57428().multiplyBy(FULL_STACK).intValue() < this.amount) continue;
                return true;
            }
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;amount", "player", "amount"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;amount", "player", "amount"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;amount", "player", "amount"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public int amount() {
            return this.amount;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private int amount = 64;

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder amount(int amount) {
            this.amount = amount;
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.FILL_BUNDLE.get().method_53699((class_184)new TriggerInstance(this.player, this.amount));
        }
    }
}

