/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.event.InventoryChangedCallback;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.progress.ProgressibleTrigger;
import io.github.gaming32.bingo.triggers.progress.SimpleProgressibleCriterionTrigger;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1661;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2048;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_4174;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8129;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HasSomeFoodItemsTrigger
extends SimpleProgressibleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1661 inventory) {
        ProgressibleTrigger.ProgressListener progressListener = this.getProgressListener(player);
        this.method_22510(player, instance -> instance.matches(player, inventory, progressListener));
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        InventoryChangedCallback.HANDLERS.add((player, inventory) -> BingoTriggers.HAS_SOME_FOOD_ITEMS.get().trigger(player, inventory));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final int requiredCount;
        private final Optional<class_8129<class_1792>> tag;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_5699.field_33442.fieldOf("required_count").forGetter(TriggerInstance::requiredCount), (App)class_8129.method_53245((class_5321)class_7924.field_41197).optionalFieldOf("tag").forGetter(TriggerInstance::tag)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, int requiredCount, Optional<class_8129<class_1792>> tag) {
            this.player = player;
            this.requiredCount = requiredCount;
            this.tag = tag;
        }

        public boolean matches(class_3222 player, class_1661 inventory, ProgressibleTrigger.ProgressListener<TriggerInstance> progressListener) {
            class_3218 level = player.method_51469();
            class_1863 recipeManager = level.method_8503().method_3772();
            Set foundItems = Sets.newIdentityHashSet();
            int l = inventory.method_5439();
            for (int i = 0; i < l; ++i) {
                class_4174 food;
                class_1799 item = inventory.method_5438(i);
                if (this.tag.isPresent() && !this.tag.get().method_48967(item.method_41409()) || (food = (class_4174)item.method_58694(class_9334.field_50075)) == null) continue;
                class_9696 input = new class_9696(item);
                Optional recipe = recipeManager.method_8132(class_3956.field_17546, (class_9695)input, (class_1937)level);
                if (recipe.isPresent()) {
                    item = ((class_3861)((class_8786)recipe.get()).comp_1933()).method_59998(input, (class_7225.class_7874)level.method_30349());
                }
                if (!foundItems.add(item.method_7909()) || foundItems.size() < this.requiredCount) continue;
                progressListener.update(this, this.requiredCount, this.requiredCount);
                return true;
            }
            progressListener.update(this, foundItems.size(), this.requiredCount);
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;requiredCount;tag", "player", "requiredCount", "tag"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;requiredCount;tag", "player", "requiredCount", "tag"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;requiredCount;tag", "player", "requiredCount", "tag"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public int requiredCount() {
            return this.requiredCount;
        }

        public Optional<class_8129<class_1792>> tag() {
            return this.tag;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        @Nullable
        private Integer requiredCount = null;
        private Optional<class_8129<class_1792>> tag = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.ofNullable(player);
            return this;
        }

        public Builder requiredCount(int requiredCount) {
            this.requiredCount = requiredCount;
            return this;
        }

        public Builder tag(class_6862<class_1792> tag) {
            return this.tag((class_8129<class_1792>)class_8129.method_48965(tag));
        }

        public Builder tag(class_8129<class_1792> tag) {
            this.tag = Optional.of(tag);
            return this;
        }

        public class_175<TriggerInstance> build() {
            if (this.requiredCount == null) {
                throw new IllegalStateException("Did not specify requiredCount");
            }
            return BingoTriggers.HAS_SOME_FOOD_ITEMS.get().method_53699((class_184)new TriggerInstance(this.player, this.requiredCount, this.tag));
        }
    }
}

