/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.subpredicates.ItemEntityPredicate;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_7376;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class ItemPickedUpTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1542 itemEntity) {
        class_47 itemEntityContext = class_2048.method_27802((class_3222)player, (class_1297)itemEntity);
        this.method_22510(player, instance -> instance.matches(itemEntityContext));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> itemEntity;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("item_entity").forGetter(TriggerInstance::itemEntity)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> itemEntity) {
            this.player = player;
            this.itemEntity = itemEntity;
        }

        public static class_175<TriggerInstance> pickedUp(class_2048 itemEntity) {
            return BingoTriggers.ITEM_PICKED_UP.get().method_53699((class_184)new TriggerInstance(Optional.empty(), class_2048.method_53137(Optional.ofNullable(itemEntity))));
        }

        public static class_175<TriggerInstance> pickedUpFrom(class_2048 droppedBy) {
            return TriggerInstance.pickedUpFrom(null, droppedBy);
        }

        public static class_175<TriggerInstance> pickedUpFrom(class_2073 item, class_2048 droppedBy) {
            return TriggerInstance.pickedUp(class_2048.class_2049.method_8916().method_43094((class_7376)ItemEntityPredicate.droppedBy(Optional.ofNullable(item), Optional.ofNullable(droppedBy))).method_8920());
        }

        public boolean matches(class_47 itemEntity) {
            return this.itemEntity.isEmpty() || this.itemEntity.get().method_27806(itemEntity);
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.itemEntity, ".item_entity");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;itemEntity", "player", "itemEntity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;itemEntity", "player", "itemEntity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;itemEntity", "player", "itemEntity"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> itemEntity() {
            return this.itemEntity;
        }
    }
}

