/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.tags.bingo.BingoBlockTags;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_1922;
import net.minecraft.class_2048;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class MineralPillarTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1922 level, class_2338 pos) {
        this.method_22510(player, instance -> instance.matches(level, pos));
    }

    public static class_175<TriggerInstance> pillar(class_6862<class_2248> tag) {
        return BingoTriggers.MINERAL_PILLAR.get().method_53699((class_184)new TriggerInstance(Optional.empty(), tag));
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final class_6862<class_2248> tag;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_6862.method_40090((class_5321)class_7924.field_41254).fieldOf("tag").forGetter(TriggerInstance::tag)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, class_6862<class_2248> tag) {
            this.player = player;
            this.tag = tag;
        }

        public boolean matches(class_1922 level, class_2338 pos) {
            int required = class_7923.field_41175.method_46733(this.tag).map(class_6885::method_40247).orElse(0);
            class_2680 state = this.getState(level, pos);
            if (state.method_26164(this.tag)) {
                if (required <= 1) {
                    return true;
                }
            } else {
                return required == 0;
            }
            HashSet<class_2680> found = HashSet.newHashSet(required);
            found.add(state);
            class_2338.class_2339 currentPos = pos.method_25503();
            if (this.loop(level, currentPos, 1, required, found)) {
                return true;
            }
            currentPos.method_10101((class_2382)pos);
            return this.loop(level, currentPos, -1, required, found);
        }

        private boolean loop(class_1922 level, class_2338.class_2339 currentPos, int direction, int required, Set<class_2680> found) {
            block1: {
                do {
                    currentPos.method_33098(currentPos.method_10264() + direction);
                    class_2680 state = this.getState(level, (class_2338)currentPos);
                    if (!state.method_26164(this.tag) || !found.add(state)) break block1;
                } while (found.size() < required);
                return true;
            }
            return false;
        }

        private class_2680 getState(class_1922 level, class_2338 pos) {
            class_2680 result = level.method_8320(pos);
            if (result.method_26164(BingoBlockTags.COPPER_BLOCKS)) {
                return class_2246.field_27119.method_9564();
            }
            return result;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;tag", "player", "tag"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;tag", "player", "tag"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;tag", "player", "tag"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public class_6862<class_2248> tag() {
            return this.tag;
        }
    }
}

