/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.ext.LeashFenceKnotEntityExt;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1532;
import net.minecraft.class_1657;
import net.minecraft.class_175;
import net.minecraft.class_184;
import net.minecraft.class_2025;
import net.minecraft.class_2048;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PulledByLeashTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_1297 entity, @Nullable class_1532 knot, class_243 force) {
        class_47 mobContext = class_2048.method_27802((class_3222)player, (class_1297)entity);
        Optional<class_47> knotContext = Optional.ofNullable(knot).map(e -> class_2048.method_27802((class_3222)player, (class_1297)e));
        this.method_22510(player, instance -> instance.matches(mobContext, knotContext, force));
    }

    public void tryTrigger(class_1297 entity, class_243 force, Operation<Void> original, @Nullable class_1297 leashHolder) {
        class_1532 knot;
        original.call(new Object[]{entity, force});
        class_1657 class_16572 = PulledByLeashTrigger.getLeashPlayer(leashHolder);
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_16572;
        this.trigger(serverPlayer, entity, leashHolder instanceof class_1532 ? (knot = (class_1532)leashHolder) : null, force);
    }

    @Nullable
    private static class_1657 getLeashPlayer(@Nullable class_1297 leashHolder) {
        if (leashHolder instanceof class_1657) {
            class_1657 player = (class_1657)leashHolder;
            return player;
        }
        if (leashHolder instanceof LeashFenceKnotEntityExt) {
            LeashFenceKnotEntityExt knot = (LeashFenceKnotEntityExt)leashHolder;
            return knot.bingo$getOwner();
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> mob;
        private final Optional<class_5258> knot;
        private final Optional<Boolean> knotRequired;
        private final Optional<class_2025> force;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_2048.field_47250.optionalFieldOf("mob").forGetter(TriggerInstance::mob), (App)class_2048.field_47250.optionalFieldOf("knot").forGetter(TriggerInstance::knot), (App)Codec.BOOL.optionalFieldOf("knot_required").forGetter(TriggerInstance::knotRequired), (App)class_2025.field_45728.optionalFieldOf("force").forGetter(TriggerInstance::force)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> mob, Optional<class_5258> knot, Optional<Boolean> knotRequired, Optional<class_2025> force) {
            this.player = player;
            this.mob = mob;
            this.knot = knot;
            this.knotRequired = knotRequired;
            this.force = force;
        }

        public boolean matches(class_47 mob, Optional<class_47> leash, class_243 force) {
            if (this.mob.isPresent() && !this.mob.get().method_27806(mob)) {
                return false;
            }
            if (leash.isPresent()) {
                if (this.knotRequired.isPresent() && !this.knotRequired.get().booleanValue()) {
                    return false;
                }
                if (this.knot.isPresent() && !this.knot.get().method_27806(leash.get())) {
                    return false;
                }
            } else if (this.knotRequired.isPresent() && this.knotRequired.get().booleanValue()) {
                return false;
            }
            return !this.force.isPresent() || this.force.get().method_8859(0.0, 0.0, 0.0, force.field_1352, force.field_1351, force.field_1350);
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            criterionValidator.method_54966(this.mob, ".mob");
            criterionValidator.method_54966(this.knot, ".knot");
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;mob;knot;knotRequired;force", "player", "mob", "knot", "knotRequired", "force"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;mob;knot;knotRequired;force", "player", "mob", "knot", "knotRequired", "force"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;mob;knot;knotRequired;force", "player", "mob", "knot", "knotRequired", "force"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> mob() {
            return this.mob;
        }

        public Optional<class_5258> knot() {
            return this.knot;
        }

        public Optional<Boolean> knotRequired() {
            return this.knotRequired;
        }

        public Optional<class_2025> force() {
            return this.force;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> mob = Optional.empty();
        private Optional<class_5258> knot = Optional.empty();
        private Optional<Boolean> knotRequired = Optional.empty();
        private Optional<class_2025> force = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder player(class_2048.class_2049 player) {
            return this.player(class_2048.method_53134((class_2048.class_2049)player));
        }

        public Builder mob(class_5258 mob) {
            this.mob = Optional.of(mob);
            return this;
        }

        public Builder mob(class_2048.class_2049 mob) {
            return this.mob(class_2048.method_53134((class_2048.class_2049)mob));
        }

        public Builder knot(class_5258 knot) {
            this.knot = Optional.of(knot);
            return this;
        }

        public Builder knot(class_2048.class_2049 knot) {
            return this.knot(class_2048.method_53134((class_2048.class_2049)knot));
        }

        public Builder knotRequired(boolean knotRequired) {
            this.knotRequired = Optional.of(knotRequired);
            return this;
        }

        public Builder force(class_2025 force) {
            this.force = Optional.of(force);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.PULLED_BY_LEASH.get().method_53699((class_184)new TriggerInstance(this.player, this.mob, this.knot, this.knotRequired, this.force));
        }
    }
}

