/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1676;
import net.minecraft.class_173;
import net.minecraft.class_175;
import net.minecraft.class_181;
import net.minecraft.class_184;
import net.minecraft.class_2025;
import net.minecraft.class_2048;
import net.minecraft.class_205;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_5341;
import net.minecraft.class_8567;
import net.minecraft.class_8944;
import org.jetbrains.annotations.NotNull;

public class ShootBellTrigger
extends class_4558<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> method_54937() {
        return TriggerInstance.CODEC;
    }

    public void trigger(class_3222 player, class_2338 pos, class_1676 projectile) {
        class_3218 level = player.method_51469();
        class_2680 state = level.method_8320(pos);
        class_8567 locationParams = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)pos.method_46558()).method_51874(class_181.field_1226, (Object)player).method_51874(class_181.field_1224, (Object)state).method_51874(class_181.field_1229, (Object)player.method_6047()).method_51875(class_173.field_44788);
        class_47 projectileContext = class_2048.method_27802((class_3222)player, (class_1297)projectile);
        class_47 bell = new class_47.class_48(locationParams).method_309(Optional.empty());
        this.method_22510(player, triggerInstance -> triggerInstance.matches(player, pos, bell, projectileContext));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class TriggerInstance
    extends Record
    implements class_4558.class_8788 {
        private final Optional<class_5258> player;
        private final Optional<class_5258> bell;
        private final Optional<class_5258> projectile;
        private final Optional<class_2025> distance;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(TriggerInstance::comp_2029), (App)class_5258.field_47234.optionalFieldOf("bell").forGetter(TriggerInstance::bell), (App)class_5258.field_47234.optionalFieldOf("projectile").forGetter(TriggerInstance::projectile), (App)class_2025.field_45728.optionalFieldOf("distance").forGetter(TriggerInstance::distance)).apply((Applicative)instance, TriggerInstance::new));

        public TriggerInstance(Optional<class_5258> player, Optional<class_5258> bell, Optional<class_5258> projectile, Optional<class_2025> distance) {
            this.player = player;
            this.bell = bell;
            this.projectile = projectile;
            this.distance = distance;
        }

        public boolean matches(class_3222 player, class_2338 bellLocation, class_47 bell, class_47 projectile) {
            if (this.bell.isPresent() && !this.bell.get().method_27806(bell)) {
                return false;
            }
            if (this.projectile.isPresent() && !this.projectile.get().method_27806(projectile)) {
                return false;
            }
            return !this.distance.isPresent() || this.distance.get().method_8859(player.method_23317(), player.method_23318(), player.method_23321(), (double)bellLocation.method_10263() + 0.5, (double)bellLocation.method_10264() + 0.5, (double)bellLocation.method_10260() + 0.5);
        }

        public void method_54938(class_8944 criterionValidator) {
            super.method_54938(criterionValidator);
            this.bell.ifPresent(p -> criterionValidator.method_54961(p, class_173.field_44788, ".location"));
            this.projectile.ifPresent(p -> criterionValidator.method_54961(p, class_173.field_24423, ".projectile"));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;bell;projectile;distance", "player", "bell", "projectile", "distance"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;bell;projectile;distance", "player", "bell", "projectile", "distance"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;bell;projectile;distance", "player", "bell", "projectile", "distance"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<class_5258> bell() {
            return this.bell;
        }

        public Optional<class_5258> projectile() {
            return this.projectile;
        }

        public Optional<class_2025> distance() {
            return this.distance;
        }
    }

    public static final class Builder {
        private Optional<class_5258> player = Optional.empty();
        private Optional<class_5258> bell = Optional.empty();
        private Optional<class_5258> projectile = Optional.empty();
        private Optional<class_2025> distance = Optional.empty();

        private Builder() {
        }

        public Builder player(class_5258 player) {
            this.player = Optional.of(player);
            return this;
        }

        public Builder bell(class_5258 bell) {
            this.bell = Optional.of(bell);
            return this;
        }

        public Builder bell(class_5341 ... conditions) {
            return this.bell(class_5258.method_27973((class_5341[])conditions));
        }

        public Builder bell(class_2090 bell) {
            return this.bell(new class_5341[]{new class_205(Optional.ofNullable(bell), class_2338.field_10980)});
        }

        public Builder projectile(class_5258 projectile) {
            this.projectile = Optional.of(projectile);
            return this;
        }

        public Builder projectile(class_2048 projectile) {
            return this.projectile(class_2048.method_51704((class_2048)projectile));
        }

        public Builder distance(class_2025 distance) {
            this.distance = Optional.of(distance);
            return this;
        }

        public class_175<TriggerInstance> build() {
            return BingoTriggers.SHOOT_BELL.get().method_53699((class_184)new TriggerInstance(this.player, this.bell, this.projectile, this.distance));
        }
    }
}

