/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.util;

import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2694;
import net.minecraft.class_3542;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;

public class BlockPattern {
    private final Predicate<class_2694>[][][] predicates;
    private final int xSize;
    private final int ySize;
    private final int zSize;

    public BlockPattern(Predicate<class_2694>[][][] predicates) {
        this.predicates = predicates;
        this.zSize = predicates.length;
        this.ySize = Arrays.stream(predicates).mapToInt(aisle -> ((Predicate[][])aisle).length).max().orElse(0);
        this.xSize = Arrays.stream(predicates).flatMapToInt(aisle -> Arrays.stream(aisle).mapToInt(row -> ((Predicate[])row).length)).max().orElse(0);
    }

    private static void transformPos(class_2338 origin, class_2338 pos, class_2350 right, class_2350 up, class_2350 forward, class_2338.class_2339 outPos) {
        outPos.method_10103(pos.method_10263() - origin.method_10263(), pos.method_10264() - origin.method_10264(), pos.method_10260() - origin.method_10260());
        outPos.method_10103(outPos.method_10263() * right.method_10148() + outPos.method_10264() * up.method_10148() + outPos.method_10260() * forward.method_10148() + origin.method_10263(), outPos.method_10263() * right.method_10164() + outPos.method_10264() * up.method_10164() + outPos.method_10260() * forward.method_10164() + origin.method_10264(), outPos.method_10263() * right.method_10165() + outPos.method_10264() * up.method_10165() + outPos.method_10260() * forward.method_10165() + origin.method_10260());
    }

    private boolean check(class_4538 level, class_2338 origin, class_2338 checkAt, class_2350 right, class_2350 up, class_2350 forward) {
        class_2338.class_2339 tempPos = new class_2338.class_2339();
        for (class_2338 pos : class_2338.method_10097((class_2338)checkAt, (class_2338)checkAt.method_10069(this.xSize - 1, this.ySize - 1, this.zSize - 1))) {
            BlockPattern.transformPos(origin, pos, right, up, forward, tempPos);
            if (this.predicates[pos.method_10260() - checkAt.method_10260()][pos.method_10264() - checkAt.method_10264()][pos.method_10263() - checkAt.method_10263()].test(new class_2694(level, (class_2338)tempPos, false))) continue;
            return false;
        }
        return true;
    }

    private boolean find(class_4538 level, class_2338 origin, class_2350 right, class_2350 up, class_2350 forward) {
        for (class_2338 checkAt : class_2338.method_10097((class_2338)origin.method_10059(new class_2382(this.xSize - 1, this.ySize - 1, this.zSize - 1)), (class_2338)origin)) {
            if (!this.check(level, origin, checkAt, right, up, forward)) continue;
            return true;
        }
        return false;
    }

    public boolean find(class_4538 level, class_2338 origin, Rotations rotations) {
        if (this.xSize == 0 || this.ySize == 0 || this.zSize == 0) {
            return true;
        }
        return switch (rotations.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.find(level, origin, class_2350.field_11034, class_2350.field_11036, class_2350.field_11043);
            case 1 -> {
                for (class_2350 right : class_2350.class_2353.field_11062) {
                    for (class_2350 forward : class_2350.class_2353.field_11062) {
                        if (right.method_10166() == forward.method_10166() || !this.find(level, origin, right, class_2350.field_11036, forward)) continue;
                        yield true;
                    }
                }
                yield false;
            }
            case 2 -> {
                for (class_2350 right : class_2350.values()) {
                    for (class_2350 forward : class_2350.values()) {
                        if (forward.method_10166() == right.method_10166()) continue;
                        for (class_2350 up : class_2350.values()) {
                            if (up.method_10166() == right.method_10166() || up.method_10166() == forward.method_10166() || !this.find(level, origin, right, up, forward)) continue;
                            yield true;
                        }
                    }
                }
                yield false;
            }
        };
    }

    public static enum Rotations implements class_3542
    {
        NONE("none"),
        HORIZONTAL("horizontal"),
        ALL("all");

        public static final class_3542.class_7292<Rotations> CODEC;
        private final String serializedName;

        private Rotations(String serializedName) {
            this.serializedName = serializedName;
        }

        @NotNull
        public String method_15434() {
            return this.serializedName;
        }

        static {
            CODEC = class_3542.method_28140(Rotations::values);
        }
    }
}

