/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_7923;

public class StatCodecs {
    public static final Codec<class_3445<?>> CODEC = StatCodecs.createCodec();
    public static final Codec<class_3445<?>> STRING_CODEC = StatCodecs.createStringCodec();

    private static <S> Codec<class_3445<S>> createCodec() {
        return new MapCodec<class_3445<S>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(ops.createString("type"), ops.createString("stat"));
            }

            public <T> DataResult<class_3445<S>> decode(DynamicOps<T> ops, MapLike<T> input) {
                DataResult<class_2960> typeKey = 1.get(ops, input, "type");
                if (typeKey.result().isEmpty()) {
                    return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)typeKey.error().orElseThrow())).message());
                }
                class_3448 type = (class_3448)class_7923.field_41193.method_63535((class_2960)typeKey.result().get());
                if (type == null) {
                    return DataResult.error(() -> "Unknown stat_type " + String.valueOf(typeKey.result().orElseThrow()));
                }
                DataResult<class_2960> statKey = 1.get(ops, input, "stat");
                if (statKey.result().isEmpty()) {
                    return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)statKey.error().orElseThrow())).message());
                }
                Object statId = type.method_14959().method_63535((class_2960)statKey.result().get());
                if (statId == null) {
                    return DataResult.error(() -> "Unknown " + String.valueOf(typeKey.result().orElseThrow()) + " " + String.valueOf(statKey.result().orElseThrow()));
                }
                return DataResult.success((Object)type.method_14956(statId));
            }

            public <T> RecordBuilder<T> encode(class_3445<S> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                1.add(ops, prefix, "type", class_7923.field_41193, input.method_14949());
                1.add(ops, prefix, "stat", input.method_14949().method_14959(), input.method_14951());
                return prefix;
            }

            private static <T> DataResult<class_2960> get(DynamicOps<T> ops, MapLike<T> input, String key) {
                return Optional.ofNullable(input.get(key)).map(arg_0 -> ops.getStringValue(arg_0)).map(v -> v.flatMap(class_2960::method_29186)).orElseGet(() -> DataResult.error(() -> "key missing: " + key + " in " + String.valueOf(input)));
            }

            private static <T, V> void add(DynamicOps<T> ops, RecordBuilder<T> prefix, String name, class_2378<V> registry, V value) {
                class_2960 key = registry.method_10221(value);
                if (key == null) {
                    prefix.withErrorsFrom(DataResult.error(() -> "Unregistered value " + String.valueOf(value) + " in " + String.valueOf(registry.method_46765().method_29177())));
                    return;
                }
                prefix.add(name, ops.createString(key.toString()));
            }
        }.codec();
    }

    private static Codec<class_3445<?>> createStringCodec() {
        return Codec.STRING.comapFlatMap(name -> class_274.method_1224((String)name).map(criteria -> {
            if (!(criteria instanceof class_3445)) {
                return DataResult.error(() -> criteria.method_1225() + " is not a stat");
            }
            class_3445 stat = (class_3445)criteria;
            return DataResult.success((Object)stat);
        }).orElseGet(() -> DataResult.error(() -> "Unknown stat " + name)), class_274::method_1225);
    }
}

