/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.logging.LogUtils;
import io.github.gaming32.bingo.BingoCommand;
import io.github.gaming32.bingo.client.BingoConfig;
import io.github.gaming32.bingo.conditions.BingoConditions;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.goal.GoalManager;
import io.github.gaming32.bingo.data.icons.GoalIconType;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTrackerType;
import io.github.gaming32.bingo.data.subs.BingoSubType;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.ext.ServerPlayerExt;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import io.github.gaming32.bingo.game.persistence.PersistenceManager;
import io.github.gaming32.bingo.network.BingoNetworking;
import io.github.gaming32.bingo.network.messages.both.ManualHighlightPayload;
import io.github.gaming32.bingo.network.messages.configuration.ProtocolVersionConfigurationTask;
import io.github.gaming32.bingo.network.messages.configuration.ProtocolVersionPayload;
import io.github.gaming32.bingo.network.messages.s2c.InitBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.RemoveBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.ResyncStatesPayload;
import io.github.gaming32.bingo.network.messages.s2c.SyncTeamPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateProgressPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateStatePayload;
import io.github.gaming32.bingo.platform.BingoPlatform;
import io.github.gaming32.bingo.platform.event.Event;
import io.github.gaming32.bingo.subpredicates.BingoEntitySubPredicates;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.BingoUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1927;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2539;
import net.minecraft.class_2561;
import net.minecraft.class_2598;
import net.minecraft.class_269;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Bingo {
    public static final String MOD_ID = "bingo";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final BingoConfig CONFIG = new BingoConfig(BingoPlatform.platform.getConfigDir().resolve("bingo.toml"));
    public static final class_5218 PERSISTED_BINGO_GAME = new class_5218("persisted_bingo_game.dat");

    public static void init() {
        CONFIG.load();
        CONFIG.save();
        Bingo.registerEventHandlers();
        Bingo.initializeRegistries();
        Bingo.registerDatapackRegistries();
        Bingo.registerDataReloadListeners();
        Bingo.registerPayloadHandlers();
        LOGGER.info("I got the diagonal!");
    }

    private static void registerEventHandlers() {
        Event.REGISTER_COMMANDS.register(BingoCommand::register);
        Event.REGISTER_CONFIGURATION_TASKS.register(registrar -> {
            if (registrar.canSend(ProtocolVersionPayload.TYPE)) {
                registrar.addTask(ProtocolVersionConfigurationTask.INSTANCE);
            }
        });
        Event.PLAYER_JOIN.register(player -> {
            MinecraftServer server = player.method_51469().method_8503();
            BingoGame game = ((MinecraftServerExt)server).bingo$getGame();
            if (game != null) {
                game.addPlayer((class_3222)player);
            }
        });
        Event.PLAYER_QUIT.register(player -> {
            MinecraftServer server = player.method_51469().method_8503();
            BingoGame game = ((MinecraftServerExt)server).bingo$getGame();
            if (game != null) {
                game.removePlayer((class_3222)player);
            }
        });
        Event.COPY_PLAYER.register((from, to) -> ((ServerPlayerExt)from).bingo$copyAdvancementsNeedClearingTo((class_3222)to));
        Event.RIGHT_CLICK_ITEM.register((player, hand) -> {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                BingoTriggers.TRY_USE_ITEM.get().trigger(serverPlayer, (class_1268)hand);
            }
        });
        Event.SERVER_EXPLOSION_START.register((level, explosion) -> {
            if (level instanceof class_3218) {
                class_3222 thePlayer;
                class_1297 patt1$temp;
                class_3222 thePlayer2;
                class_3218 serverLevel = level;
                class_1309 patt0$temp = explosion.method_8347();
                Object player = patt0$temp instanceof class_3222 ? (thePlayer2 = (class_3222)patt0$temp) : ((patt1$temp = explosion.method_65132().method_5529()) instanceof class_3222 ? (thePlayer = (class_3222)patt1$temp) : null);
                if (player != null) {
                    BingoTriggers.EXPLOSION.get().trigger((class_3222)player, serverLevel, (class_1927)explosion);
                }
            }
        });
        Event.SERVER_TICK_END.register(instance -> {
            BingoGame game = ((MinecraftServerExt)instance).bingo$getGame();
            if (game != null) {
                game.tick((MinecraftServer)instance);
            }
        });
        Event.SERVER_STARTED.register(instance -> {
            Path path = instance.method_27050(PERSISTED_BINGO_GAME);
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                return;
            }
            LOGGER.info("Reading persisted Bingo game");
            try {
                class_2487 tag = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
                ((MinecraftServerExt)instance).bingo$setGame(PersistenceManager.deserialize((class_7225.class_7874)instance.method_30611(), tag, (class_269)instance.method_3845()));
                Files.deleteIfExists(path);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load persisted Bingo game", (Throwable)e);
            }
        });
        Event.SERVER_STOPPING.register(instance -> {
            BingoGame game = ((MinecraftServerExt)instance).bingo$getGame();
            if (game == null) {
                return;
            }
            LOGGER.info("Storing persistent Bingo game");
            Path path = instance.method_27050(PERSISTED_BINGO_GAME);
            try {
                class_2487 tag = PersistenceManager.serialize((class_7225.class_7874)instance.method_30611(), game);
                class_2507.method_30614((class_2487)tag, (Path)path);
            }
            catch (Exception e) {
                LOGGER.error("Failed to store persistent Bingo game", (Throwable)e);
            }
        });
    }

    private static void initializeRegistries() {
        BingoGameMode.load();
        GoalIconType.load();
        ProgressTrackerType.load();
        BingoSubType.load();
        BingoConditions.load();
        BingoEntitySubPredicates.load();
        BingoTriggers.load();
    }

    private static void registerDatapackRegistries() {
        BingoPlatform.platform.registerDatapackRegistries(registrar -> {
            registrar.unsynced(BingoRegistries.TAG, BingoTag.CODEC);
            registrar.unsynced(BingoRegistries.DIFFICULTY, BingoDifficulty.CODEC);
        });
    }

    private static void registerDataReloadListeners() {
        BingoPlatform.platform.registerDataReloadListeners(registrar -> registrar.register(GoalManager.ID, GoalManager::new));
    }

    private static void registerPayloadHandlers() {
        BingoNetworking.instance().onRegister(registrar -> {
            registrar.register(class_2539.field_45671, null, ProtocolVersionPayload.TYPE, ProtocolVersionPayload.CODEC, (payload, context) -> {
                switch (context.flow()) {
                    case field_11942: {
                        payload.handleClientbound((BingoNetworking.Context)context);
                        break;
                    }
                    case field_11941: {
                        payload.handleServerbound((BingoNetworking.Context)context);
                    }
                }
            });
            registrar.register(class_2598.field_11942, InitBoardPayload.TYPE, InitBoardPayload.CODEC);
            registrar.register(class_2598.field_11942, RemoveBoardPayload.TYPE, RemoveBoardPayload.CODEC);
            registrar.register(class_2598.field_11942, ResyncStatesPayload.TYPE, ResyncStatesPayload.CODEC);
            registrar.register(class_2598.field_11942, SyncTeamPayload.TYPE, SyncTeamPayload.CODEC);
            registrar.register(class_2598.field_11942, UpdateProgressPayload.TYPE, UpdateProgressPayload.CODEC);
            registrar.register(class_2598.field_11942, UpdateStatePayload.TYPE, UpdateStatePayload.CODEC);
            registrar.register(null, ManualHighlightPayload.TYPE, ManualHighlightPayload.CODEC);
        });
    }

    public static void updateCommandTree(class_3324 playerList) {
        playerList.method_14571().forEach(arg_0 -> ((class_2170)playerList.method_14561().method_3734()).method_9241(arg_0));
    }

    public static class_5250 translatable(@Translatable String key, Object ... args) {
        return BingoUtil.ensureHasFallback(class_2561.method_43469((String)key, (Object[])args));
    }

    public static class_5250 translatableEscape(@Translatable(allowArbitraryArgs=true) String key, Object ... args) {
        return BingoUtil.ensureHasFallback(class_2561.method_54159((String)key, (Object[])args));
    }

    public static boolean isInstalledOnClient(class_3222 player) {
        return BingoNetworking.instance().canPlayerReceive(player, InitBoardPayload.TYPE);
    }
}

