/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class BingoConfig {
    private final FileConfig config;
    private Set<UUID> nerfedPlayers = new HashSet<UUID>();

    public BingoConfig(Path configPath) {
        this.config = FileConfig.of((Path)configPath).checked();
    }

    public void load() {
        this.config.load();
        this.nerfedPlayers = BingoConfig.deserializeNerfedPlayers(this.config.get("nerfed_players"));
    }

    public void save() {
        this.config.clear();
        this.config.set("nerfed_players", BingoConfig.serializeNerfedPlayers(this.nerfedPlayers));
        this.config.save();
    }

    public Set<UUID> getNerfedPlayers() {
        return this.nerfedPlayers;
    }

    private static Set<UUID> deserializeNerfedPlayers(Object nerfedPlayers) {
        if (!(nerfedPlayers instanceof List)) {
            return new HashSet<UUID>();
        }
        List list = (List)nerfedPlayers;
        HashSet<UUID> result = HashSet.newHashSet(list.size());
        for (Object player : list) {
            if (!(player instanceof String)) {
                return new HashSet<UUID>();
            }
            String uuidStr = (String)player;
            try {
                result.add(UUID.fromString(uuidStr));
            }
            catch (IllegalArgumentException e) {
                return new HashSet<UUID>();
            }
        }
        return result;
    }

    private static List<String> serializeNerfedPlayers(Set<UUID> nerfedPlayers) {
        return nerfedPlayers.stream().map(UUID::toString).toList();
    }
}

