/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client;

import io.github.gaming32.bingo.client.ClientGame;
import io.github.gaming32.bingo.client.PositionAndScale;
import io.github.gaming32.bingo.game.BoardShape;
import io.github.gaming32.bingo.util.Vec2i;
import net.minecraft.class_310;

public record BingoMousePos(double mouseX, double mouseY, int goalIndex) {
    public static BingoMousePos getPos(class_310 minecraft, BoardShape shape, int size, PositionAndScale boardPos) {
        double mouseX = minecraft.field_1729.method_1603() * (double)minecraft.method_22683().method_4486() / (double)minecraft.method_22683().method_4480();
        double mouseY = minecraft.field_1729.method_1604() * (double)minecraft.method_22683().method_4502() / (double)minecraft.method_22683().method_4507();
        double relX = (mouseX - (double)(boardPos.x() * boardPos.scale())) / (double)boardPos.scale();
        double relY = (mouseY - (double)(boardPos.y() * boardPos.scale())) / (double)boardPos.scale();
        double slotIdXD = (relX - 7.0) / 18.0;
        double slotIdYD = (relY - 17.0) / 18.0;
        int goalIndex = -1;
        Vec2i visualSize = shape.getVisualSize(size);
        if (slotIdXD >= 0.0 && slotIdXD < (double)visualSize.x() && slotIdYD >= 0.0 && slotIdYD < (double)visualSize.y()) {
            int slotIdX = (int)((relX - 7.0) / 18.0);
            int slotIdY = (int)((relY - 17.0) / 18.0);
            goalIndex = shape.getCellFromCoords(size, slotIdX, slotIdY);
        }
        return new BingoMousePos(mouseX, mouseY, goalIndex);
    }

    public boolean hasSlotPos() {
        return this.goalIndex != -1;
    }

    public Vec2i getSlotPos(ClientGame game) {
        return game.shape().getCoords(game.size(), this.goalIndex);
    }

    public static boolean hasSlotPos(BingoMousePos pos) {
        return pos != null && pos.hasSlotPos();
    }
}

