/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client;

import io.github.gaming32.bingo.client.BingoClient;
import io.github.gaming32.bingo.client.ClientGame;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.game.BingoBoard;
import io.github.gaming32.bingo.util.ResourceLocations;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_531;
import net.minecraft.class_535;
import net.minecraft.class_537;
import net.minecraft.class_5819;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import net.minecraft.class_8685;
import net.minecraft.class_9848;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamSelectionSpectatorCategory
implements class_535,
class_537 {
    private static final class_2960 CATEGORY_SPRITE = ResourceLocations.bingo("spectator/team_selection");
    private static final class_2561 CATEGORY_NAME = class_2561.method_43471((String)"bingo.spectator.team_selection");
    private static final class_2561 CATEGORY_PROMPT = class_2561.method_43471((String)"bingo.spectator.team_selection.prompt");
    private final List<class_537> items = TeamSelectionSpectatorCategory.createTeamEntries(BingoClient.clientGame);

    private static List<class_537> createTeamEntries(@Nullable ClientGame game) {
        if (game == null) {
            return List.of();
        }
        MutableInt teamId = new MutableInt();
        return Arrays.stream(game.teams()).map(team -> TeamSelectionItem.create(game, team, BingoBoard.Teams.fromOne(teamId.getAndIncrement()))).filter(Objects::nonNull).toList();
    }

    @NotNull
    public List<class_537> method_2780() {
        return this.items;
    }

    @NotNull
    public class_2561 method_2781() {
        return CATEGORY_PROMPT;
    }

    public void method_2783(class_531 menu) {
        menu.method_2778((class_535)this);
    }

    @NotNull
    public class_2561 method_16892() {
        return CATEGORY_NAME;
    }

    public void method_2784(class_332 graphics, float brightness, float alpha) {
        graphics.method_52707(class_10799.field_56883, CATEGORY_SPRITE, 0, 0, 16, 16, class_9848.method_61318((float)alpha, (float)brightness, (float)brightness, (float)brightness));
    }

    public boolean method_16893() {
        return !this.items.isEmpty();
    }

    private record TeamSelectionItem(class_268 playerTeam, BingoBoard.Teams teamState, @Nullable class_8685 iconSkin, class_2561 displayName) implements class_537
    {
        @Nullable
        public static class_537 create(ClientGame game, class_268 team, BingoBoard.Teams teamId) {
            class_8685 iconSkin;
            class_310 minecraft = class_310.method_1551();
            ArrayList<class_640> onlinePlayers = new ArrayList<class_640>();
            for (String playerName : team.method_1204()) {
                class_640 playerInfo = minecraft.method_1562().method_2874(playerName);
                if (playerInfo == null || playerInfo.method_2958() == class_1934.field_9219) continue;
                onlinePlayers.add(playerInfo);
            }
            if (onlinePlayers.isEmpty()) {
                boolean hasAnyGoals = false;
                for (int i = 0; i < game.states().length; ++i) {
                    boolean hasGoal = game.states()[i].and(teamId);
                    if (game.goals()[i].specialType() == BingoTag.SpecialType.NEVER) {
                        boolean bl = hasGoal = !hasGoal;
                    }
                    if (!hasGoal) continue;
                    hasAnyGoals = true;
                    break;
                }
                if (!hasAnyGoals) {
                    return null;
                }
            }
            if (onlinePlayers.isEmpty()) {
                iconSkin = null;
            } else {
                class_640 teamFace = (class_640)onlinePlayers.get(class_5819.method_43047().method_43048(onlinePlayers.size()));
                iconSkin = teamFace.method_52810();
            }
            return new TeamSelectionItem(team, teamId, iconSkin, BingoClient.getDisplayName(team));
        }

        public void method_2783(class_531 menu) {
            BingoClient.clientTeam = this.teamState;
        }

        @NotNull
        public class_2561 method_16892() {
            return this.displayName;
        }

        public void method_2784(class_332 graphics, float brightness, float alpha) {
            Integer color = this.playerTeam.method_1202().method_532();
            if (color != null) {
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                graphics.method_25294(1, 1, 15, 15, class_9848.method_61318((float)alpha, (float)(red * brightness), (float)(green * brightness), (float)(blue * brightness)));
            }
            if (this.iconSkin != null) {
                class_7532.method_44443((class_332)graphics, (class_8685)this.iconSkin, (int)2, (int)2, (int)12, (int)class_9848.method_61317((float)alpha));
            }
        }

        public boolean method_16893() {
            return true;
        }
    }
}

