/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.config;

import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.client.BingoClient;
import io.github.gaming32.bingo.client.config.BoardCorner;
import io.github.gaming32.bingo.ext.RowHelperExt;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_6382;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_9848;

public class BingoConfigScreen
extends class_437 {
    private final class_437 parent;

    public BingoConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"bingo.client_config.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        class_7845 gridLayout = new class_7845();
        gridLayout.method_46458().method_46477(5).method_46475(4).method_46467();
        class_7845.class_7939 rowHelper = gridLayout.method_47610(2);
        rowHelper.method_47612(this.createCornerButton());
        rowHelper.method_47612(this.createShowBoardOnF3ScreenButton());
        rowHelper.method_47612((class_8021)this.createSizeSlider());
        rowHelper.method_47612(this.createShowScoreCounterButton());
        ((RowHelperExt)rowHelper).bingo$ensureNewLine();
        for (int slot = 0; slot < 3; ++slot) {
            this.addManualHighlightColorTextField(rowHelper, slot);
        }
        rowHelper.method_47614((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.field_22787.method_1507(this.parent)).method_46432(200).method_46431(), 2, rowHelper.method_47611().method_46471(2));
        rowHelper.method_47614((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"controls.reset"), button -> {
            BingoClient.CONFIG.reset();
            this.method_25426();
            BingoClient.CONFIG.save();
        }).method_46432(200).method_46431(), 2, rowHelper.method_47611().method_46471(2));
        gridLayout.method_48222();
        class_7843.method_46443((class_8021)gridLayout, (int)0, (int)(this.field_22790 / 6 - 12), (int)this.field_22789, (int)this.field_22790, (float)0.5f, (float)0.0f);
        gridLayout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, -1);
    }

    private class_5676<BoardCorner> createCornerButton() {
        return class_5676.method_32606(BoardCorner::getDescription).method_32624((Object[])BoardCorner.values()).method_32619((Object)BingoClient.CONFIG.getBoardCorner()).method_32617(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"bingo.client_config.board_corner"), (button, corner) -> {
            BingoClient.CONFIG.setBoardCorner((BoardCorner)((Object)corner));
            BingoClient.CONFIG.save();
        });
    }

    private class_5676<Boolean> createShowBoardOnF3ScreenButton() {
        return class_5676.method_32614().method_32619((Object)BingoClient.CONFIG.showBoardOnF3Screen()).method_32618(v -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"bingo.client_config.show_board_on_f3_screen.tooltip"))).method_32617(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"bingo.client_config.show_board_on_f3_screen"), (button, show) -> {
            BingoClient.CONFIG.setShowBoardOnF3Screen((boolean)show);
            BingoClient.CONFIG.save();
        });
    }

    private class_357 createSizeSlider() {
        return new class_357(this, 0, 0, 150, 20, class_5244.field_39003, (Math.log10(BingoClient.CONFIG.getBoardScale()) + 1.0) / 2.0){
            private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("0.##");
            {
                this.method_25346();
            }

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43469((String)"bingo.client_config.board_scale", (Object[])new Object[]{NUMBER_FORMAT.format(this.getRealValue())}));
            }

            protected void method_25344() {
                BingoClient.CONFIG.setBoardScale((float)this.getRealValue());
                BingoClient.CONFIG.save();
            }

            private double getRealValue() {
                return Math.pow(10.0, this.field_22753 * 2.0 - 1.0);
            }
        };
    }

    private class_5676<Boolean> createShowScoreCounterButton() {
        return class_5676.method_32614().method_32619((Object)BingoClient.CONFIG.isShowScoreCounter()).method_32618(v -> class_7919.method_47407((class_2561)class_2561.method_43471((String)"bingo.client_config.show_score_counter.tooltip"))).method_32617(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"bingo.client_config.show_score_counter"), (button, show) -> {
            BingoClient.CONFIG.setShowScoreCounter((boolean)show);
            BingoClient.CONFIG.save();
        });
    }

    private void addManualHighlightColorTextField(class_7845.class_7939 rowHelper, int highlightValue) {
        class_5250 label = Bingo.translatable("bingo.client_config.manual_highlight_color", highlightValue + 1);
        int color = BingoClient.CONFIG.getManualHighlightColor(highlightValue) & 0xFFFFFF;
        class_342 editBox = new class_342(this.field_22793, 150, 20, (class_2561)label);
        editBox.method_1852("%06X".formatted(color));
        ColorBox colorBox = new ColorBox(this.field_22793, 20, 20, (class_2561)label, color);
        editBox.method_1863(value -> {
            int newColor;
            try {
                newColor = Integer.parseInt(value, 16) & 0xFFFFFF;
            }
            catch (NumberFormatException e) {
                editBox.method_1868(-65536);
                return;
            }
            editBox.method_1868(-2039584);
            colorBox.color = newColor;
            BingoClient.CONFIG.setManualHighlightColor(highlightValue, newColor);
            BingoClient.CONFIG.save();
        });
        rowHelper.method_47612((class_8021)colorBox);
        rowHelper.method_47612((class_8021)editBox);
    }

    private static class ColorBox
    extends class_339 {
        private final class_327 font;
        private final class_2561 label;
        private int color;

        public ColorBox(class_327 font, int width, int height, class_2561 label, int color) {
            super(0, 0, font.method_27525((class_5348)label) + 5 + width, height, (class_2561)class_2561.method_43473());
            this.font = font;
            this.label = label;
            this.color = color;
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            int labelWidth = this.font.method_27525((class_5348)this.label);
            int n = this.method_46426();
            int n2 = this.method_46427();
            int n3 = this.method_25364();
            Objects.requireNonNull(this.font);
            graphics.method_27535(this.font, this.label, n, n2 + (n3 - 9) / 2, -1);
            int boxLeft = this.method_46426() + labelWidth + 5;
            graphics.method_25294(boxLeft, this.method_46427(), this.method_55442() - 1, this.method_55443(), class_9848.method_61330((int)255, (int)this.color));
            graphics.method_51738(boxLeft, this.method_55442() - 1, this.method_46427(), -16777216);
            graphics.method_51738(boxLeft, this.method_55442() - 1, this.method_55443() - 1, -16777216);
            graphics.method_51742(boxLeft, this.method_46427(), this.method_55443() - 1, -16777216);
            graphics.method_51742(this.method_55442() - 1, this.method_46427(), this.method_55443() - 1, -16777216);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }
    }
}

