/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.client.icons;

import com.mojang.logging.LogUtils;
import io.github.gaming32.bingo.client.icons.IconRenderer;
import io.github.gaming32.bingo.data.icons.EntityIcon;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_10719;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3730;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_7833;
import net.minecraft.class_8942;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class EntityIconRenderer
implements IconRenderer<EntityIcon> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_10719<class_638, Map<EntityIcon, class_1297>> ENTITIES = new class_10719(l -> new WeakHashMap());

    @Override
    public void render(EntityIcon icon, class_332 graphics, int x, int y) {
        class_1297 entity = EntityIconRenderer.getEntity(icon);
        if (entity == null) {
            return;
        }
        EntityIconRenderer.renderEntity(entity, graphics, x, y);
    }

    public static void renderEntity(class_1297 entity, class_332 graphics, int x, int y) {
        class_1309 living;
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null) {
            return;
        }
        float size = 14.0f;
        if (Math.max(entity.method_17681(), entity.method_17682()) > 1.0f) {
            size /= Math.max(entity.method_17681(), entity.method_17682());
        }
        if (entity instanceof class_1309 && (living = (class_1309)entity).method_6109()) {
            size /= 1.7f;
        }
        Vector3f translation = new Vector3f(0.0f, entity.method_17682() / 2.0f + 0.0625f, 0.0f);
        Quaternionf xRot = class_7833.field_40714.rotationDegrees(-10.0f);
        Quaternionf rotation = class_7833.field_40718.rotationDegrees(180.0f).mul((Quaternionfc)xRot);
        xRot.conjugate();
        entity.field_6012 = minecraft.field_1724.field_6012;
        entity.method_36456(-150.0f);
        entity.method_5847(-150.0f);
        entity.method_5636(-150.0f);
        entity.method_36457(0.0f);
        class_898 renderDispatcher = minecraft.method_1561();
        Vector2f topLeft = graphics.method_51448().transformPosition((float)x, (float)y, new Vector2f());
        Vector2f bottomRight = graphics.method_51448().transformPosition((float)(x + 16), (float)(y + 16), new Vector2f());
        class_897 entityRenderer = renderDispatcher.method_3953(entity);
        graphics.method_70856(entityRenderer.method_62425(entity, 1.0f), size, translation, rotation, xRot, (int)topLeft.x, (int)topLeft.y, (int)bottomRight.x, (int)bottomRight.y);
    }

    @Nullable
    private static class_1297 getEntity(EntityIcon icon) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        return ((Map)ENTITIES.method_67267((class_10719.class_10720)level)).computeIfAbsent(icon, EntityIconRenderer::createEntity);
    }

    @Nullable
    private static class_1297 createEntity(EntityIcon icon) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        class_1297 entity = icon.entity().method_5883((class_1937)level, class_3730.field_52444);
        if (entity != null) {
            try (class_8942.class_11340 collector = new class_8942.class_11340((class_8942.class_11336)new class_8942.class_11333("data"), LOGGER);){
                class_11368 input = class_11352.method_71417((class_8942)collector, (class_7225.class_7874)level.method_30349(), (class_2487)icon.data());
                entity.method_5651(input);
            }
        }
        return entity;
    }
}

