/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.commandswitch;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import io.github.gaming32.bingo.commandswitch.ArgGetter;
import io.github.gaming32.bingo.commandswitch.ArgumentSwitch;
import io.github.gaming32.bingo.commandswitch.ConstantSwitch;
import io.github.gaming32.bingo.commandswitch.RepeatableArgumentSwitch;
import io.github.gaming32.bingo.util.BingoUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7079;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public sealed interface CommandSwitch<T>
permits ArgumentSwitch, ConstantSwitch, RepeatableArgumentSwitch {
    public String name();

    public void addTo(CommandNode<class_2168> var1);

    public T get(CommandContext<class_2168> var1);

    public static CommandSwitch<Boolean> storeTrue(String name) {
        return CommandSwitch.storeConstant(name, true, false);
    }

    public static CommandSwitch<Boolean> storeFalse(String name) {
        return CommandSwitch.storeConstant(name, false, true);
    }

    public static <T> CommandSwitch<@Nullable T> storeConstant(String name, T value) {
        return CommandSwitch.storeConstant(name, value, null);
    }

    public static <T> CommandSwitch<T> storeConstant(String name, T value, T fallback) {
        return new ConstantSwitch<T>(name, value, fallback);
    }

    public static <T> ArgumentSwitchBuilder<T, T> argument(String name, ArgumentType<T> type) {
        return new ArgumentSwitchBuilder(name, type);
    }

    public static <A, T> ArgumentSwitchBuilder<A, T> specialArgument(String name, ArgumentType<A> type) {
        return new ArgumentSwitchBuilder(name, type);
    }

    public static ArgumentSwitchBuilder<Integer, Integer> argument(String name, IntegerArgumentType type) {
        return CommandSwitch.argument(name, type).getter(IntegerArgumentType::getInteger);
    }

    public static ArgumentSwitchBuilder<Long, Long> argument(String name, LongArgumentType type) {
        return CommandSwitch.argument(name, type).getter(LongArgumentType::getLong);
    }

    public static ArgumentSwitchBuilder<String, String> argument(String name, StringArgumentType type) {
        return CommandSwitch.argument(name, type).getter(StringArgumentType::getString);
    }

    public static <T> ResourceArgumentSwitchBuilder<T> resource(String name, class_5321<class_2378<T>> registry) {
        return new ResourceArgumentSwitchBuilder<T>(name, registry);
    }

    public static final class ArgumentSwitchBuilder<A, T> {
        private final String name;
        private final ArgumentType<A> type;
        private String argName;
        private ArgGetter<T> getter;
        private SuggestionProvider<class_2168> suggests = null;

        private ArgumentSwitchBuilder(String name, ArgumentType<A> type) {
            this.name = name;
            this.type = type;
            this.argName = ArgumentSwitchBuilder.inferArgName(name);
        }

        private static String inferArgName(String name) {
            return (String)StringUtils.defaultIfEmpty((CharSequence)StringUtils.substringAfterLast((String)name, (int)45), (CharSequence)name);
        }

        public ArgumentSwitchBuilder<A, T> argName(String argName) {
            this.argName = argName;
            return this;
        }

        public ArgumentSwitchBuilder<A, T> getter(ArgGetter<T> getter) {
            this.getter = getter;
            return this;
        }

        public ArgumentSwitchBuilder<A, T> suggests(SuggestionProvider<class_2168> suggests) {
            this.suggests = suggests;
            return this;
        }

        public CommandSwitch<T> build(Function<CommandContext<class_2168>, T> defaultValue) {
            return this.buildInner(defaultValue);
        }

        public CommandSwitch<T> build(Supplier<T> defaultSupplier) {
            return this.buildInner(ctx -> defaultSupplier.get());
        }

        public CommandSwitch<T> build(T defaultValue) {
            return this.buildInner(ctx -> defaultValue);
        }

        public <C> CommandSwitch<C> buildRepeatable(Function<Collection<T>, C> collectionFunction) {
            return new RepeatableArgumentSwitch<A, Object, Object>(this.buildInner(context -> null), (context, values) -> collectionFunction.apply((Collection)values));
        }

        private ArgumentSwitch<A, T> buildInner(Function<CommandContext<class_2168>, T> defaultValue) {
            return new ArgumentSwitch<A, T>(this.name, this.argName, this.type, Objects.requireNonNull(this.getter, "Must specify a getter() for a argument()"), defaultValue, this.suggests);
        }
    }

    public static final class ResourceArgumentSwitchBuilder<T> {
        private final String name;
        private final class_5321<class_2378<T>> registry;
        private String argName;
        private DynamicCommandExceptionType unknownExceptionType;

        private ResourceArgumentSwitchBuilder(String name, class_5321<class_2378<T>> registry) {
            this.name = name;
            this.registry = registry;
            this.argName = ArgumentSwitchBuilder.inferArgName(name);
        }

        public ResourceArgumentSwitchBuilder<T> argName(String argName) {
            this.argName = argName;
            return this;
        }

        public ResourceArgumentSwitchBuilder<T> unknownExceptionType(DynamicCommandExceptionType type) {
            this.unknownExceptionType = type;
            return this;
        }

        public CommandSwitch<class_6880.class_6883<T>> build(class_5321<T> defaultValue) {
            class_5321 registryKey = this.registry;
            DynamicCommandExceptionType exceptionType = Objects.requireNonNull(this.unknownExceptionType, "unknownExceptionType() must be called");
            return new ArgumentSwitch(this.name, this.argName, class_7079.method_41224(registryKey), (context, arg) -> class_7079.method_43777((CommandContext)context, (String)arg, this.registry, (DynamicCommandExceptionType)exceptionType), (Function<CommandContext<class_2168>, class_6880.class_6883>)((Function<CommandContext, class_6880.class_6883>)context -> ((class_2168)context.getSource()).method_30497().method_30530(registryKey).method_46747(defaultValue)), null);
        }

        public CommandSwitch<class_6885<T>> buildRepeatable() {
            class_5321 registryKey = this.registry;
            DynamicCommandExceptionType exceptionType = Objects.requireNonNull(this.unknownExceptionType, "unknownExceptionType() must be called");
            return new RepeatableArgumentSwitch(new ArgumentSwitch(this.name, this.argName, class_7066.method_41170(registryKey), (context, arg) -> class_7066.method_41166((CommandContext)context, (String)arg, (class_5321)registryKey, (DynamicCommandExceptionType)exceptionType), (Function<CommandContext<class_2168>, class_7066.class_7068>)((Function<CommandContext, class_7066.class_7068>)context -> null), null), (context, values) -> {
                class_2378 registry = ((class_2168)context.getSource()).method_30497().method_30530(registryKey);
                return switch (values.size()) {
                    case 0 -> class_6885.method_58563();
                    case 1 -> BingoUtil.toHolderSet(registry, (class_7066.class_7068)values.iterator().next());
                    default -> class_6885.method_40242(values.stream().map(result -> BingoUtil.toHolderSet(registry, result)).flatMap(class_6885::method_40239).distinct().toList());
                };
            });
        }
    }
}

