/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.conditions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.conditions.BingoConditions;
import io.github.gaming32.bingo.util.BingoCodecs;
import io.github.gaming32.bingo.util.BlockPattern;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_169;
import net.minecraft.class_181;
import net.minecraft.class_2090;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2694;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4550;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class BlockPatternCondition
implements class_5341 {
    public static final MapCodec<BlockPatternCondition> CODEC = BingoCodecs.catchIAE(RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().listOf().fieldOf("aisles").forGetter(BlockPatternCondition::aisles), (App)Codec.unboundedMap(BingoCodecs.CHAR, (Codec)class_2090.field_45760).fieldOf("where").forGetter(BlockPatternCondition::where), (App)BlockPattern.Rotations.CODEC.optionalFieldOf("rotations", (Object)BlockPattern.Rotations.HORIZONTAL).forGetter(BlockPatternCondition::rotations)).apply((Applicative)instance, BlockPatternCondition::new)));
    private final List<List<String>> aisles;
    private final Map<Character, class_2090> where;
    private final BlockPattern.Rotations rotations;
    private final BlockPattern blockPattern;

    public BlockPatternCondition(List<List<String>> aisles, Map<Character, class_2090> where, BlockPattern.Rotations rotations) {
        this.aisles = aisles;
        this.where = where;
        this.rotations = rotations;
        this.blockPattern = BlockPatternCondition.buildBlockPattern(aisles, where);
    }

    private static BlockPattern buildBlockPattern(List<List<String>> patternChars, Map<Character, class_2090> where) {
        Map<Character, Predicate> predicates = where.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new BlockPredicateAdapter((class_2090)e.getValue())));
        if (predicates.containsKey(Character.valueOf(' '))) {
            throw new IllegalArgumentException("Block predicate ' ' is predefined and may not be overridden");
        }
        return new BlockPattern((Predicate[][][])patternChars.stream().map(aisle -> {
            Predicate[][] aislePredicates = (Predicate[][])aisle.stream().map(row -> (Predicate[])row.chars().mapToObj(ch -> {
                Predicate predicate;
                Predicate predicate2 = predicate = ch == 32 ? blockInWorld -> true : (Predicate)predicates.get(Character.valueOf((char)ch));
                if (predicate == null) {
                    throw new IllegalArgumentException("Block pattern uses undefined char '" + (char)ch + "'");
                }
                return predicate;
            }).toArray(Predicate[]::new)).toArray(x$0 -> new Predicate[x$0][]);
            ArrayUtils.reverse((Object[])aislePredicates);
            return aislePredicates;
        }).toArray(x$0 -> new Predicate[x$0][][]));
    }

    @NotNull
    public class_5342 method_29325() {
        return BingoConditions.BLOCK_PATTERN.get();
    }

    public List<List<String>> aisles() {
        return this.aisles;
    }

    public Map<Character, class_2090> where() {
        return this.where;
    }

    public BlockPattern.Rotations rotations() {
        return this.rotations;
    }

    public boolean test(class_47 lootContext) {
        class_3218 level = lootContext.method_299();
        class_2338 origin = class_2338.method_49638((class_2374)((class_2374)lootContext.method_35508(class_181.field_24424)));
        return this.blockPattern.find((class_4538)level, origin, this.rotations);
    }

    @NotNull
    public Set<class_169<?>> method_293() {
        return Set.of(class_181.field_24424);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements class_5341.class_210 {
        private final ImmutableList.Builder<List<String>> aisles = ImmutableList.builder();
        private final ImmutableMap.Builder<Character, class_2090> predicatesByChar = ImmutableMap.builder();
        private BlockPattern.Rotations rotations = BlockPattern.Rotations.HORIZONTAL;

        private Builder() {
        }

        public Builder aisle(String ... aisle) {
            this.aisles.add(List.of(aisle));
            return this;
        }

        public Builder where(char symbol, class_2090 predicate) {
            this.predicatesByChar.put((Object)Character.valueOf(symbol), (Object)predicate);
            return this;
        }

        public Builder where(char symbol, class_4550.class_4710 block) {
            return this.where(symbol, class_2090.class_2091.method_22484().method_27989(block).method_9023());
        }

        public Builder rotations(BlockPattern.Rotations rotations) {
            this.rotations = rotations;
            return this;
        }

        @NotNull
        public BlockPatternCondition build() {
            return new BlockPatternCondition((List<List<String>>)this.aisles.build(), (Map<Character, class_2090>)this.predicatesByChar.build(), this.rotations);
        }
    }

    record BlockPredicateAdapter(class_2090 predicate) implements Predicate<class_2694>
    {
        @Override
        public boolean test(class_2694 blockInWorld) {
            class_4538 class_45382 = blockInWorld.method_11679();
            if (!(class_45382 instanceof class_3218)) {
                return false;
            }
            class_3218 level = (class_3218)class_45382;
            return this.predicate.method_9018(level, (double)blockInWorld.method_11683().method_10263() + 0.5, (double)blockInWorld.method_11683().method_10264() + 0.5, (double)blockInWorld.method_11683().method_10260() + 0.5);
        }
    }
}

