/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.goal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.goal.GoalBuilder;
import io.github.gaming32.bingo.data.icons.EmptyIcon;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.progresstrackers.EmptyProgressTracker;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTracker;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.ParsedOrSub;
import io.github.gaming32.bingo.data.subs.SubstitutionContext;
import io.github.gaming32.bingo.ext.CriterionTriggerExt;
import io.github.gaming32.bingo.util.BingoCodecs;
import io.github.gaming32.bingo.util.BingoUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.class_175;
import net.minecraft.class_179;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6899;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8782;
import net.minecraft.class_8824;
import net.minecraft.class_8942;
import net.minecraft.class_8944;

public class BingoGoal {
    public static final Codec<BingoGoal> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, BingoSub.CODEC).optionalFieldOf("bingo_subs", Map.of()).forGetter(BingoGoal::getSubs), (App)Codec.unboundedMap((Codec)Codec.STRING, ParsedOrSub.codec(class_175.field_47188)).fieldOf("criteria").forGetter(BingoGoal::getCriteria), (App)class_8782.field_47184.optionalFieldOf("requirements").forGetter(g -> Optional.of(g.requirements)), (App)ProgressTracker.CODEC.optionalFieldOf("progress", (Object)EmptyProgressTracker.INSTANCE).forGetter(BingoGoal::getProgress), (App)ParsedOrSub.optionalCodec(class_5699.field_33442, "required_count", 1).forGetter(BingoGoal::getRequiredCount), (App)class_6895.method_40340(BingoRegistries.TAG).optionalFieldOf("tags", (Object)class_6885.method_58563()).forGetter(BingoGoal::getTags), (App)ParsedOrSub.codec(class_8824.field_46597).fieldOf("name").forGetter(BingoGoal::getName), (App)ParsedOrSub.codec(class_8824.field_46597).optionalFieldOf("tooltip").forGetter(BingoGoal::getTooltip), (App)class_2960.field_25139.optionalFieldOf("tooltip_icon").forGetter(BingoGoal::getTooltipIcon), (App)ParsedOrSub.optionalCodec(GoalIcon.CODEC, "icon", EmptyIcon.INSTANCE).forGetter(BingoGoal::getIcon), (App)BingoCodecs.optionalPositiveInt("infrequency").forGetter(BingoGoal::getInfrequency), (App)BingoCodecs.minifiedSetField(Codec.STRING, "antisynergy").forGetter(BingoGoal::getAntisynergy), (App)BingoCodecs.minifiedSetField(Codec.STRING, "catalyst").forGetter(BingoGoal::getCatalyst), (App)BingoCodecs.minifiedSetField(Codec.STRING, "reactant").forGetter(BingoGoal::getReactant), (App)class_6899.method_40400(BingoRegistries.DIFFICULTY).fieldOf("difficulty").forGetter(BingoGoal::getDifficulty), (App)class_6903.method_46636((class_5321)class_7924.field_47498)).apply((Applicative)instance, BingoGoal::new)).validate(BingoGoal::validate);
    private final Map<String, BingoSub> subs;
    private final Map<String, ParsedOrSub<class_175<?>>> criteria;
    private final class_8782 requirements;
    private final ProgressTracker progress;
    private final ParsedOrSub<Integer> requiredCount;
    private final class_6885<BingoTag> tags;
    private final ParsedOrSub<class_2561> name;
    private final Optional<ParsedOrSub<class_2561>> tooltip;
    private final Optional<class_2960> tooltipIcon;
    private final ParsedOrSub<GoalIcon> icon;
    private final OptionalInt infrequency;
    private final Set<String> antisynergy;
    private final Set<String> catalyst;
    private final Set<String> reactant;
    private final class_6880<BingoDifficulty> difficulty;
    private final BingoTag.SpecialType specialType;
    private final boolean requiredOnClient;

    public BingoGoal(Map<String, BingoSub> subs, Map<String, ParsedOrSub<class_175<?>>> criteria, Optional<class_8782> requirements, ProgressTracker progress, ParsedOrSub<Integer> requiredCount, class_6885<BingoTag> tags, ParsedOrSub<class_2561> name, Optional<ParsedOrSub<class_2561>> tooltip, Optional<class_2960> tooltipIcon, ParsedOrSub<GoalIcon> icon, OptionalInt infrequency, Collection<String> antisynergy, Collection<String> catalyst, Collection<String> reactant, class_6880<BingoDifficulty> difficulty, class_7871<class_179<?>> triggerTypes) {
        this.subs = ImmutableMap.copyOf(subs);
        this.criteria = ImmutableMap.copyOf(criteria);
        this.requirements = requirements.orElseGet(() -> class_8782.method_53668(criteria.keySet()));
        this.progress = progress;
        this.requiredCount = requiredCount;
        this.tags = tags;
        this.name = name;
        this.tooltip = tooltip;
        this.tooltipIcon = tooltipIcon;
        this.icon = icon;
        this.infrequency = infrequency;
        this.antisynergy = ImmutableSet.copyOf(antisynergy);
        this.catalyst = ImmutableSet.copyOf(catalyst);
        this.reactant = ImmutableSet.copyOf(reactant);
        this.difficulty = difficulty;
        BingoTag.SpecialType specialType = BingoTag.SpecialType.NONE;
        for (class_6880 tag : tags) {
            if (((BingoTag)tag.comp_349()).specialType() == BingoTag.SpecialType.NONE) continue;
            specialType = ((BingoTag)tag.comp_349()).specialType();
            break;
        }
        this.specialType = specialType;
        boolean requiresClient = false;
        Codec triggerCodec = class_5321.method_39154((class_5321)class_7924.field_47498);
        for (ParsedOrSub<class_175<?>> criterion : criteria.values()) {
            Optional trigger;
            class_5321 triggerKey = criterion.serialized().get("trigger").read((Decoder)triggerCodec).result().orElse(null);
            if (triggerKey == null || !(trigger = triggerTypes.method_46746(triggerKey)).isPresent() || !((CriterionTriggerExt)((class_6880.class_6883)trigger.get()).comp_349()).bingo$requiresClientCode()) continue;
            requiresClient = true;
            break;
        }
        this.requiredOnClient = requiresClient;
    }

    public DataResult<BingoGoal> validate() {
        DataResult result = DataResult.success((Object)this);
        LinkedHashSet<String> availableSubs = LinkedHashSet.newLinkedHashSet(this.subs.size());
        SubstitutionContext substitutionContext = SubstitutionContext.createValidationContext(availableSubs);
        for (Map.Entry<String, BingoSub> sub : this.subs.entrySet()) {
            result = BingoUtil.combineError(result, sub.getValue().validate(substitutionContext));
            availableSubs.add(sub.getKey());
        }
        Codec triggerCodec = class_5321.method_39154((class_5321)class_7924.field_47498);
        for (ParsedOrSub<class_175<?>> criterion : this.criteria.values()) {
            result = BingoUtil.combineError(result, criterion.serialized().get("trigger").read((Decoder)triggerCodec));
            result = BingoUtil.combineError(result, criterion.validate(substitutionContext));
        }
        result = BingoUtil.combineError(result, this.requirements.method_54925(this.criteria.keySet()));
        result = BingoUtil.combineError(result, this.progress.validate(this));
        result = BingoUtil.combineError(result, this.requiredCount.validate(substitutionContext));
        for (class_6880 tag : this.tags) {
            BingoTag.SpecialType type = ((BingoTag)tag.comp_349()).specialType();
            if (type == BingoTag.SpecialType.NONE || type == this.specialType) continue;
            result = BingoUtil.combineError(result, () -> "Inconsistent specialTypes: " + String.valueOf((Object)type) + " does not match " + String.valueOf((Object)this.specialType));
        }
        result = BingoUtil.combineError(result, this.name.validate(substitutionContext));
        if (this.tooltip.isPresent()) {
            result = BingoUtil.combineError(result, this.tooltip.get().validate(substitutionContext));
        }
        result = BingoUtil.combineError(result, this.icon.validate(substitutionContext));
        if (this.specialType == BingoTag.SpecialType.FINISH && this.requirements.method_53664() != 1) {
            result = BingoUtil.combineError(result, () -> "\"finish\" goals must have only ORed requirements");
        }
        return result;
    }

    public void validateParsedCriteria(class_8942 reporter, class_7871.class_7872 lootData) {
        this.criteria.forEach((key, criterionOrSub) -> criterionOrSub.ifParsed(criterion -> {
            class_8944 validator = new class_8944(reporter.method_54946((class_8942.class_11336)new class_8942.class_11333(key)), lootData);
            criterion.comp_1924().method_54938(validator);
        }));
    }

    public Map<String, BingoSub> getSubs() {
        return this.subs;
    }

    public Map<String, ParsedOrSub<class_175<?>>> getCriteria() {
        return this.criteria;
    }

    public class_8782 getRequirements() {
        return this.requirements;
    }

    public ProgressTracker getProgress() {
        return this.progress;
    }

    public ParsedOrSub<Integer> getRequiredCount() {
        return this.requiredCount;
    }

    public class_6885<BingoTag> getTags() {
        return this.tags;
    }

    public ParsedOrSub<class_2561> getName() {
        return this.name;
    }

    public Optional<ParsedOrSub<class_2561>> getTooltip() {
        return this.tooltip;
    }

    public Optional<class_2960> getTooltipIcon() {
        return this.tooltipIcon;
    }

    public ParsedOrSub<GoalIcon> getIcon() {
        return this.icon;
    }

    public OptionalInt getInfrequency() {
        return this.infrequency;
    }

    public Set<String> getAntisynergy() {
        return this.antisynergy;
    }

    public Set<String> getCatalyst() {
        return this.catalyst;
    }

    public Set<String> getReactant() {
        return this.reactant;
    }

    public class_6880<BingoDifficulty> getDifficulty() {
        return this.difficulty;
    }

    public BingoTag.SpecialType getSpecialType() {
        return this.specialType;
    }

    public boolean isRequiredOnClient() {
        return this.requiredOnClient;
    }

    public SubstitutionContext buildSubstitutionContext(class_5819 rand) {
        SubstitutionContext result = new SubstitutionContext(LinkedHashMap.newLinkedHashMap(this.subs.size()), rand);
        for (Map.Entry<String, BingoSub> entry : this.subs.entrySet()) {
            result.referable().put(entry.getKey(), entry.getValue().substitute(result));
        }
        return result.harden();
    }

    public class_5250 buildName(SubstitutionContext context) {
        return BingoUtil.ensureHasFallback(this.name.substituteOrThrow(context).method_27661());
    }

    public Optional<class_2561> buildTooltip(SubstitutionContext context) {
        return this.tooltip.map(t -> BingoUtil.ensureHasFallback(((class_2561)t.substituteOrThrow(context)).method_27661()));
    }

    public GoalIcon buildIcon(SubstitutionContext context) {
        return this.icon.substituteOrThrow(context);
    }

    public Map<String, class_175<?>> buildCriteria(SubstitutionContext context) {
        ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)this.criteria.size());
        for (Map.Entry<String, ParsedOrSub<class_175<?>>> entry : this.criteria.entrySet()) {
            result.put((Object)entry.getKey(), entry.getValue().substituteOrThrow(context));
        }
        return result.build();
    }

    public int buildRequiredCount(SubstitutionContext context) {
        return this.requiredCount.substituteOrThrow(context);
    }

    public static GoalBuilder builder(class_2960 id) {
        return new GoalBuilder(id);
    }
}

