/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.goal;

import com.demonwav.mcdev.annotations.Translatable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.JsonSubber;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.data.icons.BlockIcon;
import io.github.gaming32.bingo.data.icons.EmptyIcon;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.progresstrackers.CriterionProgressTracker;
import io.github.gaming32.bingo.data.progresstrackers.EmptyProgressTracker;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTracker;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.ParsedOrSub;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.class_175;
import net.minecraft.class_179;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8782;
import net.minecraft.class_8824;

public final class GoalBuilder {
    public static final ThreadLocal<DynamicOps<JsonElement>> JSON_OPS = ThreadLocal.withInitial(() -> JsonOps.INSTANCE);
    private static final ParsedOrSub<Integer> DEFAULT_REQUIRED_COUNT = ParsedOrSub.fromParsed(class_5699.field_33442, 1);
    private static final ParsedOrSub<GoalIcon> DEFAULT_ICON = ParsedOrSub.fromParsed(GoalIcon.CODEC, EmptyIcon.INSTANCE);
    private final class_2960 id;
    private final ImmutableMap.Builder<String, BingoSub> subs = ImmutableMap.builder();
    private final ImmutableMap.Builder<String, ParsedOrSub<class_175<?>>> criteria = ImmutableMap.builder();
    private Optional<class_8782> requirements = Optional.empty();
    private ProgressTracker progress = EmptyProgressTracker.INSTANCE;
    private ParsedOrSub<Integer> requiredCount = DEFAULT_REQUIRED_COUNT;
    private class_8782.class_8797 requirementsStrategy = class_8782.class_8797.field_16882;
    private final ImmutableSet.Builder<class_5321<BingoTag>> tags = ImmutableSet.builder();
    private Optional<ParsedOrSub<class_2561>> name = Optional.empty();
    private Optional<ParsedOrSub<class_2561>> tooltip = Optional.empty();
    private Optional<class_2960> tooltipIcon = Optional.empty();
    private ParsedOrSub<GoalIcon> icon = DEFAULT_ICON;
    private OptionalInt infrequency = OptionalInt.empty();
    private ImmutableSet.Builder<String> antisynergy = ImmutableSet.builder();
    private final ImmutableSet.Builder<String> catalyst = ImmutableSet.builder();
    private final ImmutableSet.Builder<String> reactant = ImmutableSet.builder();
    private Optional<class_5321<BingoDifficulty>> difficulty;

    GoalBuilder(class_2960 id) {
        this.id = id;
    }

    public GoalBuilder sub(String key, BingoSub sub) {
        this.subs.put((Object)key, (Object)sub);
        return this;
    }

    public GoalBuilder criterion(String key, class_175<?> criterion) {
        this.criteria.put((Object)key, ParsedOrSub.fromParsed(class_175.field_47188, criterion, JSON_OPS.get()));
        return this;
    }

    public GoalBuilder criterion(String key, class_175<?> criterion, Consumer<JsonSubber> subber) {
        JsonSubber json = new JsonSubber((JsonElement)class_175.field_47188.encodeStart(JSON_OPS.get(), criterion).getOrThrow());
        subber.accept(json);
        this.criteria.put((Object)key, ParsedOrSub.parse(class_175.field_47188, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json.json())));
        return this;
    }

    public GoalBuilder requirements(class_8782 requirements) {
        this.requirements = Optional.of(requirements);
        return this;
    }

    public GoalBuilder requirements(class_8782.class_8797 strategy) {
        this.requirementsStrategy = strategy;
        return this;
    }

    public GoalBuilder progress(ProgressTracker progress) {
        this.progress = progress;
        return this;
    }

    public GoalBuilder progress(String criterion) {
        return this.progress(CriterionProgressTracker.unscaled(criterion));
    }

    public GoalBuilder requiredCount(int requiredCount) {
        this.requiredCount = ParsedOrSub.fromParsed(class_5699.field_33442, requiredCount, JSON_OPS.get());
        return this;
    }

    public GoalBuilder requiredCount(BingoSub requiredCountSub) {
        this.requiredCount = ParsedOrSub.fromSub(requiredCountSub, class_5699.field_33442, JSON_OPS.get());
        return this;
    }

    @SafeVarargs
    public final GoalBuilder tags(class_5321<BingoTag> ... tags) {
        this.tags.add((Object[])tags);
        return this;
    }

    public GoalBuilder name(@Translatable(prefix="bingo.goal.") String name) {
        return this.name((class_2561)class_2561.method_43471((String)("bingo.goal." + name)));
    }

    public GoalBuilder name(class_2561 name) {
        this.name = Optional.of(ParsedOrSub.fromParsed(class_8824.field_46597, name, JSON_OPS.get()));
        return this;
    }

    public GoalBuilder name(class_2561 name, Consumer<JsonSubber> subber) {
        JsonSubber json = new JsonSubber((JsonElement)class_8824.field_46597.encodeStart(JSON_OPS.get(), (Object)name).getOrThrow());
        subber.accept(json);
        this.name = Optional.of(ParsedOrSub.parse(class_8824.field_46597, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json.json())));
        return this;
    }

    public GoalBuilder tooltip(@Translatable(prefix="bingo.goal.", suffix=".tooltip") String tooltip) {
        return this.tooltip((class_2561)class_2561.method_43471((String)("bingo.goal." + tooltip + ".tooltip")));
    }

    public GoalBuilder tooltip(class_2561 tooltip) {
        this.tooltip = Optional.of(ParsedOrSub.fromParsed(class_8824.field_46597, tooltip, JSON_OPS.get()));
        return this;
    }

    public GoalBuilder tooltip(class_2561 tooltip, Consumer<JsonSubber> subber) {
        JsonSubber json = new JsonSubber((JsonElement)class_8824.field_46597.encodeStart(JSON_OPS.get(), (Object)tooltip).getOrThrow());
        subber.accept(json);
        this.tooltip = Optional.of(ParsedOrSub.parse(class_8824.field_46597, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json.json())));
        return this;
    }

    public GoalBuilder tooltipIcon(class_2960 tooltipIcon) {
        this.tooltipIcon = Optional.of(tooltipIcon);
        return this;
    }

    public GoalBuilder icon(Object icon) {
        return this.icon(GoalIcon.infer(icon));
    }

    public GoalBuilder icon(Object icon, Consumer<JsonSubber> subber) {
        return this.icon(GoalIcon.infer(icon), subber);
    }

    public GoalBuilder icon(class_2248 icon, class_1935 fallback) {
        return this.icon(BlockIcon.ofBlockAndItem(icon, fallback));
    }

    public GoalBuilder icon(class_2248 icon, class_1935 fallback, Consumer<JsonSubber> subber) {
        return this.icon(BlockIcon.ofBlockAndItem(icon, fallback), subber);
    }

    public GoalBuilder icon(GoalIcon icon) {
        this.icon = ParsedOrSub.fromParsed(GoalIcon.CODEC, icon, JSON_OPS.get());
        return this;
    }

    public GoalBuilder icon(GoalIcon icon, Consumer<JsonSubber> subber) {
        JsonSubber jsonSubber = new JsonSubber((JsonElement)GoalIcon.CODEC.encodeStart(JSON_OPS.get(), (Object)icon).getOrThrow());
        subber.accept(jsonSubber);
        this.icon = ParsedOrSub.parse(GoalIcon.CODEC, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonSubber.json()));
        return this;
    }

    public GoalBuilder infrequency(int infrequency) {
        this.infrequency = OptionalInt.of(infrequency);
        return this;
    }

    public GoalBuilder setAntisynergy(String ... antisynergy) {
        this.antisynergy = ImmutableSet.builderWithExpectedSize((int)antisynergy.length);
        return this.antisynergy(antisynergy);
    }

    public GoalBuilder antisynergy(String ... antisynergy) {
        this.antisynergy.add((Object[])antisynergy);
        return this;
    }

    public GoalBuilder catalyst(String ... catalyst) {
        this.catalyst.add((Object[])catalyst);
        return this;
    }

    public GoalBuilder reactant(String ... reactant) {
        this.reactant.add((Object[])reactant);
        return this;
    }

    public GoalBuilder difficulty(class_5321<BingoDifficulty> difficulty) {
        this.difficulty = Optional.of(difficulty);
        return this;
    }

    public GoalHolder build(class_7225.class_7874 registries) {
        ImmutableMap criteria = this.criteria.build();
        return new GoalHolder(this.id, new BingoGoal((Map<String, BingoSub>)this.subs.buildOrThrow(), (Map<String, ParsedOrSub<class_175<?>>>)criteria, this.requirements.or(() -> Optional.of(this.requirementsStrategy.create((Collection)criteria.keySet()))), this.progress, this.requiredCount, (class_6885<BingoTag>)class_6885.method_40244(arg_0 -> ((class_7225.class_7226)registries.method_46762(BingoRegistries.TAG)).method_46747(arg_0), (Collection)this.tags.build()), this.name.orElseThrow(() -> new IllegalStateException("Bingo goal name has not been set")), this.tooltip, this.tooltipIcon, this.icon, this.infrequency, (Collection<String>)this.antisynergy.build(), (Collection<String>)this.catalyst.build(), (Collection<String>)this.reactant.build(), (class_6880<BingoDifficulty>)registries.method_46762(BingoRegistries.DIFFICULTY).method_46747(this.difficulty.orElseThrow(() -> new IllegalStateException("Bingo goal difficulty has not been set"))), (class_7871<class_179<?>>)registries.method_46762(class_7924.field_47498)));
    }
}

