/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.goal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.gaming32.bingo.Bingo;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.util.ResourceLocations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_8942;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoalManager
extends class_4309<BingoGoal> {
    public static final class_2960 ID = ResourceLocations.bingo("goals");
    private static Map<class_2960, GoalHolder> goals = Map.of();
    private static Map<Integer, List<GoalHolder>> goalsByDifficulty = Map.of();
    private final class_7225.class_7874 registries;

    public GoalManager(class_7225.class_7874 registries) {
        super(registries, BingoGoal.CODEC, BingoRegistries.GOAL);
        this.registries = registries;
    }

    public static Set<class_2960> getGoalIds() {
        return goals.keySet();
    }

    @Nullable
    public static GoalHolder getGoal(class_2960 id) {
        return goals.get(id);
    }

    public static List<GoalHolder> getGoalsByDifficulty(int difficulty) {
        if (difficulty < 0) {
            throw new IllegalArgumentException("Difficulties < 0 aren't allowed");
        }
        return goalsByDifficulty.getOrDefault(difficulty, List.of());
    }

    @NotNull
    public String method_22322() {
        return ID.toString();
    }

    protected void apply(Map<class_2960, BingoGoal> goals, class_3300 resourceManager, class_3695 profiler) {
        ImmutableMap.Builder result = ImmutableMap.builderWithExpectedSize((int)goals.size());
        HashMap<Integer, ImmutableList.Builder> byDifficulty = HashMap.newHashMap((int)this.registries.method_46762(BingoRegistries.DIFFICULTY).method_42017().count());
        for (Map.Entry<class_2960, BingoGoal> entry : goals.entrySet()) {
            BingoGoal goal = entry.getValue();
            GoalHolder holder = new GoalHolder(entry.getKey(), goal);
            this.validate(holder);
            result.put((Object)holder.id(), (Object)holder);
            byDifficulty.computeIfAbsent(((BingoDifficulty)goal.getDifficulty().comp_349()).number(), k -> ImmutableList.builder()).add((Object)holder);
        }
        GoalManager.goals = result.build();
        goalsByDifficulty = (Map)byDifficulty.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ImmutableList.Builder)e.getValue()).build()));
        Bingo.LOGGER.info("Loaded {} bingo goals", (Object)GoalManager.goals.size());
    }

    private void validate(GoalHolder holder) {
        class_8942.class_8943 collector = new class_8942.class_8943();
        holder.goal().validateParsedCriteria((class_8942)collector, (class_7871.class_7872)this.registries);
        if (!collector.method_71349()) {
            Bingo.LOGGER.warn("Found validation problems in goal {}:\n{}", (Object)holder.id(), (Object)collector.method_59906());
        }
    }
}

