/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.subs;

import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.CompoundBingoSub;
import io.github.gaming32.bingo.data.subs.FloatBingoSub;
import io.github.gaming32.bingo.data.subs.IntBingoSub;
import io.github.gaming32.bingo.data.subs.SubBingoSub;
import io.github.gaming32.bingo.data.subs.WrapBingoSub;
import io.github.gaming32.bingo.platform.registry.DeferredRegister;
import io.github.gaming32.bingo.platform.registry.RegistryBuilder;
import io.github.gaming32.bingo.platform.registry.RegistryValue;

public interface BingoSubType<S extends BingoSub> {
    public static final DeferredRegister<BingoSubType<?>> REGISTER = new RegistryBuilder(BingoRegistries.SUB_TYPE).build();
    public static final RegistryValue<BingoSubType<CompoundBingoSub>> COMPOUND = BingoSubType.register("compound", CompoundBingoSub.CODEC);
    public static final RegistryValue<BingoSubType<FloatBingoSub>> FLOAT = BingoSubType.register("float", FloatBingoSub.CODEC);
    public static final RegistryValue<BingoSubType<IntBingoSub>> INT = BingoSubType.register("int", IntBingoSub.CODEC);
    public static final RegistryValue<BingoSubType<SubBingoSub>> SUB = BingoSubType.register("sub", SubBingoSub.CODEC);
    public static final RegistryValue<BingoSubType<WrapBingoSub>> WRAP = BingoSubType.register("wrap", WrapBingoSub.CODEC);

    public MapCodec<S> codec();

    private static <S extends BingoSub> RegistryValue<BingoSubType<S>> register(final String id, final MapCodec<S> codec) {
        return REGISTER.register(id, () -> new BingoSubType<S>(){

            @Override
            public MapCodec<S> codec() {
                return codec;
            }

            public String toString() {
                return "BingoSubType[" + id + "]";
            }
        });
    }

    public static void load() {
    }
}

