/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.subs;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.BingoSubType;
import io.github.gaming32.bingo.data.subs.SubstitutionContext;
import io.github.gaming32.bingo.util.BingoUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import org.jetbrains.annotations.NotNull;

public record CompoundBingoSub(ElementType elementType, Operator operator, List<BingoSub> factors) implements BingoSub
{
    public static final MapCodec<CompoundBingoSub> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ElementType.CODEC.optionalFieldOf("element_type", (Object)ElementType.INT).forGetter(CompoundBingoSub::elementType), (App)Operator.CODEC.fieldOf("operator").forGetter(CompoundBingoSub::operator), (App)class_5699.method_36973((Codec)BingoSub.CODEC.listOf()).fieldOf("factors").forGetter(CompoundBingoSub::factors)).apply((Applicative)instance, CompoundBingoSub::new)).validate(CompoundBingoSub::validate);

    public CompoundBingoSub(ElementType elementType, Operator operator, BingoSub ... factors) {
        this(elementType, operator, List.of(factors));
    }

    private DataResult<CompoundBingoSub> validate() {
        if (!this.elementType.supportedOperators.contains((Object)this.operator)) {
            return DataResult.error(() -> "operator " + String.valueOf((Object)this.operator) + " not supported on element_type " + String.valueOf((Object)this.elementType));
        }
        return DataResult.success((Object)this);
    }

    @Override
    public Dynamic<?> substitute(SubstitutionContext context) {
        BinaryOperator<Dynamic<?>> op = this.elementType.accumulator.apply(this.operator);
        Dynamic result = this.factors.getFirst().substitute(context);
        for (int i = 1; i < this.factors.size(); ++i) {
            result = (Dynamic)op.apply(result, this.factors.get(i).substitute(context));
        }
        return result;
    }

    @Override
    public DataResult<BingoSub> validate(SubstitutionContext context) {
        return this.factors.stream().map(sub -> sub.validate(context)).reduce(DataResult.success((Object)this), BingoUtil::combineError, (a, b) -> a);
    }

    public BingoSubType<CompoundBingoSub> type() {
        return BingoSubType.COMPOUND.get();
    }

    public static enum ElementType implements class_3542
    {
        INT(op -> switch (op.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (a, b) -> a.createInt(a.asInt(0) + b.asInt(0));
            case 1 -> (a, b) -> a.createInt(a.asInt(0) * b.asInt(1));
            case 2 -> (a, b) -> a.createInt(a.asInt(0) - b.asInt(0));
            case 3 -> (a, b) -> a.createInt(a.asInt(0) / b.asInt(1));
        }),
        DOUBLE(op -> switch (op.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (a, b) -> a.createDouble(a.asDouble(0.0) + b.asDouble(0.0));
            case 1 -> (a, b) -> a.createDouble(a.asDouble(0.0) * b.asDouble(1.0));
            case 2 -> (a, b) -> a.createDouble(a.asDouble(0.0) - b.asDouble(0.0));
            case 3 -> (a, b) -> a.createDouble(a.asDouble(0.0) / b.asDouble(1.0));
        }),
        STRING(op -> switch (op.ordinal()) {
            case 0 -> (a, b) -> a.createString(a.asString("") + b.asString(""));
            case 1 -> (a, b) -> a.createString(a.asString("").repeat(b.asInt(1)));
            default -> throw new UnsupportedOperationException(String.valueOf(op) + " on STRING");
        }, Operator.SUM, Operator.MUL),
        ARRAY(op -> switch (op.ordinal()) {
            case 0 -> (a, b) -> a.createList(Stream.concat(a.asStream(), b.asStream()));
            case 1 -> (a, b) -> a.createList(Collections.nCopies(b.asInt(1), a.asList(Function.identity())).stream().flatMap(Collection::stream));
            case 2 -> (a, b) -> a.createList(Multisets.difference((Multiset)ImmutableMultiset.copyOf(a.asStream().iterator()), (Multiset)ImmutableMultiset.copyOf(b.asStream().iterator())).stream());
            default -> throw new UnsupportedOperationException(String.valueOf(op) + " on ARRAY");
        }, Operator.SUM, Operator.MUL, Operator.SUB);

        public static final class_3542.class_7292<ElementType> CODEC;
        public final Function<Operator, BinaryOperator<Dynamic<?>>> accumulator;
        public final Set<Operator> supportedOperators;

        private ElementType(Function<Operator, BinaryOperator<Dynamic<?>>> accumulator) {
            this(accumulator, Operator.values());
        }

        private ElementType(Function<Operator, BinaryOperator<Dynamic<?>>> accumulator, Operator ... supportedOperators) {
            this.accumulator = accumulator;
            this.supportedOperators = Set.of(supportedOperators);
        }

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(ElementType::values);
        }
    }

    public static enum Operator implements class_3542
    {
        SUM,
        MUL,
        SUB,
        DIV;

        public static final class_3542.class_7292<Operator> CODEC;

        @NotNull
        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(Operator::values);
        }
    }
}

