/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.data.subs;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.SubstitutionContext;
import io.github.gaming32.bingo.data.subs.SubstitutionEngine;
import io.github.gaming32.bingo.util.BingoCodecs;
import io.github.gaming32.bingo.util.BingoUtil;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public record ParsedOrSub<T>(Dynamic<?> serialized, Either<DataResult<T>, Codec<T>> valueOrCodec) {
    public static <T> MapCodec<ParsedOrSub<T>> optionalCodec(Codec<T> valueCodec, String key, T defaultValue) {
        ParsedOrSub parsedDefault = ParsedOrSub.fromParsed(valueCodec, defaultValue);
        return ParsedOrSub.codec(valueCodec).optionalFieldOf(key).xmap(optional -> optional.orElse(parsedDefault), value -> {
            Optional parsedValue = value.valueOrCodec.left().flatMap(DataResult::result);
            return parsedValue.isPresent() && parsedValue.get().equals(defaultValue) ? Optional.empty() : Optional.of(value);
        });
    }

    public static <T> Codec<ParsedOrSub<T>> codec(Codec<T> valueCodec) {
        return Codec.PASSTHROUGH.xmap(data -> ParsedOrSub.parse(valueCodec, data), ParsedOrSub::serialized);
    }

    public static <T> ParsedOrSub<T> parse(Codec<T> valueCodec, Dynamic<?> data) {
        if (SubstitutionEngine.hasSubstitutions(data)) {
            return new ParsedOrSub<T>(data, Either.right(valueCodec));
        }
        return new ParsedOrSub<T>(data, Either.left((Object)valueCodec.parse(data)));
    }

    public static <T> ParsedOrSub<T> fromParsed(Codec<T> valueCodec, T value) {
        return ParsedOrSub.fromParsed(valueCodec, value, BingoCodecs.DEFAULT_OPS);
    }

    public static <T> ParsedOrSub<T> fromParsed(Codec<T> valueCodec, T value, DynamicOps<?> ops) {
        return new ParsedOrSub<T>(BingoUtil.toDynamic(valueCodec, value, ops), Either.left((Object)DataResult.success(value)));
    }

    public static <T> ParsedOrSub<T> fromSub(BingoSub sub, Codec<T> valueCodec) {
        return ParsedOrSub.fromSub(sub, valueCodec, BingoCodecs.DEFAULT_OPS);
    }

    public static <T> ParsedOrSub<T> fromSub(BingoSub sub, Codec<T> valueCodec, DynamicOps<?> ops) {
        return new ParsedOrSub<T>(BingoUtil.toDynamic(BingoSub.INNER_CODEC, sub, ops), Either.right(valueCodec));
    }

    public DataResult<ParsedOrSub<T>> validate(SubstitutionContext context) {
        return ((DataResult)this.valueOrCodec.map(Function.identity(), r -> SubstitutionEngine.validateSubstitutions(this.serialized, context))).map(x -> this);
    }

    public DataResult<T> substitute(SubstitutionContext context) {
        return (DataResult)this.valueOrCodec.map(Function.identity(), r -> r.parse(SubstitutionEngine.performSubstitutions(this.serialized, context)));
    }

    public T substituteOrThrow(SubstitutionContext context) {
        return (T)this.substitute(context).getOrThrow(IllegalArgumentException::new);
    }

    public void ifParsed(Consumer<T> consumer) {
        this.valueOrCodec.left().flatMap(DataResult::result).ifPresent(consumer);
    }
}

