/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.fabric;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import io.github.gaming32.bingo.fabric.BingoNetworkingImpl;
import io.github.gaming32.bingo.fabric.FabricConfigurationTaskRegistrar;
import io.github.gaming32.bingo.fabric.event.FabricClientEvents;
import io.github.gaming32.bingo.fabric.event.FabricEvents;
import io.github.gaming32.bingo.fabric.registry.FabricDeferredRegister;
import io.github.gaming32.bingo.network.BingoNetworking;
import io.github.gaming32.bingo.platform.BingoPlatform;
import io.github.gaming32.bingo.platform.event.ClientEvents;
import io.github.gaming32.bingo.platform.event.Event;
import io.github.gaming32.bingo.platform.registrar.ClientTooltipRegistrar;
import io.github.gaming32.bingo.platform.registrar.DataReloadListenerRegistrar;
import io.github.gaming32.bingo.platform.registrar.DatapackRegistryRegistrar;
import io.github.gaming32.bingo.platform.registrar.KeyMappingBuilder;
import io.github.gaming32.bingo.platform.registrar.KeyMappingBuilderImpl;
import io.github.gaming32.bingo.platform.registrar.PictureInPictureRendererRegistrar;
import io.github.gaming32.bingo.platform.registry.DeferredRegister;
import io.github.gaming32.bingo.platform.registry.RegistryBuilder;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.SpecialGuiElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11239;
import net.minecraft.class_11256;
import net.minecraft.class_1269;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class FabricPlatform
extends BingoPlatform {
    private final BingoNetworking networking = new BingoNetworkingImpl();

    public FabricPlatform() {
        this.registerEvents();
    }

    @Override
    public BingoNetworking getNetworking() {
        return this.networking;
    }

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public boolean isModLoaded(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    @Override
    public void registerClientTooltips(Consumer<ClientTooltipRegistrar> handler) {
        final ImmutableMap.Builder factories = ImmutableMap.builder();
        handler.accept(new ClientTooltipRegistrar(){

            @Override
            public <T extends class_5632> void register(Class<T> clazz, Function<? super T, ? extends class_5684> factory) {
                factories.put(clazz, factory);
            }
        });
        ImmutableMap builtFactories = factories.build();
        if (!builtFactories.isEmpty()) {
            TooltipComponentCallback.EVENT.register(component -> {
                Function factory = (Function)builtFactories.get((Object)component.getClass());
                return factory != null ? (class_5684)factory.apply(component) : null;
            });
        }
    }

    @Override
    public void registerPictureInPictureRenderers(Consumer<PictureInPictureRendererRegistrar> handler) {
        handler.accept(FabricPlatform::registerPictureInPictureRenderer);
    }

    private static <S extends class_11256> void registerPictureInPictureRenderer(Class<S> stateClass, Function<class_4597.class_4598, class_11239<S>> factory) {
        SpecialGuiElementRegistry.register(context -> (class_11239)factory.apply(context.vertexConsumers()));
    }

    @Override
    public void registerKeyMappings(Consumer<KeyMappingBuilder> handler) {
        KeyMappingBuilderImpl builder = new KeyMappingBuilderImpl(this){

            @Override
            public class_304.class_11900 registerCategory(class_2960 id) {
                return class_304.class_11900.method_74698((class_2960)id);
            }
        };
        handler.accept(builder);
        builder.registerAll(KeyBindingHelper::registerKeyBinding);
        ClientTickEvents.END_CLIENT_TICK.register(builder::handleAll);
    }

    @Override
    public void registerDataReloadListeners(Consumer<DataReloadListenerRegistrar> handler) {
        ResourceLoader helper = ResourceLoader.get((class_3264)class_3264.field_14190);
        handler.accept((id, listener, dependencies) -> helper.registerReloader(id, new class_3302(){
            private WeakReference<class_7225.class_7874> currentLookup;
            private class_3302 delegate;

            @NotNull
            public CompletableFuture<Void> method_25931(class_3302.class_11558 sharedState, Executor executor, class_3302.class_4045 preparationBarrier, Executor executor2) {
                class_7225.class_7874 lookup = (class_7225.class_7874)sharedState.method_72362(ResourceLoader.RELOADER_REGISTRY_LOOKUP_KEY);
                if (this.currentLookup == null || lookup != this.currentLookup.get()) {
                    this.currentLookup = new WeakReference<class_7225.class_7874>(lookup);
                    this.delegate = (class_3302)listener.apply(lookup);
                }
                return this.delegate.method_25931(sharedState, executor, preparationBarrier, executor2);
            }
        }));
    }

    @Override
    public void registerDatapackRegistries(Consumer<DatapackRegistryRegistrar> handler) {
        handler.accept(new DatapackRegistryRegistrar(this){

            @Override
            public <T> void unsynced(class_5321<class_2378<T>> registryKey, Codec<T> codec) {
                DynamicRegistries.register(registryKey, codec);
            }

            @Override
            public <T> void synced(class_5321<class_2378<T>> registryKey, Codec<T> codec, Codec<T> networkCodec) {
                DynamicRegistries.registerSynced(registryKey, codec, networkCodec, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
            }
        });
    }

    @Override
    public <T> DeferredRegister<T> createDeferredRegister(class_2378<T> registry) {
        return new FabricDeferredRegister<T>(registry);
    }

    @Override
    public <T> DeferredRegister<T> buildDeferredRegister(RegistryBuilder<T> builder) {
        FabricRegistryBuilder fabricBuilder;
        FabricRegistryBuilder fabricRegistryBuilder = fabricBuilder = builder.getDefaultId() != null ? FabricRegistryBuilder.createDefaulted(builder.getKey(), (class_2960)builder.getDefaultId()) : FabricRegistryBuilder.createSimple(builder.getKey());
        if (builder.isSynced()) {
            fabricBuilder.attribute(RegistryAttribute.SYNCED);
        }
        fabricBuilder.attribute(RegistryAttribute.OPTIONAL);
        return new FabricDeferredRegister(fabricBuilder.buildAndRegister());
    }

    private void registerEvents() {
        Event.REGISTER_COMMANDS.setRegistrar(handler -> CommandRegistrationCallback.EVENT.register(handler::register));
        Event.REGISTER_CONFIGURATION_TASKS.setRegistrar(handler -> ServerConfigurationConnectionEvents.CONFIGURE.register((packetListener, server) -> handler.accept(new FabricConfigurationTaskRegistrar(packetListener))));
        Event.PLAYER_JOIN.setRegistrar(arg_0 -> FabricEvents.PLAYER_JOIN.register(arg_0));
        Event.PLAYER_QUIT.setRegistrar(arg_0 -> FabricEvents.PLAYER_QUIT.register(arg_0));
        Event.COPY_PLAYER.setRegistrar(handler -> ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> handler.accept(oldPlayer, newPlayer)));
        Event.SERVER_STARTED.setRegistrar(handler -> ServerLifecycleEvents.SERVER_STARTED.register(handler::accept));
        Event.SERVER_STOPPING.setRegistrar(handler -> ServerLifecycleEvents.SERVER_STOPPING.register(handler::accept));
        Event.SERVER_STOPPED.setRegistrar(handler -> ServerLifecycleEvents.SERVER_STOPPED.register(handler::accept));
        Event.RIGHT_CLICK_ITEM.setRegistrar(handler -> UseItemCallback.EVENT.register((player, world, hand) -> {
            handler.accept(player, hand);
            return class_1269.field_5811;
        }));
        Event.SERVER_EXPLOSION_START.setRegistrar(arg_0 -> FabricEvents.SERVER_EXPLOSION.register(arg_0));
        Event.SERVER_TICK_END.setRegistrar(handler -> ServerTickEvents.END_SERVER_TICK.register(handler::accept));
        if (this.isClient()) {
            ClientEvents.KEY_RELEASED_PRE.setRegistrar(handler -> ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> ScreenKeyboardEvents.allowKeyRelease((class_437)screen).register((screen1, event) -> !handler.onKeyReleased(screen1, event))));
            ClientEvents.MOUSE_RELEASED_PRE.setRegistrar(handler -> ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> ScreenMouseEvents.allowMouseRelease((class_437)screen).register((screen1, event) -> !handler.onMouseReleased(screen1, event))));
            ClientEvents.PLAYER_QUIT.setRegistrar(arg_0 -> FabricClientEvents.PLAYER_QUIT.register(arg_0));
            ClientEvents.CLIENT_TICK_START.setRegistrar(handler -> ClientTickEvents.START_CLIENT_TICK.register(handler::accept));
            ClientEvents.CLIENT_TICK_END.setRegistrar(handler -> ClientTickEvents.END_CLIENT_TICK.register(handler::accept));
        }
    }
}

