/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.fabric.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3497;
import net.minecraft.class_3518;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7367;
import net.minecraft.class_7475;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class BingoDataGenUtil {
    private static final Map<class_1299<?>, Class<? extends class_1297>> ENTITY_TYPE_TO_CLASS = BingoDataGenUtil.createEntityTypeToClassMap();
    private static final Map<class_1792, List<class_2960>> RECIPES_BY_ITEM = BingoDataGenUtil.createRecipesByItemMap();

    private BingoDataGenUtil() {
    }

    public static <T> class_6885.class_6886<T> loadVanillaTag(class_6862<T> tag, class_7225.class_7874 registries) {
        return class_6885.method_40242(BingoDataGenUtil.loadVanillaTagInternal(tag, registries));
    }

    private static <T> List<class_6880<T>> loadVanillaTagInternal(final class_6862<T> tag, final class_7225.class_7874 registries) {
        JsonElement json;
        final class_7225.class_7226 registry = registries.method_46762(tag.comp_326());
        class_7367 resource = class_310.method_1551().method_45573().method_14405(class_3264.field_14190, tag.comp_327().method_45136(class_7924.method_60916((class_5321)tag.comp_326()) + "/" + tag.comp_327().method_12832() + ".json"));
        if (resource == null) {
            throw new IllegalArgumentException("Unknown tag " + String.valueOf(tag));
        }
        try (InputStreamReader input = new InputStreamReader((InputStream)resource.get());){
            json = JsonParser.parseReader((Reader)input);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        class_7475 file = (class_7475)class_7475.field_39269.parse((DynamicOps)registries.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        class_3497.class_7474 lookup = new class_3497.class_7474<class_6880<T>>(){

            @Nullable
            public class_6880<T> element(class_2960 elementLocation, boolean readOnly) {
                return registry.method_46746(class_5321.method_29179((class_5321)tag.comp_326(), (class_2960)elementLocation)).orElse(null);
            }

            @Nullable
            public Collection<class_6880<T>> method_43949(class_2960 tagLocation) {
                return BingoDataGenUtil.loadVanillaTagInternal(class_6862.method_40092((class_5321)tag.comp_326(), (class_2960)tagLocation), registries);
            }
        };
        return file.comp_811().stream().mapMulti((arg_0, arg_1) -> BingoDataGenUtil.lambda$loadVanillaTagInternal$0(lookup, arg_0, arg_1)).distinct().toList();
    }

    public static class_52 loadVanillaLootTable(class_5321<class_52> lootTable, class_7225.class_7874 registries) {
        JsonElement json;
        class_7367 resource = class_310.method_1551().method_45573().method_14405(class_3264.field_14190, lootTable.method_29177().method_45134(path -> "loot_table/" + path + ".json"));
        if (resource == null) {
            throw new IllegalArgumentException("Unknown loot table " + String.valueOf(lootTable));
        }
        try (InputStreamReader input = new InputStreamReader((InputStream)resource.get());){
            json = JsonParser.parseReader((Reader)input);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registries);
        return (class_52)class_52.field_50021.parse((DynamicOps)ops, (Object)json).getOrThrow(JsonParseException::new);
    }

    private static Map<class_1299<?>, Class<? extends class_1297>> createEntityTypeToClassMap() {
        HashMap result = new HashMap();
        int staticFinal = 24;
        for (Field field : class_1299.class.getFields()) {
            class_1299 entityType;
            Type type;
            ParameterizedType type2;
            Type[] typeArgs;
            Type type3;
            if ((field.getModifiers() & 0x18) != 24 || !class_1299.class.isAssignableFrom(field.getType()) || !((type3 = field.getGenericType()) instanceof ParameterizedType) || (typeArgs = (type2 = (ParameterizedType)type3).getActualTypeArguments()).length != 1 || !((type = typeArgs[0]) instanceof Class)) continue;
            Class entityTypeClass = (Class)type;
            try {
                entityType = (class_1299)field.get(null);
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
            result.put(entityType, entityTypeClass.asSubclass(class_1297.class));
        }
        return result;
    }

    @Nullable
    public static <T extends class_1297> Class<T> getEntityTypeClass(class_1299<T> entityType) {
        return ENTITY_TYPE_TO_CLASS.get(entityType);
    }

    private static Map<class_1792, List<class_2960>> createRecipesByItemMap() {
        HashMap<class_1792, List<class_2960>> recipesByItem = new HashMap<class_1792, List<class_2960>>();
        class_3268 packResources = class_310.method_1551().method_45573();
        Set namespaces = packResources.method_14406(class_3264.field_14190);
        for (String namespace : namespaces) {
            packResources.method_14408(class_3264.field_14190, namespace, "recipe", (recipeId, resource) -> {
                JsonElement json;
                try (InputStreamReader input = new InputStreamReader((InputStream)resource.get());){
                    json = JsonParser.parseReader((Reader)input);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (!json.isJsonObject()) {
                    return;
                }
                JsonObject result = class_3518.method_15281((JsonObject)json.getAsJsonObject(), (String)"result", (JsonObject)new JsonObject());
                String id = class_3518.method_15253((JsonObject)result, (String)"id", null);
                if (id == null) {
                    return;
                }
                class_2960 resultId = class_2960.method_12829((String)id);
                class_1792 item = (class_1792)class_7923.field_41178.method_63535(resultId);
                if (item != class_1802.field_8162) {
                    recipesByItem.computeIfAbsent(item, k -> new ArrayList()).add(BingoDataGenUtil.convertRecipeId(recipeId));
                }
            });
        }
        return recipesByItem;
    }

    private static class_2960 convertRecipeId(class_2960 fullPath) {
        return fullPath.method_45134(path -> {
            if (path.startsWith("recipe/")) {
                path = path.substring("recipe/".length());
            }
            if (path.endsWith(".json")) {
                path = path.substring(0, path.length() - ".json".length());
            }
            return path;
        });
    }

    public static List<class_2960> getRecipesForItem(class_1792 item) {
        return RECIPES_BY_ITEM.getOrDefault(item, List.of());
    }

    private static /* synthetic */ void lambda$loadVanillaTagInternal$0(1 lookup, class_3497 entry, Consumer out) {
        entry.method_26790((class_3497.class_7474)lookup, out);
    }
}

