/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.fabric.datagen.goal;

import com.demonwav.mcdev.annotations.Translatable;
import com.google.common.collect.ImmutableList;
import io.github.gaming32.bingo.conditions.BlockPatternCondition;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoTags;
import io.github.gaming32.bingo.data.JsonSubber;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.goal.GoalBuilder;
import io.github.gaming32.bingo.data.goal.GoalHolder;
import io.github.gaming32.bingo.data.icons.CycleIcon;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.icons.ItemIcon;
import io.github.gaming32.bingo.data.icons.ItemTagCycleIcon;
import io.github.gaming32.bingo.data.progresstrackers.CriterionProgressTracker;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.CompoundBingoSub;
import io.github.gaming32.bingo.data.subs.SubBingoSub;
import io.github.gaming32.bingo.triggers.BedRowTrigger;
import io.github.gaming32.bingo.triggers.ExperienceChangeTrigger;
import io.github.gaming32.bingo.triggers.HasSomeFoodItemsTrigger;
import io.github.gaming32.bingo.triggers.HasSomeItemsFromTagTrigger;
import io.github.gaming32.bingo.triggers.MineralPillarTrigger;
import io.github.gaming32.bingo.triggers.RelativeStatsTrigger;
import io.github.gaming32.bingo.triggers.TotalCountInventoryChangeTrigger;
import io.github.gaming32.bingo.util.BingoUtil;
import io.github.gaming32.bingo.util.BlockPattern;
import io.github.gaming32.bingo.util.ResourceLocations;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_205;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_4550;
import net.minecraft.class_4711;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8782;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.class_9356;
import org.jetbrains.annotations.Nullable;

public abstract class DifficultyGoalProvider {
    private final class_5321<BingoDifficulty> difficulty;
    private final String prefix;
    private final BiConsumer<class_2960, BingoGoal> goalAdder;
    protected final class_7225.class_7874 registries;

    protected DifficultyGoalProvider(class_5321<BingoDifficulty> difficulty, BiConsumer<class_2960, BingoGoal> goalAdder, class_7225.class_7874 registries) {
        this.difficulty = difficulty;
        this.prefix = difficulty.method_29177().method_12832() + "/";
        this.goalAdder = goalAdder;
        this.registries = registries;
    }

    protected final void addGoal(GoalBuilder goal) {
        GoalHolder builtGoal = goal.difficulty(this.difficulty).build(this.registries);
        if (!builtGoal.id().method_12832().startsWith(this.prefix)) {
            throw new IllegalArgumentException("Goal ID does not start with " + this.prefix);
        }
        this.goalAdder.accept(builtGoal.id(), builtGoal.goal());
    }

    public abstract void addGoals();

    protected final class_2960 id(String path) {
        return ResourceLocations.bingo(this.prefix + path);
    }

    protected static GoalBuilder obtainItemGoal(class_2960 id, class_7225<class_1792> items, class_5321<class_1792> item) {
        return DifficultyGoalProvider.obtainItemGoal(id, items, (class_1935)items.method_46747(item).comp_349());
    }

    protected static GoalBuilder obtainItemGoal(class_2960 id, class_7225<class_1792> items, class_1935 item) {
        return DifficultyGoalProvider.obtainItemGoal(id, items, item, class_2073.class_2074.method_8973().method_8977(items, new class_1935[]{item})).antisynergy(item.method_8389().method_40131().method_40237().method_29177().method_12832()).name(item.method_8389().method_63680());
    }

    protected static GoalBuilder obtainItemGoal(class_2960 id, class_7225<class_1792> items, class_1935 icon, class_2073.class_2074 ... oneOfThese) {
        return DifficultyGoalProvider.obtainItemGoal(id, items, ItemIcon.ofItem(icon), oneOfThese);
    }

    protected static GoalBuilder obtainItemGoal(class_2960 id, class_7225<class_1792> items, class_1799 icon, class_2073.class_2074 ... oneOfThese) {
        return DifficultyGoalProvider.obtainItemGoal(id, items, new ItemIcon(icon), oneOfThese);
    }

    protected static GoalBuilder obtainItemGoal(class_2960 id, class_7225<class_1792> items, GoalIcon icon, class_2073.class_2074 ... oneOfThese) {
        GoalBuilder builder = BingoGoal.builder(id);
        if (oneOfThese.length == 1) {
            builder.criterion("obtain", TotalCountInventoryChangeTrigger.builder().items(oneOfThese[0].method_8976()).build()).progress("obtain");
        } else {
            for (int i = 0; i < oneOfThese.length; ++i) {
                builder.criterion("obtain_" + i, TotalCountInventoryChangeTrigger.builder().items(oneOfThese[i].method_8976()).build());
            }
            builder.requirements(class_8782.class_8797.field_1257);
        }
        return builder.tags(BingoTags.ITEM).icon(icon);
    }

    protected static GoalBuilder obtainItemGoal(class_2960 id, class_7225<class_1792> items, class_5321<class_1792> item, int minCount, int maxCount) {
        return DifficultyGoalProvider.obtainItemGoal(id, items, (class_1935)items.method_46747(item).comp_349(), minCount, maxCount);
    }

    protected static GoalBuilder obtainItemGoal(class_2960 id, class_7225<class_1792> items, class_1935 item, int minCount, int maxCount) {
        class_1792 realItem = item.method_8389();
        Consumer<JsonSubber> subFunction = minCount == maxCount ? subber -> {} : subber -> subber.sub("with.0", "count");
        return DifficultyGoalProvider.obtainItemGoal(id, item, class_2073.class_2074.method_8973().method_8977(items, new class_1935[]{item}), minCount, maxCount).antisynergy(realItem.method_40131().method_40237().method_29177().method_12832()).name((class_2561)class_2561.method_43469((String)"bingo.count", (Object[])new Object[]{minCount, realItem.method_63680()}), subFunction);
    }

    protected static GoalBuilder obtainItemGoal(class_2960 id, class_1935 icon, class_2073.class_2074 item, int minCount, int maxCount) {
        if (minCount == maxCount) {
            return BingoGoal.builder(id).criterion("obtain", TotalCountInventoryChangeTrigger.builder().items(item.method_35233(class_2096.class_2100.method_9058((int)minCount)).method_8976()).build()).progress("obtain").tags(BingoTags.ITEM).icon(new class_1799(icon, minCount));
        }
        return BingoGoal.builder(id).sub("count", BingoSub.random(minCount, maxCount)).criterion("obtain", TotalCountInventoryChangeTrigger.builder().items(item.method_35233(class_2096.class_2100.method_9053((int)0)).method_8976()).build(), subber -> subber.sub("conditions.items.0.count.min", "count")).progress("obtain").tags(BingoTags.ITEM).icon(icon, subber -> subber.sub("item.count", "count"));
    }

    protected static GoalBuilder obtainSomeItemsFromTag(class_2960 id, class_6862<class_1792> tag, @Translatable String translationKey, int minCount, int maxCount) {
        if (minCount == maxCount) {
            return BingoGoal.builder(id).criterion("obtain", HasSomeItemsFromTagTrigger.builder().tag(tag).requiredCount(minCount).build()).progress("obtain").tags(BingoTags.ITEM).name((class_2561)class_2561.method_43469((String)translationKey, (Object[])new Object[]{minCount})).icon(new ItemTagCycleIcon(tag, minCount));
        }
        return BingoGoal.builder(id).sub("count", BingoSub.random(minCount, maxCount)).criterion("obtain", HasSomeItemsFromTagTrigger.builder().tag(tag).requiredCount(1).build(), subber -> subber.sub("conditions.required_count", "count")).progress("obtain").tags(BingoTags.ITEM).name((class_2561)class_2561.method_43469((String)translationKey, (Object[])new Object[]{0}), subber -> subber.sub("with.0", "count")).icon(new ItemTagCycleIcon(tag), subber -> subber.sub("+count", "count"));
    }

    protected GoalBuilder obtainAllItemsFromTag(class_6862<class_1792> tag, @Translatable(prefix="bingo.goal.all_somethings.") String what) {
        return BingoGoal.builder(this.id("all_" + what)).criterion("obtain", HasSomeItemsFromTagTrigger.builder().tag(tag).requiresAll().build()).progress("obtain").tags(BingoTags.ITEM).name((class_2561)class_2561.method_43469((String)"bingo.goal.all_somethings", (Object[])new Object[]{class_2561.method_43471((String)("bingo.goal.all_somethings." + what))})).antisynergy("all_" + tag.comp_327().method_12832()).icon(new ItemTagCycleIcon(tag));
    }

    protected static GoalBuilder obtainSomeEdibleItems(class_2960 id, int minCount, int maxCount) {
        if (minCount == maxCount) {
            return BingoGoal.builder(id).criterion("obtain", HasSomeFoodItemsTrigger.builder().requiredCount(minCount).build()).progress("obtain").tags(BingoTags.ITEM).name((class_2561)class_2561.method_43469((String)"bingo.goal.edible_items", (Object[])new Object[]{minCount})).tooltip("edible_items").tooltipIcon(ResourceLocations.bingo("textures/gui/tooltips/raw_and_cooked.png")).antisynergy("edible_items").infrequency(2).icon(new ItemTagCycleIcon((class_6862<class_1792>)ConventionalItemTags.FOODS, minCount));
        }
        return BingoGoal.builder(id).sub("count", BingoSub.random(minCount, maxCount)).criterion("obtain", HasSomeFoodItemsTrigger.builder().requiredCount(1).build(), subber -> subber.sub("conditions.required_count", "count")).progress("obtain").tags(BingoTags.ITEM).name((class_2561)class_2561.method_43469((String)"bingo.goal.edible_items", (Object[])new Object[]{0}), subber -> subber.sub("with.0", "count")).tooltip("edible_items").tooltipIcon(ResourceLocations.bingo("textures/gui/tooltips/raw_and_cooked.png")).antisynergy("edible_items").infrequency(2).icon(new ItemTagCycleIcon((class_6862<class_1792>)ConventionalItemTags.FOODS), subber -> subber.sub("+count", "count"));
    }

    protected static GoalBuilder obtainLevelsGoal(class_2960 id, int minLevels, int maxLevels) {
        return BingoGoal.builder(id).sub("count", BingoSub.random(minLevels, maxLevels)).criterion("obtain", ExperienceChangeTrigger.builder().levels(class_2096.class_2100.method_9053((int)0)).build(), subber -> subber.sub("conditions.levels.min", "count")).tags(BingoTags.STAT).name((class_2561)class_2561.method_43469((String)"bingo.goal.levels", (Object[])new Object[]{0}), subber -> subber.sub("with.0", "count")).icon(class_1802.field_8287, subber -> subber.sub("item.count", "count")).infrequency(2).antisynergy("levels");
    }

    protected static GoalBuilder crouchDistanceGoal(class_2960 id, int minDistance, int maxDistance) {
        return BingoGoal.builder(id).sub("distance", BingoSub.random(minDistance, maxDistance)).criterion("crouch", RelativeStatsTrigger.builder().stat(class_3468.field_15376, class_2096.class_2100.method_9053((int)0)).build(), subber -> subber.sub("conditions.stats.0.value.min", new CompoundBingoSub(CompoundBingoSub.ElementType.INT, CompoundBingoSub.Operator.MUL, new SubBingoSub("distance"), BingoSub.literal(100)))).progress(new CriterionProgressTracker("crouch", 0.01f)).name((class_2561)class_2561.method_43469((String)"bingo.goal.crouch_distance", (Object[])new Object[]{0}), subber -> subber.sub("with.0", "distance")).antisynergy("crouch_distance").infrequency(2).tags(BingoTags.ACTION, BingoTags.STAT).icon(class_1802.field_8370, subber -> subber.sub("item.count", "distance"));
    }

    protected static GoalBuilder bedRowGoal(class_2960 id, int minCount, int maxCount) {
        if (minCount == maxCount) {
            return BingoGoal.builder(id).criterion("obtain", BedRowTrigger.create(minCount)).name((class_2561)class_2561.method_43469((String)"bingo.goal.bed_row", (Object[])new Object[]{minCount})).antisynergy("bed_color").infrequency(4).icon(new class_1799((class_1935)class_1802.field_8349, minCount)).tags(BingoTags.BUILD, BingoTags.COLOR, BingoTags.OVERWORLD);
        }
        return BingoGoal.builder(id).sub("count", BingoSub.random(minCount, maxCount)).criterion("obtain", BedRowTrigger.create(1), subber -> subber.sub("conditions.count", "count")).name((class_2561)class_2561.method_43469((String)"bingo.goal.bed_row", (Object[])new Object[]{0}), subber -> subber.sub("with.0", "count")).antisynergy("bed_color").infrequency(4).icon(class_1802.field_8349, subber -> subber.sub("item.count", "count")).tags(BingoTags.BUILD, BingoTags.COLOR, BingoTags.OVERWORLD);
    }

    protected static GoalBuilder mineralPillarGoal(class_2960 id, class_6862<class_2248> tag) {
        return BingoGoal.builder(id).criterion("pillar", MineralPillarTrigger.pillar(tag)).tags(BingoTags.BUILD);
    }

    protected GoalBuilder blockCubeGoal(class_2960 id, Object icon, class_6862<class_2248> blockTag, class_2561 tagName) {
        class_7225.class_7226 blocks = this.registries.method_46762(class_7924.field_41254);
        return BingoGoal.builder(id).sub("width", BingoSub.random(2, 4)).sub("height", BingoSub.random(2, 4)).sub("depth", BingoSub.random(2, 4)).criterion("cube", class_4711.class_4712.method_51712((class_5341.class_210[])new class_5341.class_210[]{class_205.method_884((class_2090.class_2091)class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_29233((class_7871)blocks, blockTag))), BlockPatternCondition.builder().aisle("#").where('#', class_4550.class_4710.method_23880().method_29233((class_7871)blocks, blockTag)).rotations(BlockPattern.Rotations.ALL)}), subber -> subber.sub("conditions.location.1.aisles", new CompoundBingoSub(CompoundBingoSub.ElementType.ARRAY, CompoundBingoSub.Operator.MUL, BingoSub.wrapInArray(new CompoundBingoSub(CompoundBingoSub.ElementType.ARRAY, CompoundBingoSub.Operator.MUL, BingoSub.wrapInArray(new CompoundBingoSub(CompoundBingoSub.ElementType.STRING, CompoundBingoSub.Operator.MUL, BingoSub.literal("#"), new SubBingoSub("width"))), new SubBingoSub("height"))), new SubBingoSub("depth")))).tags(BingoTags.BUILD, BingoTags.OVERWORLD).name((class_2561)class_2561.method_43469((String)"bingo.goal.cube", (Object[])new Object[]{0, 0, 0, tagName}), subber -> subber.sub("with.0", "width").sub("with.1", "height").sub("with.2", "depth")).tooltip("cube").icon(icon);
    }

    protected static class_1799 makeItemWithGlint(class_1935 item) {
        return DifficultyGoalProvider.makeItemWithGlint(new class_1799(item));
    }

    protected static class_1799 makeItemWithGlint(class_1799 item) {
        item.method_57379(class_9334.field_49641, (Object)true);
        return item;
    }

    protected static class_1799 makeBannerWithPattern(class_1792 base, class_6880<class_2582> pattern, class_1767 color) {
        class_1799 result = new class_1799((class_1935)base);
        result.method_57379(class_9334.field_49619, (Object)new class_9307.class_3750().method_16376(pattern, color).method_57573());
        return result;
    }

    protected static class_1799 makeShieldWithColor(@Nullable class_1767 color) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8255);
        stack.method_57379(class_9334.field_49620, (Object)color);
        return stack;
    }

    protected static class_4550.class_4710 spawnerPredicate(class_7225<class_2248> blocks, class_7225<class_1299<?>> entityTypes, class_1299<?> entityType) {
        return class_4550.class_4710.method_23880().method_27962(blocks, new class_2248[]{class_2246.field_10260}).method_35042(BingoUtil.compound(Map.of("SpawnData", BingoUtil.compound(Map.of("entity", BingoUtil.compound(Map.of("id", class_2519.method_23256((String)entityType.method_40124().method_40237().method_29177().toString()))))))));
    }

    protected static GoalIcon createPotionsIcon(class_7225<class_1842> potions, class_1792 baseItem) {
        HashSet encountered = new HashSet();
        return new CycleIcon((List)potions.method_42017().filter(p -> encountered.add(((class_1842)p.comp_349()).method_63990())).map(p -> class_1844.method_57400((class_1792)baseItem, (class_6880)p)).map(ItemIcon::new).collect(ImmutableList.toImmutableList()));
    }

    protected static class_9356.class_9357 createAnyEnchantmentsRequirement() {
        return class_9356.method_58173(List.of(new class_2035(Optional.empty(), class_2096.class_2100.method_9053((int)1))));
    }

    protected static class_9356.class_9358 createAnyStoredEnchantmentsRequirement() {
        return class_9356.method_58176(List.of(new class_2035(Optional.empty(), class_2096.class_2100.method_9053((int)1))));
    }

    protected static class_5321<class_1792> itemResource(String path) {
        return class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)ResourceLocations.minecraft(path));
    }
}

