/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.fabric.datagen.goal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import io.github.gaming32.bingo.conditions.BlockCondition;
import io.github.gaming32.bingo.conditions.BlockPatternCondition;
import io.github.gaming32.bingo.conditions.OneByOneHoleCondition;
import io.github.gaming32.bingo.conditions.WearingDifferentArmorCondition;
import io.github.gaming32.bingo.data.BingoDifficulties;
import io.github.gaming32.bingo.data.BingoTags;
import io.github.gaming32.bingo.data.goal.BingoGoal;
import io.github.gaming32.bingo.data.goal.GoalBuilder;
import io.github.gaming32.bingo.data.icons.BlockIcon;
import io.github.gaming32.bingo.data.icons.CycleIcon;
import io.github.gaming32.bingo.data.icons.EntityIcon;
import io.github.gaming32.bingo.data.icons.GoalIcon;
import io.github.gaming32.bingo.data.icons.IndicatorIcon;
import io.github.gaming32.bingo.data.icons.ItemIcon;
import io.github.gaming32.bingo.data.icons.ItemTagCycleIcon;
import io.github.gaming32.bingo.data.subs.BingoSub;
import io.github.gaming32.bingo.data.subs.CompoundBingoSub;
import io.github.gaming32.bingo.data.subs.SubBingoSub;
import io.github.gaming32.bingo.data.tags.bingo.BingoBlockTags;
import io.github.gaming32.bingo.data.tags.bingo.BingoDamageTypeTags;
import io.github.gaming32.bingo.data.tags.bingo.BingoEntityTypeTags;
import io.github.gaming32.bingo.data.tags.bingo.BingoFeatureTags;
import io.github.gaming32.bingo.data.tags.bingo.BingoItemTags;
import io.github.gaming32.bingo.fabric.datagen.BingoDataGenUtil;
import io.github.gaming32.bingo.fabric.datagen.goal.DifficultyGoalProvider;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.triggers.BounceOnBlockTrigger;
import io.github.gaming32.bingo.triggers.EntityDieNearPlayerTrigger;
import io.github.gaming32.bingo.triggers.EntityKilledPlayerTrigger;
import io.github.gaming32.bingo.triggers.EquipItemTrigger;
import io.github.gaming32.bingo.triggers.ExplosionTrigger;
import io.github.gaming32.bingo.triggers.GrowBeeNestTreeTrigger;
import io.github.gaming32.bingo.triggers.GrowFeatureTrigger;
import io.github.gaming32.bingo.triggers.IntentionalGameDesignTrigger;
import io.github.gaming32.bingo.triggers.ItemPickedUpTrigger;
import io.github.gaming32.bingo.triggers.KillSelfTrigger;
import io.github.gaming32.bingo.triggers.LeashedEntityTrigger;
import io.github.gaming32.bingo.triggers.PulledByLeashTrigger;
import io.github.gaming32.bingo.triggers.RelativeStatsTrigger;
import io.github.gaming32.bingo.util.BingoUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_10192;
import net.minecraft.class_10914;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1311;
import net.minecraft.class_174;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_184;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_196;
import net.minecraft.class_2010;
import net.minecraft.class_2019;
import net.minecraft.class_2022;
import net.minecraft.class_2025;
import net.minecraft.class_2030;
import net.minecraft.class_2048;
import net.minecraft.class_2066;
import net.minecraft.class_2069;
import net.minecraft.class_207;
import net.minecraft.class_2073;
import net.minecraft.class_2080;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2108;
import net.minecraft.class_212;
import net.minecraft.class_2128;
import net.minecraft.class_2131;
import net.minecraft.class_2135;
import net.minecraft.class_215;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2494;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_3483;
import net.minecraft.class_3489;
import net.minecraft.class_3765;
import net.minecraft.class_4550;
import net.minecraft.class_47;
import net.minecraft.class_4711;
import net.minecraft.class_5258;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5409;
import net.minecraft.class_6407;
import net.minecraft.class_6646;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7446;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8129;
import net.minecraft.class_8508;
import net.minecraft.class_8782;
import net.minecraft.class_9307;
import net.minecraft.class_9323;
import net.minecraft.class_9329;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9359;
import net.minecraft.class_9360;
import net.minecraft.class_9361;

public class MediumGoalProvider
extends DifficultyGoalProvider {
    public MediumGoalProvider(BiConsumer<class_2960, BingoGoal> goalAdder, class_7225.class_7874 registries) {
        super(BingoDifficulties.MEDIUM, goalAdder, registries);
    }

    @Override
    public void addGoals() {
        class_7225.class_7226 bannerPatterns = this.registries.method_46762(class_7924.field_41252);
        class_7225.class_7226 entityTypes = this.registries.method_46762(class_7924.field_41266);
        class_7225.class_7226 items = this.registries.method_46762(class_7924.field_41197);
        class_7225.class_7226 blocks = this.registries.method_46762(class_7924.field_41254);
        this.addGoal(MediumGoalProvider.obtainSomeEdibleItems(this.id("edible_items"), 6, 7).tags(BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("beetroot_soup"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8515).tags(BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("potted_cactus")).criterion("pot", class_174.field_24478.method_53699((class_184)new class_4711.class_4712(Optional.empty(), Optional.of(class_5258.method_27973((class_5341[])new class_5341[]{class_212.method_900((class_2248)class_2246.field_10018).build()}))))).tags(BingoTags.ACTION, BingoTags.RARE_BIOME, BingoTags.OVERWORLD).name("potted_cactus").icon(class_2246.field_10018, (class_1935)class_2246.field_10029));
        this.addGoal(BingoGoal.builder(this.id("shoot_tnt_minecart")).criterion("explode", ExplosionTrigger.builder().source(class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6053)).build()).name((class_2561)class_2561.method_43469((String)"bingo.goal.shoot_tnt_minecart", (Object[])new Object[]{class_1299.field_6053.method_5897()})).icon(CycleIcon.infer(MediumGoalProvider.makeItemWithGlint((class_1935)class_1802.field_8102), class_1802.field_8107, class_1802.field_8069)).tags(BingoTags.ACTION, BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("magma_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8354, 10, 30));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("damaged_anvil"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8427));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("melon_slice"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8497, 16, 64).tags(BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("never_wear_armor")).criterion("equip", EquipItemTrigger.builder().newItem(class_2073.class_2074.method_8973().method_8975((class_7871)items, ConventionalItemTags.ARMORS).method_8976()).slots(class_1304.class_1305.field_6178).build()).tags(BingoTags.NEVER).name("never_wear_armor").icon(class_1802.field_8058).antisynergy("never_wear_armor").catalyst("wear_armor"));
        this.addGoal(BingoGoal.builder(this.id("skeleton_bow")).criterion("pickup", ItemPickedUpTrigger.TriggerInstance.pickedUpFrom(class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8102}).method_8976(), class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6137).method_8920())).reactant("pacifist").tags(BingoTags.ITEM, BingoTags.COMBAT).name("skeleton_bow").icon(class_1802.field_8102));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("diamond_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8603).infrequency(2));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("lapis_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8055, 2, 3).tags(BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainSomeItemsFromTag(this.id("different_saplings"), (class_6862<class_1792>)class_3489.field_15528, "bingo.goal.different_saplings", 3, 5).tags(BingoTags.ITEM, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("tame_wolf")).criterion("obtain", class_2131.class_2133.method_16114((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6055))).tags(BingoTags.STAT, BingoTags.RARE_BIOME, BingoTags.OVERWORLD).name("tame_wolf").icon(class_1802.field_8606));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("fire_charge"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8814, 6, 6).tags(BingoTags.NETHER, BingoTags.COMBAT));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("magma_cream"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8135, 2, 3).tags(BingoTags.NETHER, BingoTags.COMBAT));
        this.addGoal(BingoGoal.builder(this.id("create_iron_golem")).criterion("summon", class_2128.class_2130.method_9129((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6147))).tags(BingoTags.ACTION, BingoTags.OVERWORLD).name((class_2561)class_2561.method_43469((String)"bingo.goal.create_iron_golem", (Object[])new Object[]{class_1299.field_6147.method_5897()})).icon(EntityIcon.ofSpawnEgg(class_1299.field_6147)));
        this.addGoal(BingoGoal.builder(this.id("create_copper_golem")).criterion("summon", class_2128.class_2130.method_9129((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_61221))).tags(BingoTags.ACTION, BingoTags.OVERWORLD).name((class_2561)class_2561.method_43469((String)"bingo.goal.create_copper_golem", (Object[])new Object[]{class_1299.field_61221.method_5897()})).icon(EntityIcon.ofSpawnEgg(class_1299.field_61221)));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("ender_eye"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8449).reactant("pacifist").tags(BingoTags.NETHER, BingoTags.COMBAT));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("rabbit_stew"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8308).tags(BingoTags.OVERWORLD));
        this.addGoal(this.potionGoal("fire_resistance_potion", (class_7225<class_1792>)items, class_1847.field_8987, class_1847.field_8969));
        this.addGoal(this.potionGoal("healing_potion", (class_7225<class_1792>)items, class_1847.field_8963, class_1847.field_8980).tags(BingoTags.OVERWORLD, BingoTags.COMBAT));
        this.addGoal(this.potionGoal("poison_potion", (class_7225<class_1792>)items, class_1847.field_8982, class_1847.field_9002, class_1847.field_8972).tags(BingoTags.OVERWORLD, BingoTags.COMBAT));
        this.addGoal(this.potionGoal("harming_potion", (class_7225<class_1792>)items, class_1847.field_9004, class_1847.field_8973).tags(BingoTags.OVERWORLD, BingoTags.COMBAT));
        this.addGoal(this.potionGoal("regeneration_potion", (class_7225<class_1792>)items, class_1847.field_8986, class_1847.field_9003, class_1847.field_8992).tags(BingoTags.COMBAT));
        this.addGoal(this.potionGoal("slowness_potion", (class_7225<class_1792>)items, class_1847.field_8996, class_1847.field_8989, class_1847.field_8976).tags(BingoTags.OVERWORLD, BingoTags.COMBAT));
        this.addGoal(this.potionGoal("strength_potion", (class_7225<class_1792>)items, class_1847.field_8978, class_1847.field_8965, class_1847.field_8993).tags(BingoTags.COMBAT));
        this.addGoal(this.potionGoal("swiftness_potion", (class_7225<class_1792>)items, class_1847.field_9005, class_1847.field_8983, class_1847.field_8966).tags(BingoTags.OVERWORLD, BingoTags.COMBAT));
        this.addGoal(this.potionGoal("weakness_potion", (class_7225<class_1792>)items, class_1847.field_8975, class_1847.field_8970).tags(BingoTags.OVERWORLD, BingoTags.COMBAT));
        this.addGoal(this.potionGoal("leaping_potion", (class_7225<class_1792>)items, class_1847.field_8979, class_1847.field_8971, class_1847.field_8998).tags(BingoTags.RARE_BIOME, BingoTags.OVERWORLD, BingoTags.COMBAT));
        this.addGoal(this.potionGoal("slow_falling_potion", (class_7225<class_1792>)items, class_1847.field_8974, class_1847.field_8964).tags(BingoTags.COMBAT, BingoTags.OVERWORLD));
        this.addGoal(this.potionGoal("turtle_master_potion", (class_7225<class_1792>)items, class_1847.field_8990, class_1847.field_8988, class_1847.field_8977).tags(BingoTags.OCEAN, BingoTags.OVERWORLD, BingoTags.COMBAT));
        this.addGoal(BingoGoal.builder(this.id("finish_by_free_falling")).criterion("free_fall", class_2108.class_2110.method_38851((class_2048.class_2049)class_2048.class_2049.method_8916().method_8918(class_2090.class_2091.method_53181((class_2096.class_2099)class_2096.class_2099.method_35286((double)-59.0))), (class_2025)class_2025.method_8856((class_2096.class_2099)class_2096.class_2099.method_9050((double)379.0)), (class_2090.class_2091)class_2090.class_2091.method_53181((class_2096.class_2099)class_2096.class_2099.method_9050((double)319.0)))).tags(BingoTags.ACTION, BingoTags.BUILD, BingoTags.OVERWORLD, BingoTags.FINISH).name("finish_by_free_falling").tooltip((class_2561)class_2561.method_43471((String)"advancements.adventure.fall_from_world_height.description")).icon(class_1802.field_8705));
        this.addGoal(BingoGoal.builder(this.id("vegetarian")).criterion("meat", class_2010.class_2012.method_35112((class_2073.class_2074)class_2073.class_2074.method_8973().method_8975((class_7871)items, BingoItemTags.MEAT))).tags(BingoTags.NEVER, BingoTags.ACTION).antisynergy("food").catalyst("eat_meat").name("vegetarian").tooltip("vegetarian").icon(new ItemTagCycleIcon(BingoItemTags.NOT_MEAT)));
        this.addGoal(BingoGoal.builder(this.id("kill_self_with_arrow")).criterion("kill", KillSelfTrigger.TriggerInstance.killSelf(class_2022.class_2023.method_8855().method_48785(class_8129.method_48965((class_6862)class_8103.field_42247)).method_8854(class_2048.class_2049.method_8916().method_8922((class_7871)entityTypes, class_3483.field_21508)).method_8851())).tags(BingoTags.ACTION).name("kill_self_with_arrow").icon(class_1802.field_8107));
        this.addGoal(BingoGoal.builder(this.id("while_trying_to_escape")).criterion("die", EntityKilledPlayerTrigger.builder().sourceEntity(class_5258.method_27973((class_5341[])new class_5341[]{new class_215(Optional.empty(), class_47.class_50.field_935), class_207.method_889((class_5341.class_210)class_215.method_27865((class_47.class_50)class_47.class_50.field_935, (class_2048)class_2048.class_2049.method_8916().method_8920())).build()})).build()).tags(BingoTags.ACTION).name("while_trying_to_escape").tooltip("while_trying_to_escape").icon(class_1802.field_8470));
        this.addGoal(BingoGoal.builder(this.id("finish_on_top")).criterion("on_top", class_2135.class_2137.method_43137((class_2090.class_2091)class_2090.class_2091.method_53181((class_2096.class_2099)class_2096.class_2099.method_9050((double)319.0)))).tags(BingoTags.ACTION, BingoTags.BUILD, BingoTags.FINISH).name("finish_on_top").tooltip("finish_on_top").icon(new class_1799((class_1935)class_1802.field_8831, 320)));
        this.addGoal(BingoGoal.builder(this.id("sized_nether_portal")).sub("width", BingoSub.random(4, 6)).sub("height", BingoSub.random(4, 6)).criterion("activate", class_4711.class_4712.method_51712((class_5341.class_210[])new class_5341.class_210[]{class_212.method_900((class_2248)class_2246.field_10316), BlockPatternCondition.builder().aisle("P").where('P', class_4550.class_4710.method_23880().method_27962((class_7871)blocks, new class_2248[]{class_2246.field_10316}))}), subber -> subber.sub("conditions.location.1.aisles.0", new CompoundBingoSub(CompoundBingoSub.ElementType.ARRAY, CompoundBingoSub.Operator.MUL, BingoSub.wrapInArray(new CompoundBingoSub(CompoundBingoSub.ElementType.STRING, CompoundBingoSub.Operator.MUL, BingoSub.literal("P"), new SubBingoSub("width"))), new SubBingoSub("height")))).tags(BingoTags.ACTION, BingoTags.BUILD, BingoTags.NETHER).name((class_2561)class_2561.method_43469((String)"bingo.goal.sized_nether_portal", (Object[])new Object[]{0, 0}), subber -> subber.sub("with.0", "width").sub("with.1", "height")).icon(new CycleIcon(BlockIcon.ofBlockAndItem(class_2246.field_10316, (class_1935)class_2246.field_10540), BlockIcon.ofBlock(class_2246.field_10540)), subber -> subber.sub("icons.0.item.count", new CompoundBingoSub(CompoundBingoSub.ElementType.INT, CompoundBingoSub.Operator.MUL, new SubBingoSub("width"), new SubBingoSub("height"))).sub("icons.1.item.count", new CompoundBingoSub(CompoundBingoSub.ElementType.INT, CompoundBingoSub.Operator.SUM, new SubBingoSub("width"), new SubBingoSub("width"), new SubBingoSub("height"), new SubBingoSub("height")))));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("obsidian"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8281, 3, 10));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("iron_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8773, 5, 7).infrequency(2));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("gold_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8494, 2, 4).infrequency(2));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("daylight_detector"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8566).tags(BingoTags.OVERWORLD, BingoTags.NETHER));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("enchanted_golden_sword"), (class_7225<class_1792>)items, new ItemIcon(MediumGoalProvider.makeItemWithGlint((class_1935)class_1802.field_8845)), class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8845}).method_57299(class_10914.class_10915.method_68683().method_68685(class_9361.field_49807, (class_9360)MediumGoalProvider.createAnyEnchantmentsRequirement()).method_68686())).name("enchanted_golden_sword"));
        this.addGoal(MediumGoalProvider.obtainSomeItemsFromTag(this.id("wool_colors"), (class_6862<class_1792>)class_3489.field_15544, "bingo.goal.wool_colors", 8, 11).antisynergy("wool_color").infrequency(4).tags(BingoTags.COLOR, BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainSomeItemsFromTag(this.id("terracotta"), (class_6862<class_1792>)class_3489.field_36270, "bingo.goal.colors_of_terracotta", 8, 11).tags(BingoTags.COLOR, BingoTags.OVERWORLD).reactant("use_furnace").antisynergy("terracotta_color").infrequency(4));
        this.addGoal(MediumGoalProvider.obtainSomeItemsFromTag(this.id("glazed_terracotta"), (class_6862<class_1792>)ConventionalItemTags.GLAZED_TERRACOTTAS, "bingo.goal.glazed_terracotta", 7, 10).reactant("use_furnace").antisynergy("glazed_terracotta_color").infrequency(4).tags(BingoTags.COLOR, BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainSomeItemsFromTag(this.id("concrete"), (class_6862<class_1792>)ConventionalItemTags.CONCRETES, "bingo.goal.concrete", 7, 10).antisynergy("concrete_color").infrequency(4).tags(BingoTags.COLOR, BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.bedRowGoal(this.id("bed_row"), 7, 10));
        this.addGoal(MediumGoalProvider.obtainSomeItemsFromTag(this.id("different_flowers"), (class_6862<class_1792>)ConventionalItemTags.FLOWERS, "bingo.goal.different_flowers", 8, 10).antisynergy("flowers").infrequency(2).tags(BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.mineralPillarGoal(this.id("basic_mineral_blocks"), BingoBlockTags.BASIC_MINERAL_BLOCKS).name("basic_mineral_blocks").tags(BingoTags.OVERWORLD).icon(new ItemTagCycleIcon(BingoItemTags.BASIC_MINERAL_BLOCKS)));
        this.addGoal(MediumGoalProvider.obtainLevelsGoal(this.id("levels"), 16, 26).infrequency(2));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("red_nether_bricks"), (class_7225<class_1792>)items, (class_1935)class_1802.field_20410, 16, 32).reactant("use_furnace").tags(BingoTags.NETHER));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("spectral_arrow"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8236, 16, 32).tags(BingoTags.NETHER));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("rotten_flesh"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8511, 33, 64).infrequency(2));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("ink_sac"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8794, 16, 32).infrequency(2).tags(BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("slime_ball"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8777, 5, 9).tags(BingoTags.RARE_BIOME, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("lead_on_rabbit")).criterion("use", class_5409.class_5410.method_43278((class_2073.class_2074)class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8719}), Optional.of(class_2048.method_53134((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6140))))).name((class_2561)class_2561.method_43469((String)"bingo.goal.lead_on_rabbit", (Object[])new Object[]{class_1802.field_8719.method_63680(), class_1299.field_6140.method_5897()})).tags(BingoTags.ACTION, BingoTags.RARE_BIOME, BingoTags.OVERWORLD).icon(class_1802.field_8719));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("firework_star"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8450).tags(BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("hang_mob")).criterion("hang", PulledByLeashTrigger.builder().knotRequired(true).force(class_2025.method_8856((class_2096.class_2099)class_2096.class_2099.method_9050((double)0.1))).build()).name("hang_mob").tooltip("hang_mob").icon(CycleIcon.infer(class_1299.field_6093, class_1802.field_8719, class_1802.field_8792)).reactant("pacifist").tags(BingoTags.ACTION, BingoTags.RARE_BIOME, BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("blaze_rod"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8894).reactant("pacifist").tags(BingoTags.NETHER, BingoTags.COMBAT));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("ghast_tear"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8070).reactant("pacifist").tags(BingoTags.NETHER, BingoTags.COMBAT));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("glowstone_dust"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8601, 32, 64).tags(BingoTags.NETHER));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("item_frame"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8143, 10, 32));
        this.addGoal(MediumGoalProvider.obtainSomeItemsFromTag(this.id("diamond_in_name"), BingoItemTags.DIAMOND_IN_NAME, "bingo.goal.diamond_in_name", 3, 4).antisynergy("diamond_items").tooltip("diamond_in_name"));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("prismarine_crystals"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8434, 2, 4).infrequency(2).tags(BingoTags.OCEAN, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("one_by_one_hole")).criterion("hole", class_174.field_1194.method_53699((class_184)new class_2135.class_2137(Optional.of(class_5258.method_27973((class_5341[])new class_5341[]{new OneByOneHoleCondition(-59, 63, class_6646.method_38877((class_6646)class_6646.method_39585()))}))))).name("one_by_one_hole").tooltip("one_by_one_hole").tags(BingoTags.ACTION, BingoTags.OVERWORLD).icon(class_1802.field_8377));
        this.addGoal(BingoGoal.builder(this.id("break_diamond_sword")).criterion("break", class_2069.class_2071.method_35229(Optional.of(class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8802}).method_8976()), (class_2096.class_2100)class_2096.class_2100.method_35289((int)0))).name("break_diamond_sword").icon(class_1802.field_8802).tags(BingoTags.ACTION, BingoTags.STAT).reactant("sword_use"));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("saddle"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8175));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("heart_of_the_sea"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8207).tags(BingoTags.OCEAN, BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("phantom_membrane"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8614).reactant("pacifist").tags(BingoTags.COMBAT, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("marker_on_map")).criterion("use", class_4711.class_4712.method_27981((class_2090.class_2091)class_2090.class_2091.method_22484(), (class_2073.class_2074)class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8204}))).tags(BingoTags.ACTION, BingoTags.OVERWORLD).name("marker_on_map").icon(class_1802.field_8128));
        this.addGoal(BingoGoal.builder(this.id("water_lava_milk_fish")).criterion("buckets", class_2066.class_2068.method_53160((class_2073.class_2074[])new class_2073.class_2074[]{class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8705}), class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8187}), class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8103}), class_2073.class_2074.method_8973().method_8975((class_7871)items, BingoItemTags.FISH_BUCKETS)})).tags(BingoTags.ITEM, BingoTags.OVERWORLD).name((class_2561)class_2561.method_43469((String)"bingo.four", (Object[])new Object[]{class_1802.field_8705.method_63680(), class_1802.field_8187.method_63680(), class_1802.field_8103.method_63680(), class_2561.method_43471((String)BingoItemTags.FISH_BUCKETS.getTranslationKey())})).tooltip((class_2561)class_2561.method_43469((String)"bingo.goal.fish_bucket.tooltip", (Object[])new Object[]{class_2561.method_43471((String)"advancements.husbandry.tactical_fishing.title")})).icon(new CycleIcon(ItemIcon.ofItem((class_1935)class_1802.field_8705), ItemIcon.ofItem((class_1935)class_1802.field_8187), ItemIcon.ofItem((class_1935)class_1802.field_8103), new ItemTagCycleIcon(BingoItemTags.FISH_BUCKETS))).antisynergy("bucket_types", "water_bucket", "lava_bucket", "milk_bucket", "fish_bucket").reactant("use_buckets"));
        this.addGoal(BingoGoal.builder(this.id("leash_dolphin_to_fence")).criterion("leash", LeashedEntityTrigger.builder().mob(class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6087).method_8920()).build()).tags(BingoTags.ACTION, BingoTags.OCEAN, BingoTags.RARE_BIOME, BingoTags.OVERWORLD).name("leash_dolphin_to_fence").icon(IndicatorIcon.infer(CycleIcon.infer(class_1802.field_8792, class_1299.field_6087), class_1802.field_8719)));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("dried_kelp_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_17533, 21, 32).tags(BingoTags.OCEAN, BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("gunpowder"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8054, 6, 15).infrequency(2).tags(BingoTags.COMBAT));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("spider_eye"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8680, 6, 15).infrequency(2).tags(BingoTags.COMBAT, BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("ender_pearl"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8634, 4, 6).infrequency(2).tags(BingoTags.COMBAT));
        this.addGoal(BingoGoal.builder(this.id("enchant_item")).criterion("enchant", class_2030.class_2032.method_8877()).name("enchant_item").icon(MediumGoalProvider.makeItemWithGlint((class_1935)class_1802.field_8371)).antisynergy("enchant").tags(BingoTags.ACTION, BingoTags.OVERWORLD));
        class_1799 shieldItem = new class_1799((class_1935)class_1802.field_8255);
        shieldItem.method_57379(class_9334.field_49620, (Object)class_1767.field_7966);
        shieldItem.method_57379(class_9334.field_49619, (Object)new class_9307.class_3750().method_16376((class_6880)bannerPatterns.method_46747(class_7446.field_39148), class_1767.field_7952).method_57573());
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("blue_shield_with_white_flower_charge"), (class_7225<class_1792>)items, shieldItem, class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8255}).method_57299(class_10914.class_10915.method_68683().method_68684(class_9329.method_64096((class_9323)shieldItem.method_57353(), (class_9331[])new class_9331[]{class_9334.field_49620, class_9334.field_49619})).method_68686())).name((class_2561)class_2561.method_43469((String)"bingo.goal.item_with_pattern", (Object[])new Object[]{class_2561.method_43471((String)(class_1802.field_8255.method_7876() + "." + class_1767.field_7966.method_7792())), class_2561.method_43471((String)("block.minecraft.banner." + class_7446.field_39148.method_29177().method_43903() + "." + class_1767.field_7952.method_7792()))})).tags(BingoTags.ITEM, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("tame_cat")).criterion("obtain", class_2131.class_2133.method_16114((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_16281))).name("tame_cat").tags(BingoTags.ACTION, BingoTags.VILLAGE, BingoTags.OVERWORLD).icon(EntityIcon.ofSpawnEgg(class_1299.field_16281)));
        this.addGoal(BingoGoal.builder(this.id("breed_mobs")).sub("count", BingoSub.random(5, 7)).criterion("breed", RelativeStatsTrigger.builder().stat(class_3468.field_15410, class_2096.class_2100.method_9053((int)0)).build(), subber -> subber.sub("conditions.stats.0.value.min", "count")).progress("breed").name((class_2561)class_2561.method_43469((String)"bingo.goal.breed_mobs", (Object[])new Object[]{0}), subber -> subber.sub("with.0", "count")).tooltip("breed_mobs").icon(class_1802.field_8317).antisynergy("breed_animals").infrequency(2).tags(BingoTags.ACTION, BingoTags.STAT));
        this.addGoal(MediumGoalProvider.crouchDistanceGoal(this.id("crouch_distance"), 200, 400));
        this.addGoal(BingoGoal.builder(this.id("kill_mobs")).sub("count", BingoSub.random(75, 100)).criterion("kill", RelativeStatsTrigger.builder().stat(class_3468.field_15414, class_2096.class_2100.method_9053((int)0)).build(), subber -> subber.sub("conditions.stats.0.value.min", "count")).progress("kill").name((class_2561)class_2561.method_43469((String)"bingo.goal.kill_mobs", (Object[])new Object[]{0}), subber -> subber.sub("with.0", "count")).icon(IndicatorIcon.infer(new CycleIcon((List)entityTypes.method_42017().map(class_6880.class_6883::comp_349).filter(t -> !class_7701.method_45406((class_7699)t.method_45322())).filter(t -> t.method_5891() != class_1311.field_17715).filter(t -> class_1826.method_8019((class_1299)t) != null).map(EntityIcon::ofSpawnEgg).map(i -> i).collect(ImmutableList.toImmutableList())), class_1802.field_8802)).reactant("pacifist").antisynergy("mob_kills").tags(BingoTags.ACTION, BingoTags.COMBAT, BingoTags.STAT));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("seagrass"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8158, 33, 64).infrequency(2).tags(BingoTags.OCEAN, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("kill_golem")).criterion("kill", class_2080.class_2083.method_8997((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6147))).name((class_2561)class_2561.method_43469((String)"bingo.goal.kill_golem", (Object[])new Object[]{class_1299.field_6147.method_5897()})).icon(IndicatorIcon.infer(class_1299.field_6147, class_1802.field_8802)).reactant("pacifist").tags(BingoTags.ACTION, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("kill_with_crystal")).criterion("kill", class_2080.class_2083.method_35249(Optional.empty(), (class_2022.class_2023)class_2022.class_2023.method_8855().method_8854(class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6110)))).name((class_2561)class_2561.method_43469((String)"bingo.goal.kill_with_crystal", (Object[])new Object[]{class_1299.field_6110.method_5897()})).icon(class_1802.field_8301).reactant("pacifist").tags(BingoTags.ACTION, BingoTags.OVERWORLD, BingoTags.NETHER, BingoTags.COMBAT));
        GoalBuilder neverCraftSticksBuilder = BingoGoal.builder(this.id("never_craft_sticks"));
        for (class_2960 stickRecipeId : BingoDataGenUtil.getRecipesForItem(class_1802.field_8600)) {
            neverCraftSticksBuilder.criterion("craft_" + stickRecipeId.method_12836() + "_" + stickRecipeId.method_12832(), class_8508.class_8509.method_51352((class_5321)class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)stickRecipeId)));
        }
        this.addGoal(neverCraftSticksBuilder.requirements(class_8782.class_8797.field_1257).tags(BingoTags.NEVER, BingoTags.OVERWORLD).name("never_craft_sticks").icon(class_1802.field_8600));
        this.addGoal(BingoGoal.builder(this.id("kill_hostile_with_berries")).criterion("kill", EntityDieNearPlayerTrigger.builder().entity(class_2048.class_2049.method_8916().method_8922((class_7871)entityTypes, BingoEntityTypeTags.HOSTILE).method_8920()).killingBlow(class_2019.class_2020.method_8844().method_8842(class_2022.class_2023.method_8855().method_48785(class_8129.method_48965(BingoDamageTypeTags.BERRY_BUSH))).method_8843()).build()).name((class_2561)class_2561.method_43469((String)"bingo.goal.kill_hostile_with_berries", (Object[])new Object[]{class_2246.field_16999.method_9518()})).icon(IndicatorIcon.infer(BingoEntityTypeTags.HOSTILE, class_1802.field_16998)).reactant("pacifist").tags(BingoTags.ACTION, BingoTags.OVERWORLD, BingoTags.COMBAT, BingoTags.RARE_BIOME));
        this.addGoal(BingoGoal.builder(this.id("pillager_crossbow")).criterion("pickup", ItemPickedUpTrigger.TriggerInstance.pickedUpFrom(class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8399}).method_8976(), class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6105).method_8920())).reactant("pacifist").tags(BingoTags.ITEM, BingoTags.COMBAT, BingoTags.OVERWORLD, BingoTags.RARE_BIOME).name("pillager_crossbow").icon(class_1802.field_8399));
        class_1799 ominousBanner = class_3765.method_61558((class_7871)bannerPatterns);
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("ominous_banner"), (class_7225<class_1792>)items, ominousBanner, class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{ominousBanner.method_7909()}).method_57299(class_10914.class_10915.method_68683().method_68684(class_9329.method_64096((class_9323)ominousBanner.method_57353(), (class_9331[])new class_9331[]{class_9334.field_49619, class_9334.field_50239})).method_68686())).antisynergy("ominous_banner").name((class_2561)class_2561.method_43471((String)"block.minecraft.ominous_banner")).reactant("pacifist").tags(BingoTags.COMBAT, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("gain_fox_trust")).criterion("breed", class_196.class_198.method_861((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_17943))).name((class_2561)class_2561.method_43469((String)"bingo.goal.gain_fox_trust", (Object[])new Object[]{class_1299.field_17943.method_5897()})).icon(EntityIcon.ofSpawnEgg(class_1299.field_17943)).tags(BingoTags.ACTION, BingoTags.OVERWORLD, BingoTags.RARE_BIOME));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("honey_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_21086).setAntisynergy("honey").infrequency(2).tags(BingoTags.ACTION, BingoTags.OVERWORLD));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("honeycomb_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_21087, 3, 3).setAntisynergy("honeycomb").infrequency(2).tags(BingoTags.ACTION, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("repair_iron_golem")).criterion("repair", class_5409.class_5410.method_43278((class_2073.class_2074)class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_8620}), Optional.of(class_2048.method_53134((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_6147))))).name((class_2561)class_2561.method_43469((String)"bingo.goal.repair_iron_golem", (Object[])new Object[]{class_1299.field_6147.method_5897()})).icon(EntityIcon.ofSpawnEgg(class_1299.field_6147, BingoUtil.compound(Map.of("Health", class_2494.method_23244((float)40.0f))))).tags(BingoTags.ACTION, BingoTags.OVERWORLD, BingoTags.VILLAGE));
        this.addGoal(BingoGoal.builder(this.id("grow_tree_with_bee_nest")).criterion("grow", GrowBeeNestTreeTrigger.TriggerInstance.grew()).name((class_2561)class_2561.method_43469((String)"bingo.goal.grow_tree_with_bee_nest", (Object[])new Object[]{class_2246.field_20421.method_9518()})).icon(class_1802.field_20415).tags(BingoTags.ACTION, BingoTags.OVERWORLD));
        for (String woodType : List.of("warped", "crimson")) {
            this.addGoal(MediumGoalProvider.obtainItemGoal(this.id(woodType + "_stem"), (class_7225<class_1792>)items, MediumGoalProvider.itemResource(woodType + "_stem"), 16, 32).infrequency(25).tags(BingoTags.NETHER));
            this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("stripped_" + woodType + "_stem"), (class_7225<class_1792>)items, MediumGoalProvider.itemResource("stripped_" + woodType + "_stem"), 16, 32).infrequency(25).tags(BingoTags.NETHER));
            this.addGoal(MediumGoalProvider.obtainItemGoal(this.id(woodType + "_hyphae"), (class_7225<class_1792>)items, MediumGoalProvider.itemResource(woodType + "_hyphae"), 16, 32).infrequency(25).tags(BingoTags.NETHER));
            this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("stripped_" + woodType + "_hyphae"), (class_7225<class_1792>)items, MediumGoalProvider.itemResource("stripped_" + woodType + "_hyphae"), 16, 32).infrequency(25).tags(BingoTags.NETHER));
            this.addGoal(MediumGoalProvider.obtainItemGoal(this.id(woodType + "_planks"), (class_7225<class_1792>)items, MediumGoalProvider.itemResource(woodType + "_planks"), 16, 32).infrequency(25).tags(BingoTags.NETHER));
        }
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("quartz_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_20402).tags(BingoTags.NETHER));
        this.addGoal(BingoGoal.builder(this.id("anchor_in_overworld")).criterion("anchor", IntentionalGameDesignTrigger.TriggerInstance.clicked(class_2090.class_2091.method_53182((class_5321)class_1937.field_25179).method_9023())).tags(BingoTags.ACTION, BingoTags.NETHER, BingoTags.OVERWORLD).name((class_2561)class_2561.method_43469((String)"bingo.goal.anchor_in_overworld", (Object[])new Object[]{class_2246.field_23152.method_9518()})).icon(class_2246.field_23152));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("warped_fungus_on_a_stick"), (class_7225<class_1792>)items, (class_1935)class_1802.field_23254).tags(BingoTags.NETHER));
        this.addGoal(BingoGoal.builder(this.id("ride_strider")).criterion("ride", class_6407.class_6408.method_37260((class_2048.class_2049)class_2048.class_2049.method_8916().method_27971(class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_23214)))).name((class_2561)class_2561.method_43469((String)"bingo.goal.ride_strider", (Object[])new Object[]{class_1299.field_23214.method_5897()})).icon(EntityIcon.ofSpawnEgg(class_1299.field_23214)).tags(BingoTags.ACTION, BingoTags.NETHER));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("bamboo"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8648, 6, 15).tags(BingoTags.OVERWORLD, BingoTags.RARE_BIOME));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("crying_obsidian"), (class_7225<class_1792>)items, (class_1935)class_1802.field_22421));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("grass_block"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8270).tooltip("grass_block").tags(BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("bounce_on_slime")).criterion("bounce", BounceOnBlockTrigger.TriggerInstance.bounceOnBlock(class_4550.class_4710.method_23880().method_27962((class_7871)blocks, new class_2248[]{class_2246.field_10030}))).name((class_2561)class_2561.method_43469((String)"bingo.goal.bounce_on_slime", (Object[])new Object[]{class_2246.field_10030.method_9518()})).icon(class_1802.field_8828).tags(BingoTags.ACTION, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("full_gold_armor")).criterion("obtain", class_2066.class_2068.method_8959((class_1935[])new class_1935[]{class_1802.field_8753, class_1802.field_8416, class_1802.field_8678, class_1802.field_8862})).name("full_gold_armor").icon(new CycleIcon(ItemIcon.ofItem((class_1935)class_1802.field_8753), ItemIcon.ofItem((class_1935)class_1802.field_8416), ItemIcon.ofItem((class_1935)class_1802.field_8678), ItemIcon.ofItem((class_1935)class_1802.field_8862))).tags(BingoTags.ITEM));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("brown_wool"), (class_7225<class_1792>)items, (class_1935)class_1802.field_19056).tags(BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("grow_nether_fungus")).criterion("grow", GrowFeatureTrigger.builder().feature(BingoFeatureTags.HUGE_FUNGI).build()).name("grow_nether_fungus").icon(new CycleIcon(ItemIcon.ofItem((class_1935)class_1802.field_21987), ItemIcon.ofItem((class_1935)class_1802.field_21988))).antisynergy("grow_fungus").tags(BingoTags.ACTION, BingoTags.NETHER));
        this.addGoal(BingoGoal.builder(this.id("never_place_torches")).criterion("place", class_4711.class_4712.method_51712((class_5341.class_210[])new class_5341.class_210[]{BlockCondition.builder(class_4550.class_4710.method_23880().method_29233((class_7871)blocks, BingoBlockTags.TORCHES))})).tags(BingoTags.NEVER).name("never_place_torches").tooltip("never_place_torches").icon(class_1802.field_8810));
        this.addGoal(MediumGoalProvider.obtainItemGoal(this.id("turtle_scute"), (class_7225<class_1792>)items, (class_1935)class_1802.field_8161).setAntisynergy("turtle_helmet").tags(BingoTags.OCEAN, BingoTags.OVERWORLD));
        this.addGoal(BingoGoal.builder(this.id("all_different_armor")).criterion("armor", class_174.field_1195.method_53699((class_184)new class_2066.class_2068(Optional.of(class_5258.method_27973((class_5341[])new class_5341[]{new WearingDifferentArmorCondition(class_2096.class_2100.method_9053((int)4), class_2096.class_2100.method_9053((int)4))})), class_2066.class_2068.class_8948.field_47265, List.of()))).tags(BingoTags.ITEM).reactant("wear_armor").name((class_2561)class_2561.method_43469((String)"bingo.goal.all_different_armor", (Object[])new Object[]{4})).icon(this.createAllDifferentMaterialsIcon()));
        this.addGoal(BingoGoal.builder(this.id("equip_wolf_armor")).criterion("equip", class_5409.class_5410.method_43278((class_2073.class_2074)class_2073.class_2074.method_8973().method_8977((class_7871)items, new class_1935[]{class_1802.field_42716}), Optional.of(class_2048.method_53134((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921((class_7871)entityTypes, class_1299.field_47754))))).tags(BingoTags.ACTION, BingoTags.OVERWORLD).name("equip_wolf_armor").icon(IndicatorIcon.infer(class_1299.field_6055, class_1802.field_47831)));
        this.addGoal(this.obtainAllItemsFromTag(BingoItemTags.TORCHES, "torches").tags(BingoTags.OVERWORLD, BingoTags.NETHER));
        this.addGoal(BingoGoal.builder(this.id("swap_hotbar_with_shelf")).criterion("swap", BingoTriggers.hotbarSwappedWithShelf()).tags(BingoTags.ACTION).antisynergy("shelf").name("swap_hotbar_with_shelf").tooltip("swap_hotbar_with_shelf").icon(IndicatorIcon.infer(class_3489.field_61218, class_1802.field_8802)));
    }

    @SafeVarargs
    private GoalBuilder potionGoal(String id, class_7225<class_1792> items, class_6880<class_1842> ... potions) {
        class_1799 potionItem = class_1844.method_57400((class_1792)class_1802.field_8574, potions[0]);
        GoalBuilder builder = MediumGoalProvider.obtainItemGoal(this.id(id), items, potionItem, (class_2073.class_2074[])Arrays.stream(potions).map(potion -> class_2073.class_2074.method_8973().method_8977((class_7871)this.registries.method_46762(class_7924.field_41197), new class_1935[]{class_1802.field_8574}).method_57299(class_10914.class_10915.method_68683().method_68685(class_9361.field_49809, (class_9360)new class_9359((class_6885)class_6885.method_40246((class_6880[])new class_6880[]{potion}))).method_68686())).toArray(class_2073.class_2074[]::new)).antisynergy(id).name(class_1802.field_8574.method_7864(potionItem)).infrequency(12).tags(BingoTags.NETHER);
        if (potions[0] != class_1847.field_8987) {
            builder.reactant("pacifist");
        }
        return builder;
    }

    private GoalIcon createAllDifferentMaterialsIcon() {
        int iterations = 4;
        Table<class_1304, class_2960, class_1792> armors = this.getArmors();
        ImmutableList materials = ImmutableList.copyOf((Collection)armors.columnKeySet());
        ImmutableList.Builder icons = ImmutableList.builderWithExpectedSize((int)(4 * armors.rowMap().size()));
        int materialIndex = 0;
        for (int iteration = 0; iteration < 4; ++iteration) {
            for (class_1304 type : armors.rowKeySet()) {
                class_1792 item;
                while ((item = (class_1792)armors.get((Object)type, materials.get(materialIndex++ % materials.size()))) == null) {
                }
                icons.add((Object)ItemIcon.ofItem((class_1935)item));
            }
        }
        return new CycleIcon((List<GoalIcon>)icons.build());
    }

    private Table<class_1304, class_2960, class_1792> getArmors() {
        ImmutableTable.Builder armors = ImmutableTable.builder();
        armors.orderRowsBy((Comparator)Ordering.natural());
        armors.orderColumnsBy((Comparator)Ordering.natural());
        Stream.of(class_3489.field_48297, class_3489.field_48296, class_3489.field_48295, class_3489.field_48294).map(tag -> BingoDataGenUtil.loadVanillaTag(tag, this.registries)).flatMap(class_6885::method_40239).distinct().map(class_6880::comp_349).forEach(item -> {
            class_10192 equippable = (class_10192)item.method_57347().method_58694(class_9334.field_54196);
            if (equippable == null || equippable.comp_3176().isEmpty()) {
                return;
            }
            armors.put((Object)equippable.comp_3174(), (Object)((class_5321)equippable.comp_3176().get()).method_29177(), item);
        });
        return armors.build();
    }
}

