/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game;

import com.mojang.serialization.Codec;
import io.github.gaming32.bingo.util.Vec2i;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public enum BoardShape implements class_3542
{
    SQUARE(0, "square", 1, 7){

        @Override
        public int getGoalCount(int size) {
            return class_3532.method_34954((int)size);
        }

        @Override
        public List<int[]> getLines(int size) {
            ArrayList<int[]> lines = new ArrayList<int[]>(2 * size + 2);
            for (int i = 0; i < size; ++i) {
                int[] row = new int[size];
                for (int j = 0; j < size; ++j) {
                    row[j] = i * size + j;
                }
                lines.add(row);
                int[] col = new int[size];
                for (int j = 0; j < size; ++j) {
                    col[j] = j * size + i;
                }
                lines.add(col);
            }
            int[] diagonal1 = new int[size];
            for (int i = 0; i < size; ++i) {
                diagonal1[i] = i * size + i;
            }
            lines.add(diagonal1);
            int[] diagonal2 = new int[size];
            for (int i = 0; i < size; ++i) {
                diagonal2[i] = (size - i - 1) * size + i;
            }
            lines.add(diagonal2);
            return lines;
        }

        @Override
        public Vec2i getVisualSize(int size) {
            return new Vec2i(size, size);
        }

        @Override
        public Vec2i getCoords(int size, int cell) {
            return new Vec2i(cell % size, cell / size);
        }

        @Override
        public int getCellFromCoords(int size, int x, int y) {
            return y * size + x;
        }
    }
    ,
    NERF_EXPANDED(1, "nerf_expanded", 2, 6){

        @Override
        public int getGoalCount(int size) {
            return class_3532.method_34954((int)(size + 1)) + 1;
        }

        @Override
        public List<int[]> getLines(int size) {
            ArrayList<int[]> lines = new ArrayList<int[]>(2 * size + 2);
            for (int i = 0; i < size; ++i) {
                int[] row = new int[size + 1];
                row[0] = class_3532.method_34954((int)size) + i;
                for (int j = 0; j < size; ++j) {
                    row[j + 1] = i * size + j;
                }
                lines.add(row);
                int[] col = new int[size + 1];
                col[0] = class_3532.method_34954((int)size) + size + i;
                for (int j = 0; j < size; ++j) {
                    col[j + 1] = j * size + i;
                }
                lines.add(col);
            }
            int[] diagonal1 = new int[size + 1];
            diagonal1[0] = class_3532.method_34954((int)size) + 2 * size + 1;
            for (int i = 0; i < size; ++i) {
                diagonal1[i + 1] = i * size + i;
            }
            lines.add(diagonal1);
            int[] diagonal2 = new int[size + 1];
            diagonal2[0] = class_3532.method_34954((int)size) + 2 * size;
            for (int i = 0; i < size; ++i) {
                diagonal2[i + 1] = (size - i - 1) * size + i;
            }
            lines.add(diagonal2);
            return lines;
        }

        @Override
        public Vec2i getVisualSize(int size) {
            return new Vec2i(size + 2, size + 2);
        }

        @Override
        public Vec2i getCoords(int size, int cell) {
            if (cell < class_3532.method_34954((int)size)) {
                return new Vec2i(cell % size + 1, cell / size + 1);
            }
            if (cell < class_3532.method_34954((int)size) + size) {
                int row = cell - class_3532.method_34954((int)size);
                return new Vec2i(2.getRowExtensionX(size, row), row + 1);
            }
            if (cell < class_3532.method_34954((int)size) + 2 * size) {
                int col = cell - class_3532.method_34954((int)size) - size;
                return new Vec2i(col + 1, 2.getColExtensionY(size, col));
            }
            if (cell == class_3532.method_34954((int)size) + 2 * size) {
                return new Vec2i(0, size + 1);
            }
            return new Vec2i(size + 1, size + 1);
        }

        @Override
        public int getCellFromCoords(int size, int x, int y) {
            if (x >= 1 && x <= size && y >= 1 && y <= size) {
                return (y - 1) * size + x - 1;
            }
            if (y >= 1 && y <= size) {
                return x == 2.getRowExtensionX(size, y - 1) ? class_3532.method_34954((int)size) + y - 1 : -1;
            }
            if (x >= 1 && x <= size) {
                return y == 2.getColExtensionY(size, x - 1) ? class_3532.method_34954((int)size) + size + x - 1 : -1;
            }
            if (x == 0 && y == size + 1) {
                return class_3532.method_34954((int)size) + 2 * size;
            }
            if (x == size + 1 && y == size + 1) {
                return class_3532.method_34954((int)size) + 2 * size + 1;
            }
            return -1;
        }

        private static int getRowExtensionX(int size, int row) {
            if (size % 2 == 0) {
                return row % 2 == 0 ? size + 1 : 0;
            }
            return row != 0 && row % 2 == 0 ? 0 : size + 1;
        }

        private static int getColExtensionY(int size, int col) {
            if (size % 2 == 0) {
                return col % 2 == 0 ? 0 : size + 1;
            }
            return col != 0 && col % 2 == 0 ? size + 1 : 0;
        }

        @Override
        public boolean isNerfCell(int size, int cell) {
            return cell >= class_3532.method_34954((int)size);
        }
    };

    public static final Codec<BoardShape> CODEC;
    private static final IntFunction<BoardShape> BY_ID;
    public static final class_9139<ByteBuf, BoardShape> STREAM_CODEC;
    private final int id;
    private final String name;
    private final int minSize;
    private final int maxSize;

    private BoardShape(int id, String name, int minSize, int maxSize) {
        this.id = id;
        this.name = name;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public abstract int getGoalCount(int var1);

    public abstract List<int[]> getLines(int var1);

    public abstract Vec2i getVisualSize(int var1);

    public abstract Vec2i getCoords(int var1, int var2);

    public abstract int getCellFromCoords(int var1, int var2, int var3);

    public boolean isNerfCell(int size, int cell) {
        return false;
    }

    public final int getMinSize() {
        return this.minSize;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    @NotNull
    public final String method_15434() {
        return this.name;
    }

    private int getId() {
        return this.id;
    }

    static {
        CODEC = class_3542.method_28140(BoardShape::values);
        BY_ID = class_7995.method_47914(BoardShape::getId, (Object[])BoardShape.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
        STREAM_CODEC = class_9135.method_56375(BY_ID, BoardShape::getId);
    }
}

