/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo.game.persistence.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import io.github.gaming32.bingo.game.persistence.PersistenceTypes;
import io.github.gaming32.bingo.game.persistence.ReferenceOrTag;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1220;

public class TagRenameFix
extends DataFix {
    private final DSL.TypeReference unhashedTypeReference;
    private final DSL.TypeReference hashedTypeReference;
    private final String name;
    private final Map<String, String> renames;

    public TagRenameFix(Schema outputSchema, DSL.TypeReference unhashedTypeReference, DSL.TypeReference hashedTypeReference, Map<String, String> renames, String name) {
        super(outputSchema, false);
        this.unhashedTypeReference = unhashedTypeReference;
        this.hashedTypeReference = hashedTypeReference;
        this.name = name;
        this.renames = renames;
    }

    public static TagRenameFix items(Schema outputSchema, Map<String, String> renames) {
        return new TagRenameFix(outputSchema, PersistenceTypes.ITEM_TAG, PersistenceTypes.ITEM_TAG_OR_REFERENCE, renames, "ItemTagRenameFix");
    }

    protected TypeRewriteRule makeRule() {
        Type unhashed = DSL.named((String)this.unhashedTypeReference.typeName(), (Type)class_1220.method_28295());
        if (!Objects.equals(this.getInputSchema().getType(this.unhashedTypeReference), unhashed)) {
            throw new IllegalStateException("Unhashed type was incorrect");
        }
        TypeRewriteRule unhashedFix = this.fixTypeEverywhere("Unhashed " + this.name, unhashed, dynamic -> pair -> pair.mapSecond(tag -> this.renames.getOrDefault(tag, (String)tag)));
        Type hashed = DSL.named((String)this.hashedTypeReference.typeName(), ReferenceOrTag.TYPE);
        if (!Objects.equals(this.getInputSchema().getType(this.hashedTypeReference), hashed)) {
            throw new IllegalStateException("Hashed type was incorrect");
        }
        TypeRewriteRule hashedFix = this.fixTypeEverywhere("Hashed " + this.name, hashed, dynamic -> pair -> pair.mapSecond(tagOrReference -> {
            if (!tagOrReference.startsWith("#")) {
                return tagOrReference;
            }
            String newTag = this.renames.get(tagOrReference.substring(1));
            return newTag != null ? "#" + newTag : tagOrReference;
        }));
        return TypeRewriteRule.seq((TypeRewriteRule)unhashedFix, (TypeRewriteRule)hashedFix);
    }
}

